/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.networking.GridServicesInternal;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridService;
import appeng.api.networking.IGridServiceProvider;
import appeng.api.networking.IGridStorage;
import appeng.api.networking.events.GridEvent;
import appeng.core.AELog;
import appeng.core.worlddata.IGridStorageSaveData;
import appeng.hooks.ticking.TickHandler;
import appeng.me.GridEventBus;
import appeng.me.GridNode;
import appeng.me.GridStorage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.CrashReportCategory;
import net.minecraft.world.level.Level;

public class Grid
implements IGrid {
    private static final List<IGridNode> ITERATION_BUFFER = new ArrayList<IGridNode>();
    private static int nextSerial = 0;
    private final SetMultimap<Class<?>, IGridNode> machines = MultimapBuilder.hashKeys().hashSetValues().build();
    private final Map<Class<?>, IGridServiceProvider> services;
    private GridNode pivot;
    private int priority;
    private GridStorage myStorage;
    private final int serialNumber = nextSerial++;

    public static Grid create(GridNode center) {
        Grid grid = new Grid(center);
        TickHandler.instance().addNetwork(grid);
        center.setGrid(grid);
        AELog.grid("Created grid %s with center %s", grid, center);
        return grid;
    }

    private Grid(GridNode center) {
        this.pivot = Objects.requireNonNull(center);
        this.services = GridServicesInternal.createServices(this);
    }

    int getPriority() {
        return this.priority;
    }

    IGridStorage getMyStorage() {
        return this.myStorage;
    }

    Collection<IGridServiceProvider> getProviders() {
        return this.services.values();
    }

    @Override
    public int size() {
        return this.machines.size();
    }

    void remove(GridNode gridNode) {
        for (IGridServiceProvider c : this.services.values()) {
            c.removeNode(gridNode);
        }
        Class<?> machineClass = gridNode.getOwner().getClass();
        this.machines.remove(machineClass, (Object)gridNode);
        gridNode.setGridStorage(null);
        if (this.pivot == gridNode) {
            Iterator nodesIt = this.machines.values().iterator();
            if (nodesIt.hasNext()) {
                this.pivot = (GridNode)nodesIt.next();
            } else {
                this.pivot = null;
                TickHandler.instance().removeNetwork(this);
                this.myStorage.remove(gridNode.getLevel());
                AELog.grid("Removed grid %s", this);
            }
        }
    }

    void add(GridNode gridNode) {
        if (gridNode.getGridStorage() != null) {
            GridStorage gs = gridNode.getGridStorage();
            IGrid grid = gs.getGrid();
            if (grid == null) {
                this.myStorage = gs;
                this.myStorage.setGrid(this);
                for (IGridServiceProvider gc : this.services.values()) {
                    gc.onJoin(this.myStorage);
                }
            } else if (grid != this) {
                if (this.myStorage == null) {
                    this.myStorage = IGridStorageSaveData.get(this.getPivot().getLevel()).getNewGridStorage();
                    this.myStorage.setGrid(this);
                }
                GridStorage tmp = new GridStorage();
                if (!gs.hasDivided(this.myStorage)) {
                    gs.addDivided(this.myStorage);
                    for (IGridServiceProvider gc : ((Grid)grid).services.values()) {
                        gc.onSplit(tmp);
                    }
                    for (IGridServiceProvider gc : this.services.values()) {
                        gc.onJoin(tmp);
                    }
                }
            }
        } else if (this.myStorage == null) {
            this.myStorage = IGridStorageSaveData.get(this.getPivot().getLevel()).getNewGridStorage();
            this.myStorage.setGrid(this);
        }
        gridNode.setGridStorage(this.myStorage);
        this.machines.put(gridNode.getOwner().getClass(), (Object)gridNode);
        for (IGridServiceProvider service : this.services.values()) {
            service.addNode(gridNode);
        }
    }

    @Override
    public <C extends IGridService> C getService(Class<C> iface) {
        IGridServiceProvider service = this.services.get(iface);
        if (service == null) {
            throw new IllegalArgumentException("Service " + iface + " is not registered");
        }
        return (C)((IGridService)((Object)service));
    }

    @Override
    public <T extends GridEvent> T postEvent(T ev) {
        GridEventBus.postEvent(this, ev);
        return ev;
    }

    @Override
    public Iterable<Class<?>> getMachineClasses() {
        return this.machines.keySet();
    }

    @Override
    public Iterable<IGridNode> getMachineNodes(Class<?> machineClass) {
        return this.machines.get(machineClass);
    }

    @Override
    public <T> Set<T> getMachines(Class<T> machineClass) {
        Set nodes = this.machines.get(machineClass);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (IGridNode node : nodes) {
            Object logicalHost = node.getOwner();
            if (!machineClass.isInstance(logicalHost)) continue;
            resultBuilder.add(machineClass.cast(logicalHost));
        }
        return resultBuilder.build();
    }

    @Override
    public <T> Set<T> getActiveMachines(Class<T> machineClass) {
        Set nodes = this.machines.get(machineClass);
        ImmutableSet.Builder resultBuilder = ImmutableSet.builder();
        for (IGridNode node : nodes) {
            Object logicalHost = node.getOwner();
            if (!machineClass.isInstance(logicalHost) || !node.isActive()) continue;
            resultBuilder.add(machineClass.cast(logicalHost));
        }
        return resultBuilder.build();
    }

    public Collection<IGridNode> getNodes() {
        return this.machines.values();
    }

    @Override
    public boolean isEmpty() {
        return this.pivot == null;
    }

    @Override
    public IGridNode getPivot() {
        return this.pivot;
    }

    void setPivot(GridNode pivot) {
        this.pivot = pivot;
    }

    public void onServerStartTick() {
        for (IGridServiceProvider gc : this.services.values()) {
            if (this.pivot == null) continue;
            gc.onServerStartTick();
        }
    }

    public void onLevelStartTick(Level level) {
        for (IGridServiceProvider gc : this.services.values()) {
            if (this.pivot == null) continue;
            gc.onLevelStartTick(level);
        }
    }

    public void onLevelEndTick(Level level) {
        for (IGridServiceProvider gc : this.services.values()) {
            if (this.pivot == null) continue;
            gc.onLevelEndTick(level);
        }
    }

    public void onServerEndTick() {
        for (IGridServiceProvider gc : this.services.values()) {
            if (this.pivot == null) continue;
            gc.onServerEndTick();
        }
    }

    void saveState() {
        for (IGridServiceProvider c : this.services.values()) {
            c.populateGridStorage(this.myStorage);
        }
    }

    public void setImportantFlag(int i, boolean publicHasPower) {
        int flag = 1 << i;
        this.priority = this.priority & ~flag | (publicHasPower ? flag : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyAllNodes(IGridNodeListener.State state) {
        if (!ITERATION_BUFFER.isEmpty()) {
            throw new IllegalStateException("Recursively trying to notify all nodes is not allowed");
        }
        try {
            ITERATION_BUFFER.addAll((Collection<IGridNode>)this.getNodes());
            for (IGridNode node : ITERATION_BUFFER) {
                ((GridNode)node).notifyStatusChange(state);
            }
        }
        finally {
            ITERATION_BUFFER.clear();
        }
    }

    public void fillCrashReportCategory(CrashReportCategory category) {
        category.m_128159_("Nodes", (Object)this.machines.size());
        category.m_128159_("Serial number", (Object)this.serialNumber);
        if (AELog.isGridLogEnabled()) {
            category.m_128159_("All GridNodes", (Object)this.machines.values().stream().map(Object::toString).collect(Collectors.joining(";")));
        }
        if (this.pivot != null) {
            this.pivot.fillCrashReportCategory(category);
        }
    }

    public String toString() {
        return "Grid #" + this.serialNumber;
    }
}

