/*
 * Decompiled with CFR 0.152.
 */
package appeng.menu.slot;

import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.features.GridLinkables;
import appeng.api.features.IGridLinkableHandler;
import appeng.api.ids.AETags;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.implementations.items.ISpatialStorageCell;
import appeng.api.implementations.items.IStorageComponent;
import appeng.api.inventories.InternalInventory;
import appeng.api.storage.StorageCells;
import appeng.api.storage.cells.ICellWorkbenchItem;
import appeng.api.upgrades.Upgrades;
import appeng.blockentity.misc.InscriberRecipes;
import appeng.blockentity.misc.VibrationChamberBlockEntity;
import appeng.client.gui.Icon;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.EncodedPatternItem;
import appeng.menu.slot.AppEngSlot;
import appeng.util.Platform;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class RestrictedInputSlot
extends AppEngSlot {
    private final PlacableItemType which;
    private boolean allowEdit = true;
    private int stackLimit = -1;

    public RestrictedInputSlot(PlacableItemType valid, InternalInventory inv, int invSlot) {
        super(inv, invSlot);
        this.which = valid;
        this.setIcon(valid.icon);
    }

    @Override
    public int m_6641_() {
        if (this.stackLimit != -1) {
            return this.stackLimit;
        }
        return super.m_6641_();
    }

    public Slot setStackLimit(int i) {
        this.stackLimit = i;
        return this;
    }

    private Level getLevel() {
        return this.getMenu().getPlayerInventory().f_35978_.m_20193_();
    }

    @Override
    public boolean m_5857_(ItemStack stack) {
        if (!this.getMenu().isValidForSlot(this, stack)) {
            return false;
        }
        if (stack.m_41619_()) {
            return false;
        }
        if (stack.m_41720_() == Items.f_41852_) {
            return false;
        }
        if (!super.m_5857_(stack)) {
            return false;
        }
        if (!this.isAllowEdit()) {
            return false;
        }
        switch (this.which) {
            case ENCODED_AE_CRAFTING_PATTERN: {
                return AEItems.CRAFTING_PATTERN.isSameAs(stack);
            }
            case ENCODED_PATTERN: {
                return PatternDetailsHelper.isEncodedPattern(stack);
            }
            case ENCODED_AE_PATTERN: {
                return AEItems.CRAFTING_PATTERN.isSameAs(stack) || AEItems.PROCESSING_PATTERN.isSameAs(stack);
            }
            case BLANK_PATTERN: {
                return AEItems.BLANK_PATTERN.isSameAs(stack);
            }
            case INSCRIBER_PLATE: {
                if (AEItems.NAME_PRESS.isSameAs(stack)) {
                    return true;
                }
                return InscriberRecipes.isValidOptionalIngredient(this.getLevel(), stack);
            }
            case INSCRIBER_INPUT: {
                return true;
            }
            case METAL_INGOTS: {
                return RestrictedInputSlot.isMetalIngot(stack);
            }
            case VIEW_CELL: {
                return AEItems.VIEW_CELL.isSameAs(stack);
            }
            case FUEL: {
                return VibrationChamberBlockEntity.hasBurnTime(stack);
            }
            case POWERED_TOOL: {
                return Platform.isChargeable(stack);
            }
            case QE_SINGULARITY: {
                return AEItems.QUANTUM_ENTANGLED_SINGULARITY.isSameAs(stack);
            }
            case RANGE_BOOSTER: {
                return AEItems.WIRELESS_BOOSTER.isSameAs(stack);
            }
            case SPATIAL_STORAGE_CELLS: {
                return stack.m_41720_() instanceof ISpatialStorageCell && ((ISpatialStorageCell)stack.m_41720_()).isSpatialStorage(stack);
            }
            case STORAGE_CELLS: {
                return StorageCells.isCellHandled(stack);
            }
            case WORKBENCH_CELL: {
                return stack.m_41720_() instanceof ICellWorkbenchItem && ((ICellWorkbenchItem)stack.m_41720_()).isEditable(stack);
            }
            case STORAGE_COMPONENT: {
                return stack.m_41720_() instanceof IStorageComponent && ((IStorageComponent)stack.m_41720_()).isStorageComponent(stack);
            }
            case TRASH: {
                if (StorageCells.isCellHandled(stack)) {
                    return false;
                }
                return !(stack.m_41720_() instanceof IStorageComponent) || !((IStorageComponent)stack.m_41720_()).isStorageComponent(stack);
            }
            case GRID_LINKABLE_ITEM: {
                IGridLinkableHandler handler = GridLinkables.get((ItemLike)stack.m_41720_());
                return handler != null && handler.canLink(stack);
            }
            case BIOMETRIC_CARD: {
                return stack.m_41720_() instanceof IBiometricCard;
            }
            case UPGRADES: {
                return Upgrades.isUpgradeCardItem(stack);
            }
        }
        return false;
    }

    @Override
    public boolean m_8010_(Player player) {
        return this.isAllowEdit();
    }

    @Override
    public ItemStack getDisplayStack() {
        EncodedPatternItem iep;
        ItemStack out;
        Item item;
        ItemStack is;
        if (this.isRemote() && this.which == PlacableItemType.ENCODED_PATTERN && !(is = super.getDisplayStack()).m_41619_() && (item = is.m_41720_()) instanceof EncodedPatternItem && !(out = (iep = (EncodedPatternItem)item).getOutput(is)).m_41619_()) {
            return out;
        }
        return super.getDisplayStack();
    }

    public static boolean isMetalIngot(ItemStack i) {
        return i.m_41720_().m_204114_().m_203656_(AETags.METAL_INGOTS);
    }

    private boolean isAllowEdit() {
        return this.allowEdit;
    }

    public void setAllowEdit(boolean allowEdit) {
        this.allowEdit = allowEdit;
    }

    public static enum PlacableItemType {
        STORAGE_CELLS(Icon.BACKGROUND_STORAGE_CELL),
        ORE(Icon.BACKGROUND_ORE),
        STORAGE_COMPONENT(Icon.BACKGROUND_STORAGE_COMPONENT),
        GRID_LINKABLE_ITEM(Icon.BACKGROUND_WIRELESS_TERM),
        TRASH(Icon.BACKGROUND_TRASH),
        ENCODED_AE_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_AE_CRAFTING_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        ENCODED_PATTERN(Icon.BACKGROUND_ENCODED_PATTERN),
        PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        BLANK_PATTERN(Icon.BACKGROUND_BLANK_PATTERN),
        POWERED_TOOL(Icon.BACKGROUND_CHARGABLE),
        RANGE_BOOSTER(Icon.BACKGROUND_WIRELESS_BOOSTER),
        QE_SINGULARITY(Icon.BACKGROUND_SINGULARITY),
        SPATIAL_STORAGE_CELLS(Icon.BACKGROUND_SPATIAL_CELL),
        FUEL(Icon.BACKGROUND_FUEL),
        UPGRADES(Icon.BACKGROUND_UPGRADE),
        WORKBENCH_CELL(Icon.BACKGROUND_STORAGE_CELL),
        BIOMETRIC_CARD(Icon.BACKGROUND_BIOMETRIC_CARD),
        VIEW_CELL(Icon.BACKGROUND_VIEW_CELL),
        INSCRIBER_PLATE(Icon.BACKGROUND_PLATE),
        INSCRIBER_INPUT(Icon.BACKGROUND_INGOT),
        METAL_INGOTS(Icon.BACKGROUND_INGOT);

        public final Icon icon;

        private PlacableItemType(Icon o) {
            this.icon = o;
        }
    }
}

