/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline;

import appeng.thirdparty.codechicken.lib.model.CachedFormat;
import appeng.thirdparty.codechicken.lib.model.ISmartVertexConsumer;
import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineConsumer;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;

public class BakedPipeline
implements ISmartVertexConsumer {
    private PipelineElement[] elements;
    private Map<String, PipelineElement> nameLookup;
    private IPipelineConsumer first;
    private Quad unpacker = new Quad();

    private BakedPipeline(PipelineElement[] elements) {
        this.elements = elements;
        this.nameLookup = Arrays.stream(elements).collect(Collectors.toMap(e -> e.name, e -> e));
    }

    public static Builder builder() {
        return new Builder();
    }

    public void reset(VertexFormat format) {
        this.reset(CachedFormat.lookup(format));
    }

    public void reset(CachedFormat format) {
        this.unpacker.reset(format);
        for (PipelineElement element : this.elements) {
            element.reset(format);
        }
        this.first = null;
    }

    public <T extends IPipelineConsumer> T getElement(String name, Class<T> clazz) {
        PipelineElement element = this.nameLookup.get(name);
        if (element != null) {
            if (!clazz.isAssignableFrom(element.consumer.getClass())) {
                throw new IllegalArgumentException("Element with name " + name + " is not assignable from reference class.");
            }
            return (T)((IPipelineConsumer)clazz.cast(element.consumer));
        }
        throw new IllegalArgumentException("Element with name " + name + " does not exist.");
    }

    public void enableElement(String name) {
        this.setElementState(name, true);
    }

    public void disableElement(String name) {
        this.setElementState(name, false);
    }

    public void setElementState(String name, boolean enabled) {
        PipelineElement element = this.nameLookup.get(name);
        if (element != null) {
            element.isEnabled = enabled;
            return;
        }
        throw new IllegalArgumentException("Element with name " + name + " does not exist.");
    }

    public void prepare(IVertexConsumer collector) {
        IPipelineConsumer next = null;
        for (PipelineElement element : this.elements) {
            if (!element.isEnabled) continue;
            if (this.first == null) {
                this.first = element.consumer;
            } else {
                next.setParent((IVertexConsumer)element.consumer);
            }
            next = element.consumer;
        }
        next.setParent(collector);
    }

    public VertexFormat getVertexFormat() {
        this.check();
        return this.first.getVertexFormat();
    }

    public void setQuadTint(int tint) {
        this.check();
        this.unpacker.setQuadTint(tint);
    }

    public void setQuadOrientation(Direction orientation) {
        this.check();
        this.unpacker.setQuadOrientation(orientation);
    }

    public void setApplyDiffuseLighting(boolean diffuse) {
        this.check();
        this.unpacker.setApplyDiffuseLighting(diffuse);
    }

    public void setTexture(TextureAtlasSprite texture) {
        this.check();
        this.unpacker.setTexture(texture);
    }

    public void put(int element, float ... data) {
        this.check();
        this.unpacker.put(element, data);
        if (this.unpacker.full) {
            this.onFull();
        }
    }

    @Override
    public void put(Quad quad) {
        this.check();
        this.unpacker.put(quad);
    }

    private void check() {
        if (this.first == null) {
            throw new IllegalStateException("Pipeline used before prepare was called.");
        }
    }

    private void onFull() {
        this.first.setInputQuad(this.unpacker);
        this.first.put(this.unpacker);
    }

    public static class PipelineElement<T extends IPipelineConsumer> {
        public String name;
        public boolean defaultState;
        public T consumer;
        public boolean isEnabled;

        public void reset(CachedFormat format) {
            this.isEnabled = this.defaultState;
            this.consumer.setParent(null);
            this.consumer.reset(format);
        }
    }

    public static class Builder {
        private LinkedList<PipelineElement> elements = new LinkedList();

        public Builder addFirst(String name, IPipelineElementFactory<?> factory) {
            return this.addFirst(name, factory, true);
        }

        public Builder addFirst(String name, IPipelineElementFactory<?> factory, boolean defaultState) {
            return this.addFirst(name, factory, defaultState, e -> {});
        }

        public <T extends IPipelineConsumer> Builder addFirst(String name, IPipelineElementFactory<T> factory, boolean defaultState, Consumer<T> defaultsSetter) {
            PipelineElement<T> element = this.makeElement(name, factory, defaultState);
            defaultsSetter.accept(element.consumer);
            this.elements.addFirst(element);
            return this;
        }

        public Builder addElement(String name, IPipelineElementFactory<?> factory) {
            return this.addElement(name, factory, true);
        }

        public Builder addElement(String name, IPipelineElementFactory<?> factory, boolean defaultState) {
            return this.addElement(name, factory, defaultState, e -> {});
        }

        public <T extends IPipelineConsumer> Builder addElement(String name, IPipelineElementFactory<T> factory, boolean defaultState, Consumer<T> defaultsSetter) {
            PipelineElement<T> element = this.makeElement(name, factory, defaultState);
            defaultsSetter.accept(element.consumer);
            this.elements.add(element);
            return this;
        }

        private <T extends IPipelineConsumer> PipelineElement<T> makeElement(String name, IPipelineElementFactory<T> factory, boolean defaultState) {
            if (this.elements.stream().anyMatch(p -> p.name.equals(name))) {
                throw new IllegalArgumentException("Unable to add element with duplicate name: " + name);
            }
            PipelineElement element = new PipelineElement();
            element.name = name;
            element.consumer = factory.create();
            element.defaultState = defaultState;
            return element;
        }

        public BakedPipeline build() {
            return new BakedPipeline(this.elements.toArray(new PipelineElement[0]));
        }
    }
}

