/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.api.chiseling.mode;

import java.util.Optional;
import mod.chiselsandbits.api.IChiselsAndBitsAPI;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.IToolMode;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.registries.IRegistryManager;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistry;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface IChiselMode
extends IChiselsAndBitsRegistryEntry,
IToolMode<IToolModeGroup> {
    public static IChiselMode getDefaultMode() {
        return IChiselsAndBitsAPI.getInstance().getDefaultChiselMode();
    }

    public static IChiselsAndBitsRegistry<IChiselMode> getRegistry() {
        return IRegistryManager.getInstance().getChiselModeRegistry();
    }

    public ClickProcessingState onLeftClickBy(Player var1, IChiselingContext var2);

    public void onStoppedLeftClicking(Player var1, IChiselingContext var2);

    public ClickProcessingState onRightClickBy(Player var1, IChiselingContext var2);

    public void onStoppedRightClicking(Player var1, IChiselingContext var2);

    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext var1);

    default public boolean isStillValid(Player playerEntity, IChiselingContext context, ChiselingOperation modeOfOperation) {
        IChiselingContext snapshot = IChiselingManager.getInstance().create(playerEntity, this, modeOfOperation, true, ItemStack.f_41583_);
        if (modeOfOperation == ChiselingOperation.CHISELING) {
            this.onLeftClickBy(playerEntity, snapshot);
        } else {
            this.onRightClickBy(playerEntity, snapshot);
        }
        if (snapshot.getMutator().isEmpty()) {
            return context.getMutator().isEmpty();
        }
        if (context.getMutator().isEmpty()) {
            return false;
        }
        return context.getMutator().get().getInWorldBoundingBox().equals((Object)snapshot.getMutator().get().getInWorldBoundingBox());
    }

    default public boolean requiresPlaceableEditStack() {
        return false;
    }

    public VoxelShape getShape(IChiselingContext var1);
}

