/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.eligibility;

import mod.chiselsandbits.api.IgnoreBlockLogic;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityAnalysisResult;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.chiseling.eligibility.BlockEligibilityAnalysisData;
import mod.chiselsandbits.chiseling.eligibility.EligibilityAnalysisResult;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import mod.chiselsandbits.registrars.ModBlocks;
import mod.chiselsandbits.registrars.ModTags;
import mod.chiselsandbits.utils.ClassUtils;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SlimeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class EligibilityManager
implements IEligibilityManager {
    private static final EligibilityManager INSTANCE = new EligibilityManager();
    private static final SimpleMaxSizedCache<BlockInformation, IEligibilityAnalysisResult> cache = new SimpleMaxSizedCache(() -> IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_183450_() == 0 ? 1000 : IPlatformRegistryManager.getInstance().getBlockStateIdMap().m_183450_());

    private EligibilityManager() {
    }

    public static EligibilityManager getInstance() {
        return INSTANCE;
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull BlockInformation blockInformation) {
        return cache.get(blockInformation, () -> {
            if (blockInformation.getBlockState().m_60734_() instanceof ChiseledBlock) {
                return new EligibilityAnalysisResult(false, true, TranslationUtils.build("chiseling.is-already-chiseled", new Object[0]));
            }
            Block blk = blockInformation.getBlockState().m_60734_();
            if (blockInformation.getBlockState().m_204336_(ModTags.Blocks.BLOCKED_CHISELABLE)) {
                return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportTagBlackListed, new Object[0]));
            }
            if (blockInformation.getBlockState().m_204336_(ModTags.Blocks.FORCED_CHISELABLE)) {
                return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportTagWhitelisted, new Object[0]));
            }
            try {
                ReflectionHelperBlock pb = ModBlocks.REFLECTION_HELPER_BLOCK.get();
                Class<?> blkClass = blk.getClass();
                pb.m_7381_(blockInformation.getBlockState(), null);
                Class<?> wc = ClassUtils.getDeclaringClass(blkClass, pb.getLastInvokedThreadLocalMethodName(), BlockState.class, LootContext.Builder.class);
                boolean quantityDroppedTest = wc == Block.class || wc == BlockBehaviour.class || wc == LiquidBlock.class;
                boolean isNotSlab = Item.m_41439_((Block)blk) != Items.f_41852_ || blockInformation.getBlockState().m_60734_() instanceof LiquidBlock;
                boolean itemExistsOrNotSpecialDrops = quantityDroppedTest || isNotSlab;
                pb.m_5940_(null, null, null, null);
                Class<?> collisionClass = ClassUtils.getDeclaringClass(blkClass, pb.getLastInvokedThreadLocalMethodName(), BlockState.class, BlockGetter.class, BlockPos.class, CollisionContext.class);
                boolean noCustomCollision = collisionClass == Block.class || collisionClass == BlockBehaviour.class || blk.getClass() == SlimeBlock.class || collisionClass == LiquidBlock.class;
                boolean isFullBlock = blockInformation.getBlockState().m_60815_() || blk instanceof AbstractGlassBlock || blk instanceof LiquidBlock;
                BlockEligibilityAnalysisData info = BlockEligibilityAnalysisData.createFromState(blockInformation);
                boolean tickingBehavior = blk.m_6724_(blockInformation.getBlockState()) && IServerConfiguration.getInstance().getBlackListRandomTickingBlocks().get() != false;
                boolean hasBehavior = blk instanceof EntityBlock || tickingBehavior;
                Material remappedMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockInformation.getBlockState().m_60767_());
                boolean supportedMaterial = ModBlocks.MATERIAL_TO_BLOCK_CONVERSIONS.containsKey(remappedMaterial);
                if (!supportedMaterial) {
                    return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
                }
                if (blkClass.isAnnotationPresent(IgnoreBlockLogic.class)) {
                    isFullBlock = true;
                    noCustomCollision = true;
                    hasBehavior = false;
                    itemExistsOrNotSpecialDrops = true;
                }
                if (info.isCompatible() && noCustomCollision && info.getHardness() >= -0.01f && isFullBlock && supportedMaterial && !hasBehavior && itemExistsOrNotSpecialDrops) {
                    return new EligibilityAnalysisResult(true, false, TranslationUtils.build(blkClass.isAnnotationPresent(IgnoreBlockLogic.class) ? LocalStrings.ChiselSupportLogicIgnored : LocalStrings.ChiselSupportGenericSupported, new Object[0]));
                }
                if (!blockInformation.getBlockState().m_60819_().m_76178_() && blockInformation.getBlockState().m_60734_() instanceof LiquidBlock) {
                    return new EligibilityAnalysisResult(true, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericFluidSupport, new Object[0]));
                }
                EligibilityAnalysisResult result = null;
                if (!info.isCompatible()) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCompatDeactivated, new Object[0]));
                } else if (!noCustomCollision) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportCustomCollision, new Object[0]));
                } else if (info.getHardness() < -0.01f) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNoHardness, new Object[0]));
                } else if (!isNotSlab) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportIsSlab, new Object[0]));
                } else if (!isFullBlock) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportNotFullBlock, new Object[0]));
                } else if (hasBehavior) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasBehaviour, new Object[0]));
                } else if (!quantityDroppedTest) {
                    result = new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportHasCustomDrops, new Object[0]));
                }
                return result;
            }
            catch (Throwable t) {
                return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportFailureToAnalyze, new Object[0]));
            }
        });
    }

    @Override
    public IEligibilityAnalysisResult analyse(@NotNull ItemLike provider) {
        Item item = provider.m_5456_();
        if (item instanceof BlockItem) {
            return this.analyse(((BlockItem)item).m_40614_());
        }
        return new EligibilityAnalysisResult(false, false, TranslationUtils.build(LocalStrings.ChiselSupportGenericNotSupported, new Object[0]));
    }
}

