/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.besr;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Objects;
import java.util.function.Supplier;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.config.IClientConfiguration;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.client.model.baked.chiseled.ChiselRenderType;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModel;
import mod.chiselsandbits.client.model.baked.chiseled.ChiseledBlockBakedModelManager;
import mod.chiselsandbits.client.util.FluidCuboidUtils;
import mod.chiselsandbits.platforms.core.client.rendering.IRenderingManager;
import mod.chiselsandbits.platforms.core.client.rendering.type.IRenderTypeManager;
import mod.chiselsandbits.platforms.core.fluid.FluidInformation;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import org.jetbrains.annotations.NotNull;

public class BitStorageBESR
implements BlockEntityRenderer<BitStorageBlockEntity> {
    private static final SimpleMaxSizedCache<CacheKey, IStateEntryStorage> STORAGE_CONTENTS_BLOB_CACHE = new SimpleMaxSizedCache(((Supplier<Long>)IClientConfiguration.getInstance().getBitStorageContentCacheSize())::get);

    public static void clearCache() {
        STORAGE_CONTENTS_BLOB_CACHE.clear();
    }

    public void render(BitStorageBlockEntity te, float partialTicks, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        if (te.containsFluid()) {
            FluidInformation fluidStack = te.getFluid().get();
            if (fluidStack != null) {
                RenderType.m_110506_().forEach(renderType -> {
                    if (!IRenderTypeManager.getInstance().canRenderInType(fluidStack.fluid().m_76145_(), (RenderType)renderType)) {
                        return;
                    }
                    if (renderType == RenderType.m_110466_() && Minecraft.m_91085_()) {
                        renderType = Sheets.m_110792_();
                    }
                    VertexConsumer builder = buffer.m_6299_(renderType);
                    float fullness = (float)fluidStack.amount() / (float)StateEntrySize.current().getBitsPerBlock();
                    FluidCuboidUtils.renderScaledFluidCuboid(fluidStack, poseStack, builder, combinedLightIn, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 15.0f, 15.0f * fullness, 15.0f);
                });
            }
            return;
        }
        int bits = te.getBits();
        BlockInformation blockInformation = te.getContainedBlockInformation();
        if (bits <= 0 || blockInformation == null) {
            return;
        }
        CacheKey cacheKey = new CacheKey(blockInformation, bits);
        IStateEntryStorage innerModelBlob = STORAGE_CONTENTS_BLOB_CACHE.get(cacheKey);
        if (innerModelBlob == null) {
            innerModelBlob = new SimpleStateEntryStorage();
            innerModelBlob.fillFromBottom(blockInformation, bits);
            STORAGE_CONTENTS_BLOB_CACHE.put(cacheKey, innerModelBlob);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(0.125, 0.125, 0.125);
        poseStack.m_85841_(0.75f, 0.75f, 0.75f);
        IStateEntryStorage finalInnerModelBlob = innerModelBlob;
        RenderType.m_110506_().forEach(renderType -> {
            ChiseledBlockBakedModel innerModel = ChiseledBlockBakedModelManager.getInstance().get(MultiStateSnapshotUtils.createFromStorage(finalInnerModelBlob), blockInformation, ChiselRenderType.fromLayer(renderType, te.containsFluid()), null, null, te.m_58899_());
            if (!innerModel.isEmpty()) {
                float b;
                float g;
                float r;
                if (te.containsFluid()) {
                    r = (float)te.getFluid().map(IFluidManager.getInstance()::getFluidColor).map(color -> color >> 16 & 0xFF).orElse(255).intValue() / 255.0f;
                    g = (float)te.getFluid().map(IFluidManager.getInstance()::getFluidColor).map(color -> color >> 8 & 0xFF).orElse(255).intValue() / 255.0f;
                    b = (float)te.getFluid().map(IFluidManager.getInstance()::getFluidColor).map(color -> color & 0xFF).orElse(255).intValue() / 255.0f;
                } else {
                    int color2 = Minecraft.m_91087_().m_91298_().m_92582_(blockInformation.getBlockState(), te.m_58904_(), te.m_58899_());
                    r = (float)(color2 >> 16 & 0xFF) / 255.0f;
                    g = (float)(color2 >> 8 & 0xFF) / 255.0f;
                    b = (float)(color2 & 0xFF) / 255.0f;
                }
                IRenderingManager.getInstance().renderModel(poseStack.m_85850_(), buffer.m_6299_(renderType), blockInformation.getBlockState(), innerModel, r, g, b, combinedLightIn, combinedOverlayIn);
            }
        });
        poseStack.m_85849_();
    }

    private static final class CacheKey {
        private final BlockInformation blockInformation;
        private final int bitCount;

        private CacheKey(BlockInformation blockInformation, int bitCount) {
            this.blockInformation = blockInformation;
            this.bitCount = bitCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.blockInformation == cacheKey.blockInformation && this.bitCount == cacheKey.bitCount;
        }

        public int hashCode() {
            return Objects.hash(this.blockInformation, this.bitCount);
        }
    }
}

