/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.client.model.baked.face;

import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import net.minecraft.core.Direction;

public class FormatInfo {
    private static final int[][] VERTEX_ORDER_MAP = new int[6][4];
    final int totalSize;
    final int faceSize;
    final int[] offsets;
    final int[] indexLengths;
    final int[] finalLengths;

    public FormatInfo(VertexFormat format) {
        int total = 0;
        this.indexLengths = new int[format.m_86023_().size()];
        this.finalLengths = new int[format.m_86023_().size()];
        this.offsets = new int[format.m_86023_().size()];
        for (int x = 0; x < this.indexLengths.length; ++x) {
            this.finalLengths[x] = ((VertexFormatElement)format.m_86023_().get(x)).m_166969_();
            this.indexLengths[x] = this.finalLengths[x];
            switch (((VertexFormatElement)format.m_86023_().get(x)).m_86048_()) {
                case GENERIC: 
                case PADDING: {
                    this.indexLengths[x] = 0;
                    break;
                }
                case COLOR: {
                    this.indexLengths[x] = 4;
                    break;
                }
                case NORMAL: 
                case POSITION: {
                    this.indexLengths[x] = 3;
                    break;
                }
                case UV: {
                    this.indexLengths[x] = 2;
                }
            }
            this.offsets[x] = total;
            total += this.indexLengths[x];
        }
        this.totalSize = total;
        this.faceSize = total * 4;
    }

    public int[] pack(float[][][] unpackedData, Direction orientation) {
        int[] out = new int[this.faceSize];
        int[] orderedFaceIndexes = VERTEX_ORDER_MAP[orientation.m_122411_()];
        int offset = 0;
        for (int faceIndex = 0; faceIndex < 4; ++faceIndex) {
            int orderedFaceIndex = orderedFaceIndexes[faceIndex];
            float[][] unpackedFaceData = unpackedData[orderedFaceIndex];
            for (int x = 0; x < this.indexLengths.length; ++x) {
                float[] run = unpackedFaceData[x];
                for (int z = 0; z < this.indexLengths[x]; ++z) {
                    out[offset++] = run.length > z ? Float.floatToRawIntBits(run[z]) : 0;
                }
            }
        }
        return out;
    }

    public float[] unpack(int[] raw, int vertex, int index) {
        int size = this.indexLengths[index];
        float[] out = new float[size];
        int start = vertex * this.totalSize + this.offsets[index];
        for (int x = 0; x < size; ++x) {
            out[x] = Float.intBitsToFloat(raw[start + x]);
        }
        return out;
    }

    static {
        FormatInfo.VERTEX_ORDER_MAP[Direction.DOWN.m_122411_()] = new int[]{0, 1, 2, 3};
        FormatInfo.VERTEX_ORDER_MAP[Direction.UP.m_122411_()] = new int[]{2, 3, 0, 1};
        FormatInfo.VERTEX_ORDER_MAP[Direction.NORTH.m_122411_()] = new int[]{3, 0, 1, 2};
        FormatInfo.VERTEX_ORDER_MAP[Direction.SOUTH.m_122411_()] = new int[]{0, 1, 2, 3};
        FormatInfo.VERTEX_ORDER_MAP[Direction.WEST.m_122411_()] = new int[]{3, 0, 1, 2};
        FormatInfo.VERTEX_ORDER_MAP[Direction.EAST.m_122411_()] = new int[]{1, 2, 3, 0};
    }
}

