/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.forge.data.lang;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.platforms.core.util.constants.Constants;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="chiselsandbits", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LangEntryLangGenerator
implements DataProvider {
    private final DataGenerator generator;

    @SubscribeEvent
    public static void dataGeneratorSetup(GatherDataEvent event) {
        event.getGenerator().m_123914_((DataProvider)new LangEntryLangGenerator(event.getGenerator()));
    }

    private LangEntryLangGenerator(DataGenerator generator) {
        this.generator = generator;
    }

    public void m_6865_(@NotNull HashCache cache) throws IOException {
        List langKeys = Arrays.stream(LocalStrings.values()).map(LocalStrings::toString).collect(Collectors.toList());
        Collections.sort(langKeys);
        JsonObject returnValue = new JsonObject();
        for (String langKey : langKeys) {
            returnValue.addProperty(langKey, "");
        }
        Path configLangFolder = this.generator.m_123916_().resolve("assets/chiselsandbits/lang/config/");
        Path langPath = configLangFolder.resolve("localstrings.json");
        DataProvider.m_123920_((Gson)Constants.DataGenerator.GSON, (HashCache)cache, (JsonElement)returnValue, (Path)langPath);
    }

    @NotNull
    public String m_6055_() {
        return "Chiseled config lang generator";
    }
}

