/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.bit;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import mod.chiselsandbits.api.block.state.id.IBlockStateIdManager;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.IChiselingManager;
import mod.chiselsandbits.api.chiseling.ILocalChiselingContextCache;
import mod.chiselsandbits.api.chiseling.eligibility.IEligibilityManager;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.client.chiseling.preview.render.IChiselContextPreviewRendererRegistry;
import mod.chiselsandbits.api.item.bit.IBitItem;
import mod.chiselsandbits.api.item.bit.IBitItemManager;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.documentation.IDocumentableItem;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.notifications.INotificationManager;
import mod.chiselsandbits.api.variant.state.IStateVariantManager;
import mod.chiselsandbits.chiseling.ChiselingManager;
import mod.chiselsandbits.client.render.ModRenderTypes;
import mod.chiselsandbits.platforms.core.fluid.IFluidManager;
import mod.chiselsandbits.platforms.core.registries.IChiselsAndBitsRegistryEntry;
import mod.chiselsandbits.platforms.core.registries.IPlatformRegistryManager;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.utils.TranslationUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitItem
extends Item
implements IChiselingItem,
IBitItem,
IDocumentableItem {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String LEGACY_BLOCK_STATE_ID_KEY = "id";
    private final List<ItemStack> availableBitStacks = Lists.newLinkedList();
    private final ThreadLocal<Boolean> threadLocalBitMergeOperationInProgress = ThreadLocal.withInitial(() -> false);

    public BitItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ClickProcessingState handleLeftClickProcessing(Player playerEntity, InteractionHand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.CHISELING, IChiselMode::onLeftClickBy);
    }

    @Override
    public void onLeftClickProcessingEnd(Player player, ItemStack stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.CHISELING);
        if (context.isEmpty()) {
            context = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedLeftClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.m_36335_().m_41524_((Item)this, 3);
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
        });
    }

    @Override
    public boolean canUse(Player playerEntity) {
        return ChiselingManager.getInstance().canChisel(playerEntity);
    }

    @Override
    @NotNull
    public IChiselMode getMode(ItemStack stack) {
        CompoundTag stackNbt = stack.m_41784_();
        if (stackNbt.m_128441_("chiselMode")) {
            String chiselModeName = stackNbt.m_128461_("chiselMode");
            try {
                Optional<IChiselMode> registryMode = IChiselMode.getRegistry().get(new ResourceLocation(chiselModeName));
                if (registryMode.isEmpty()) {
                    return IChiselMode.getDefaultMode();
                }
                return registryMode.get();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LOGGER.error(String.format("An ItemStack got loaded with a name that is not a valid chisel mode: %s", chiselModeName));
                this.setMode(stack, IChiselMode.getDefaultMode());
            }
        }
        return IChiselMode.getDefaultMode();
    }

    @NotNull
    public Component m_7626_(@NotNull ItemStack stack) {
        BlockInformation containedStack = this.getBlockInformation(stack);
        Block block = containedStack.getBlockState().m_60734_();
        Component stateName = block.m_5456_().m_7626_(new ItemStack((ItemLike)block));
        if (block instanceof LiquidBlock) {
            LiquidBlock flowingFluidBlock = (LiquidBlock)block;
            stateName = IFluidManager.getInstance().getDisplayName(flowingFluidBlock.m_5888_(flowingFluidBlock.m_49966_()).m_76152_());
        }
        return new TranslatableComponent(this.m_5671_(stack), new Object[]{stateName});
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        IChiselMode mode = this.getMode(stack);
        if (mode.getGroup().isPresent()) {
            tooltip.add((Component)TranslationUtils.build("chiselmode.mode_grouped", ((IToolModeGroup)mode.getGroup().get()).getDisplayName(), mode.getDisplayName()));
        } else {
            tooltip.add((Component)TranslationUtils.build("chiselmode.mode", mode.getDisplayName()));
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public void setMode(ItemStack stack, IChiselMode mode) {
        if (mode == null) {
            return;
        }
        stack.m_41784_().m_128359_("chiselMode", Objects.requireNonNull(mode.getRegistryName()).toString());
    }

    @Override
    @NotNull
    public Collection<IChiselMode> getPossibleModes() {
        return IChiselMode.getRegistry().getValues().stream().sorted(Comparator.comparing(IChiselsAndBitsRegistryEntry::getRegistryName)).collect(Collectors.toList());
    }

    @Override
    public ClickProcessingState handleRightClickProcessing(Player playerEntity, InteractionHand hand, BlockPos position, Direction face, ClickProcessingState currentState) {
        return this.handleClickProcessing(playerEntity, hand, currentState, ChiselingOperation.PLACING, IChiselMode::onRightClickBy);
    }

    @Override
    public void onRightClickProcessingEnd(Player player, ItemStack stack) {
        IChiselMode chiselMode = this.getMode(stack);
        Optional<IChiselingContext> context = IChiselingManager.getInstance().get(player, chiselMode, ChiselingOperation.PLACING);
        if (context.isEmpty()) {
            context = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        }
        context.ifPresent(c -> {
            chiselMode.onStoppedRightClicking(player, (IChiselingContext)c);
            if (c.isComplete()) {
                player.m_36335_().m_41524_((Item)this, 3);
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.PLACING);
            }
        });
    }

    private ClickProcessingState handleClickProcessing(Player playerEntity, InteractionHand hand, ClickProcessingState currentState, ChiselingOperation modeOfOperation, ChiselModeInteractionCallback callback) {
        ItemStack itemStack = playerEntity.m_21120_(hand);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return currentState;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        IChiselingContext context = IChiselingManager.getInstance().getOrCreateContext(playerEntity, chiselMode, modeOfOperation, false, itemStack);
        ClickProcessingState resultState = callback.run(chiselMode, playerEntity, context);
        if (context.isComplete()) {
            playerEntity.m_36335_().m_41524_((Item)this, 3);
            ILocalChiselingContextCache.getInstance().clear(modeOfOperation);
        }
        if (context.getError().isPresent() && context.getWorld().m_5776_()) {
            INotificationManager.getInstance().notify(context.getMode().getIcon(), new Vec3(1.0, 0.0, 0.0), (Component)context.getError().get());
        }
        return resultState;
    }

    @Override
    @NotNull
    public BlockInformation getBlockInformation(ItemStack stack) {
        if (stack.m_41784_().m_128441_("blockState")) {
            BlockInformation blockInformation = new BlockInformation(NbtUtils.m_129241_((CompoundTag)stack.m_41698_("blockState")));
            stack.m_41784_().m_128473_("blockState");
            stack.m_41784_().m_128365_("block_information", (Tag)blockInformation.serializeNBT());
            return blockInformation;
        }
        if (stack.m_41784_().m_128441_(LEGACY_BLOCK_STATE_ID_KEY)) {
            BlockInformation blockInformation = new BlockInformation(IBlockStateIdManager.getInstance().getBlockStateFrom(stack.m_41784_().m_128451_(LEGACY_BLOCK_STATE_ID_KEY)));
            stack.m_41784_().m_128473_(LEGACY_BLOCK_STATE_ID_KEY);
            stack.m_41784_().m_128365_("block_information", (Tag)blockInformation.serializeNBT());
            return blockInformation;
        }
        if (stack.m_41784_().m_128441_("block_information")) {
            return new BlockInformation(stack.m_41784_().m_128469_("block_information"));
        }
        return BlockInformation.AIR;
    }

    @Override
    public void onMergeOperationWithBagBeginning() {
        this.threadLocalBitMergeOperationInProgress.set(true);
    }

    @Override
    public void onMergeOperationWithBagEnding() {
        this.threadLocalBitMergeOperationInProgress.set(false);
    }

    @Override
    public boolean shouldDrawDefaultHighlight(@NotNull Player playerEntity) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return true;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode, ChiselingOperation.CHISELING);
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext context = potentiallyExistingContext.get();
            if (context.getMutator().isPresent()) {
                return false;
            }
            IChiselingContext currentContextSnapshot = context.createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            return currentContextSnapshot.getMutator().isEmpty();
        }
        Optional<IChiselingContext> localCachedContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        if (localCachedContext.isPresent()) {
            IChiselingContext context = localCachedContext.get();
            if (context.getMode() == chiselMode && context.getMutator().isPresent()) {
                return false;
            }
            return context.getMutator().isEmpty();
        }
        IChiselingContext context = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, context);
        if (context.getMutator().isPresent()) {
            return false;
        }
        chiselMode.onRightClickBy(playerEntity, context);
        return context.getMutator().isEmpty();
    }

    @Override
    public void renderHighlight(Player playerEntity, LevelRenderer worldRenderer, PoseStack matrixStack, float partialTicks) {
        ItemStack itemStack = ItemStackUtils.getHighlightItemStackFromPlayer(playerEntity);
        if (itemStack.m_41619_() || itemStack.m_41720_() != this) {
            return;
        }
        IChiselingItem chiselingItem = (IChiselingItem)itemStack.m_41720_();
        IChiselMode chiselMode = (IChiselMode)chiselingItem.getMode(itemStack);
        Optional<IChiselingContext> potentiallyExistingContext = IChiselingManager.getInstance().get(playerEntity, chiselMode);
        Optional<IChiselingContext> potentialChiselingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.CHISELING);
        Optional<IChiselingContext> potentialPlacingContext = ILocalChiselingContextCache.getInstance().get(ChiselingOperation.PLACING);
        boolean renderedSomething = false;
        if (potentiallyExistingContext.isPresent()) {
            IChiselingContext currentContextSnapshot = potentiallyExistingContext.get().createSnapshot();
            if (currentContextSnapshot.getModeOfOperandus() == ChiselingOperation.CHISELING) {
                chiselMode.onLeftClickBy(playerEntity, currentContextSnapshot);
            } else {
                chiselMode.onRightClickBy(playerEntity, currentContextSnapshot);
            }
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, currentContextSnapshot);
            return;
        }
        if (potentialChiselingContext.isPresent()) {
            IChiselingContext chiselingContext = potentialChiselingContext.get();
            if (potentialChiselingContext.get().getMode() == chiselMode && chiselingContext.getMode().isStillValid(playerEntity, chiselingContext, ChiselingOperation.CHISELING)) {
                IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            } else {
                ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.CHISELING);
            }
            if (potentialPlacingContext.isPresent()) {
                IChiselingContext placingContext = potentialPlacingContext.get();
                if (placingContext.getMode() == chiselMode && potentialPlacingContext.get().getMode().isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
                    IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
                } else {
                    ILocalChiselingContextCache.getInstance().clear(ChiselingOperation.PLACING);
                }
            }
            return;
        }
        if (potentialPlacingContext.isPresent() && potentialPlacingContext.get().getMode() == chiselMode && chiselMode.isStillValid(playerEntity, potentialPlacingContext.get(), ChiselingOperation.PLACING)) {
            IChiselingContext context = potentialPlacingContext.get();
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, context);
            return;
        }
        IChiselingContext chiselingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.CHISELING, true, itemStack);
        IChiselingContext placingContext = IChiselingManager.getInstance().create(playerEntity, chiselMode, ChiselingOperation.PLACING, true, itemStack);
        chiselMode.onLeftClickBy(playerEntity, chiselingContext);
        chiselMode.onRightClickBy(playerEntity, placingContext);
        RenderSystem.m_69465_();
        if (chiselingContext.getMutator().isPresent() && chiselingContext.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, chiselingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.CHISELING, chiselingContext);
        }
        if (placingContext.getMutator().isPresent() && placingContext.getError().isEmpty()) {
            IChiselContextPreviewRendererRegistry.getInstance().getCurrent().renderExistingContextsBoundingBox(matrixStack, placingContext);
            ILocalChiselingContextCache.getInstance().set(ChiselingOperation.PLACING, placingContext);
        }
        Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(ModRenderTypes.MEASUREMENT_LINES.get());
        RenderSystem.m_69482_();
    }

    @Override
    public boolean isDamageableDuringChiseling() {
        return false;
    }

    public void m_6787_(@Nullable CreativeModeTab group, @NotNull NonNullList<ItemStack> items) {
        if (group == null || this.m_41471_() != group) {
            return;
        }
        this.ensureAvailableBitStacksAreLoaded();
        items.addAll(this.availableBitStacks);
    }

    @Override
    public Map<String, ItemStack> getDocumentableInstances(Item item) {
        this.ensureAvailableBitStacksAreLoaded();
        return this.availableBitStacks.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toMap(stack -> "bit_" + IPlatformRegistryManager.getInstance().getBlockRegistry().getKey(this.getBlockInformation((ItemStack)stack).getBlockState().m_60734_()).toString().replace(":", "_"), Function.identity()));
    }

    private void ensureAvailableBitStacksAreLoaded() {
        if (this.availableBitStacks.isEmpty()) {
            IPlatformRegistryManager.getInstance().getBlockRegistry().getValues().forEach(block -> {
                if (IEligibilityManager.getInstance().canBeChiseled((Block)block)) {
                    BlockState blockState = block.m_49966_();
                    Collection<BlockInformation> defaultStateVariants = IStateVariantManager.getInstance().getAllDefaultVariants(blockState);
                    if (defaultStateVariants.isEmpty()) {
                        ItemStack resultStack = IBitItemManager.getInstance().create(new BlockInformation(blockState));
                        if (!resultStack.m_41619_() && resultStack.m_41720_() instanceof IBitItem) {
                            this.availableBitStacks.add(resultStack);
                        }
                    } else {
                        defaultStateVariants.forEach(blockInformation -> {
                            ItemStack resultStack = IBitItemManager.getInstance().create((BlockInformation)blockInformation);
                            if (!resultStack.m_41619_() && resultStack.m_41720_() instanceof IBitItem) {
                                this.availableBitStacks.add(resultStack);
                            }
                        });
                    }
                }
            });
            this.availableBitStacks.sort(Comparator.comparing(stack -> {
                if (!(stack.m_41720_() instanceof IBitItem)) {
                    throw new IllegalStateException("Stack did not contain a bit item.");
                }
                return ((IBitItem)stack.m_41720_()).getBlockInformation((ItemStack)stack);
            }));
        }
    }

    @FunctionalInterface
    private static interface ChiselModeInteractionCallback {
        public ClickProcessingState run(IChiselMode var1, Player var2, IChiselingContext var3);
    }
}

