/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.item.multistate;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mod.chiselsandbits.api.block.storage.IStateEntryStorage;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.item.multistate.IMultiStateItem;
import mod.chiselsandbits.api.item.multistate.IMultiStateItemStack;
import mod.chiselsandbits.api.item.multistate.IStatistics;
import mod.chiselsandbits.api.item.pattern.IPatternItem;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.accessor.identifier.IAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.identifier.IArrayBackedAreaShapeIdentifier;
import mod.chiselsandbits.api.multistate.accessor.sortable.IPositionMutator;
import mod.chiselsandbits.api.multistate.mutator.IMutableStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.callback.StateClearer;
import mod.chiselsandbits.api.multistate.mutator.callback.StateSetter;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.util.BlockPosForEach;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.block.entities.storage.SimpleStateEntryStorage;
import mod.chiselsandbits.item.ChiseledBlockItem;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.platforms.core.registries.deferred.IRegistryObject;
import mod.chiselsandbits.registrars.ModItems;
import mod.chiselsandbits.storage.ILegacyStorageHandler;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import mod.chiselsandbits.storage.StorageEngineBuilder;
import mod.chiselsandbits.utils.ChunkSectionUtils;
import mod.chiselsandbits.utils.GZIPDataCompressionUtils;
import mod.chiselsandbits.utils.LZ4DataCompressionUtils;
import mod.chiselsandbits.utils.MultiStateSnapshotUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SingleBlockMultiStateItemStack
implements IMultiStateItemStack {
    private final ItemStack sourceStack;
    private final IStateEntryStorage compressedSection;
    private final Statistics statistics = new Statistics();
    private final IStorageEngine storageEngine = this.buildStorageEngine();

    public SingleBlockMultiStateItemStack(ItemStack sourceStack) {
        this.sourceStack = sourceStack;
        this.compressedSection = new SimpleStateEntryStorage();
        this.deserializeNBT(sourceStack.m_41698_("chiseledData"));
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    public SingleBlockMultiStateItemStack(Item item, IStateEntryStorage compressedSection) {
        if (!(item instanceof IMultiStateItem)) {
            throw new IllegalArgumentException("The given item is not a MultiState Item");
        }
        this.sourceStack = new ItemStack((ItemLike)item);
        this.compressedSection = compressedSection;
        this.statistics.initializeFrom(this.compressedSection);
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    public SingleBlockMultiStateItemStack(Item item, CompoundTag nbt) {
        if (!(item instanceof IMultiStateItem)) {
            throw new IllegalArgumentException("The given item is not a MultiState Item");
        }
        this.sourceStack = new ItemStack((ItemLike)item);
        this.compressedSection = new SimpleStateEntryStorage();
        this.statistics.initializeFrom(this.compressedSection);
        this.deserializeNBT(nbt);
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    private IStorageEngine buildStorageEngine() {
        return StorageEngineBuilder.create().withLegacy(new LegacyChunkSectionBasedStorageHandler()).withLegacy(new LegacyGZIPStorageBasedStorageHandler()).with(new LZ4StorageBasedStorageHandler()).build();
    }

    @Override
    public IAreaShapeIdentifier createNewShapeIdentifier() {
        return new ShapeIdentifier(this.compressedSection);
    }

    @Override
    public Stream<IStateEntryInfo> stream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        return currentState.isAir() ? Optional.empty() : Optional.of(new StateEntry(currentState, (Vec3i)inAreaPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        return this.getInAreaTarget(inBlockTarget);
    }

    @Override
    public boolean isInside(Vec3 inAreaTarget) {
        return !(inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0);
    }

    @Override
    public boolean isInside(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        return this.isInside(inBlockTarget);
    }

    @Override
    public IMultiStateSnapshot createSnapshot() {
        return MultiStateSnapshotUtils.createFromStorage(this.compressedSection);
    }

    @Override
    public Stream<IMutableStateEntryInfo> mutableStream() {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void setInAreaTarget(BlockInformation blockInformation, Vec3 inAreaTarget) throws SpaceOccupiedException {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        if (!currentState.isAir()) {
            throw new SpaceOccupiedException();
        }
        this.compressedSection.setBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), blockInformation);
        if (blockInformation.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockInformation.isAir() && currentState.isAir()) {
            this.statistics.onBlockStateAdded(blockInformation);
        } else if (!blockInformation.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateReplaced(currentState, blockInformation);
        }
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    @Override
    public void setInBlockTarget(BlockInformation blockInformation, BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) throws SpaceOccupiedException {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.setInAreaTarget(blockInformation, inBlockTarget);
    }

    @Override
    public void clearInAreaTarget(Vec3 inAreaTarget) {
        if (inAreaTarget.m_7096_() < 0.0 || inAreaTarget.m_7098_() < 0.0 || inAreaTarget.m_7094_() < 0.0 || inAreaTarget.m_7096_() >= 1.0 || inAreaTarget.m_7098_() >= 1.0 || inAreaTarget.m_7094_() >= 1.0) {
            throw new IllegalArgumentException("Target is not in the current area.");
        }
        BlockPos inAreaPos = new BlockPos(inAreaTarget.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide()));
        BlockInformation blockState = BlockInformation.AIR;
        BlockInformation currentState = this.compressedSection.getBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_());
        this.compressedSection.setBlockInformation(inAreaPos.m_123341_(), inAreaPos.m_123342_(), inAreaPos.m_123343_(), blockState);
        if (blockState.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateRemoved(currentState);
        } else if (!blockState.isAir() && currentState.isAir()) {
            this.statistics.onBlockStateAdded(blockState);
        } else if (!blockState.isAir() && !currentState.isAir()) {
            this.statistics.onBlockStateReplaced(currentState, blockState);
        }
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    @Override
    public void clearInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        if (!inAreaBlockPosOffset.equals((Object)BlockPos.f_121853_)) {
            throw new IllegalStateException(String.format("The given in area block pos offset is not inside the current block: %s", inAreaBlockPosOffset));
        }
        this.clearInAreaTarget(inBlockTarget);
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        this.compressedSection.serializeInto(packetBuffer);
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.compressedSection.deserializeFrom(packetBuffer);
    }

    @Override
    public CompoundTag serializeNBT() {
        return (CompoundTag)this.storageEngine.serializeNBT();
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.storageEngine.deserializeNBT(nbt);
    }

    @Override
    public IStatistics getStatistics() {
        return this.statistics;
    }

    @Override
    public ItemStack toBlockStack() {
        if (this.sourceStack.m_41720_() instanceof IPatternItem) {
            BlockInformation primaryState = this.statistics.getPrimaryState();
            Material blockMaterial = primaryState.getBlockState().m_60767_();
            Material conversionMaterial = MaterialManager.getInstance().remapMaterialIfNeeded(blockMaterial);
            IRegistryObject<ChiseledBlockItem> convertedItemProvider = ModItems.MATERIAL_TO_ITEM_CONVERSIONS.get(conversionMaterial);
            ChiseledBlockItem chiseledBlockItem = convertedItemProvider.get();
            ItemStack blockStack = new ItemStack((ItemLike)chiseledBlockItem);
            blockStack.m_41751_(this.sourceStack.m_41784_().m_6426_());
            return blockStack;
        }
        return this.sourceStack.m_41777_();
    }

    @Override
    public ItemStack toPatternStack() {
        if (this.sourceStack.m_41720_() instanceof IPatternItem) {
            return this.sourceStack.m_41777_();
        }
        ItemStack singleUsePatternStack = new ItemStack((ItemLike)ModItems.SINGLE_USE_PATTERN_ITEM.get());
        singleUsePatternStack.m_41751_(this.sourceStack.m_41784_().m_6426_());
        return singleUsePatternStack;
    }

    @Override
    public Stream<IStateEntryInfo> streamWithPositionMutator(IPositionMutator positionMutator) {
        return BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).map(positionMutator::mutate).map(blockPos -> new StateEntry(this.compressedSection.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
    }

    @Override
    public void forEachWithPositionMutator(IPositionMutator positionMutator, Consumer<IStateEntryInfo> consumer) {
        BlockPosForEach.forEachInRange(StateEntrySize.current().getBitsPerBlockSide(), blockPos -> {
            Vec3i pos = positionMutator.mutate((Vec3i)blockPos);
            consumer.accept(new StateEntry(this.compressedSection.getBlockInformation(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()), (Vec3i)blockPos, this::setInAreaTarget, this::clearInAreaTarget));
        });
    }

    @Override
    public void rotate(Direction.Axis axis, int rotationCount) {
        this.compressedSection.rotate(axis, rotationCount);
        this.statistics.clear();
        BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(position -> this.statistics.onBlockStateAdded(this.compressedSection.getBlockInformation(position.m_123341_(), position.m_123342_(), position.m_123343_())));
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    @Override
    public void mirror(Direction.Axis axis) {
        this.compressedSection.mirror(axis);
        this.statistics.clear();
        BlockPosStreamProvider.getForRange(StateEntrySize.current().getBitsPerBlockSide()).forEach(position -> this.statistics.onBlockStateAdded(this.compressedSection.getBlockInformation(position.m_123341_(), position.m_123342_(), position.m_123343_())));
        this.sourceStack.m_41784_().m_128365_("chiseledData", (Tag)this.serializeNBT());
    }

    public int hashCode() {
        return this.createNewShapeIdentifier().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IAreaAccessor)) {
            return false;
        }
        IAreaAccessor accessor = (IAreaAccessor)obj;
        return this.createNewShapeIdentifier().equals(accessor.createNewShapeIdentifier());
    }

    @Override
    @NotNull
    public AABB getBoundingBox() {
        return new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    private static final class Statistics
    implements IStatistics {
        private BlockInformation primaryState = BlockInformation.AIR;
        private final Map<BlockInformation, Integer> countMap = Maps.newConcurrentMap();

        private Statistics() {
        }

        @Override
        public BlockInformation getPrimaryState() {
            return this.primaryState;
        }

        @Override
        public boolean isEmpty() {
            return this.countMap.isEmpty() || this.countMap.size() == 1 && this.countMap.containsKey(BlockInformation.AIR);
        }

        private void clear() {
            this.primaryState = BlockInformation.AIR;
            this.countMap.clear();
        }

        private void onBlockStateAdded(BlockInformation blockInformation) {
            this.countMap.putIfAbsent(blockInformation, 0);
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void onBlockStateRemoved(BlockInformation blockInformation) {
            this.countMap.computeIfPresent(blockInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(blockInformation, 0);
            this.updatePrimaryState();
        }

        private void onBlockStateReplaced(BlockInformation currentInformation, BlockInformation newInformation) {
            this.countMap.computeIfPresent(currentInformation, (state, currentCount) -> currentCount - 1);
            this.countMap.remove(currentInformation, 0);
            this.countMap.putIfAbsent(newInformation, 0);
            this.countMap.computeIfPresent(newInformation, (state, currentCount) -> currentCount + 1);
            this.updatePrimaryState();
        }

        private void updatePrimaryState() {
            this.primaryState = this.countMap.entrySet().stream().filter(entry -> !((BlockInformation)entry.getKey()).isAir()).min((o1, o2) -> -1 * ((Integer)o1.getValue() - (Integer)o2.getValue())).map(Map.Entry::getKey).orElse(BlockInformation.AIR);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("primaryState", (Tag)this.primaryState.serializeNBT());
            ListTag blockStateList = new ListTag();
            for (Map.Entry<BlockInformation, Integer> blockStateIntegerEntry : this.countMap.entrySet()) {
                CompoundTag stateNbt = new CompoundTag();
                stateNbt.m_128365_("block_information", (Tag)blockStateIntegerEntry.getKey().serializeNBT());
                stateNbt.m_128405_("count", blockStateIntegerEntry.getValue().intValue());
                blockStateList.add((Object)stateNbt);
            }
            nbt.m_128365_("blockStates", (Tag)blockStateList);
            return nbt;
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            this.countMap.clear();
            this.primaryState = new BlockInformation(nbt.m_128469_("primaryState"));
            ListTag blockStateList = nbt.m_128437_("blockStates", 10);
            for (int i = 0; i < blockStateList.size(); ++i) {
                BlockInformation blockInformation;
                CompoundTag stateNbt = blockStateList.m_128728_(i);
                if (stateNbt.m_128441_("block_information")) {
                    blockInformation = new BlockInformation(stateNbt.m_128469_("block_information"));
                } else if (stateNbt.m_128441_("blockState")) {
                    blockInformation = new BlockInformation(NbtUtils.m_129241_((CompoundTag)stateNbt.m_128469_("blockState")));
                } else {
                    throw new IllegalStateException("Block state information is missing");
                }
                this.countMap.put(blockInformation, stateNbt.m_128451_("count"));
            }
        }

        public void initializeFrom(IStateEntryStorage compressedSection) {
            this.clear();
            compressedSection.count(this.countMap::putIfAbsent);
            this.updatePrimaryState();
        }
    }

    private final class LegacyChunkSectionBasedStorageHandler
    implements ILegacyStorageHandler {
        private LegacyChunkSectionBasedStorageHandler() {
        }

        @Override
        public boolean matches(@NotNull CompoundTag compoundTag) {
            return compoundTag.m_128441_("chiselBlockData");
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            CompoundTag chiselBlockData = nbt.m_128469_("chiselBlockData");
            CompoundTag compressedSectionData = chiselBlockData.m_128469_("compressedStorage");
            LevelChunkSection chunkSection = new LevelChunkSection(0, BuiltinRegistries.f_123865_);
            ChunkSectionUtils.deserializeNBT(chunkSection, (Tag)compressedSectionData);
            SingleBlockMultiStateItemStack.this.compressedSection.loadFromChunkSection(chunkSection);
            if (chiselBlockData.m_128441_("statistics")) {
                CompoundTag statisticsData = chiselBlockData.m_128469_("statistics");
                SingleBlockMultiStateItemStack.this.statistics.deserializeNBT(statisticsData);
            }
        }
    }

    private final class LegacyGZIPStorageBasedStorageHandler
    implements ILegacyStorageHandler {
        private LegacyGZIPStorageBasedStorageHandler() {
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            GZIPDataCompressionUtils.decompress(nbt, compoundTag -> {
                SingleBlockMultiStateItemStack.this.compressedSection.deserializeNBT(compoundTag.m_128469_("chiseledData"));
                SingleBlockMultiStateItemStack.this.statistics.deserializeNBT(compoundTag.m_128469_("statistics"));
            });
        }

        @Override
        public boolean matches(@NotNull CompoundTag compoundTag) {
            return true;
        }
    }

    private final class LZ4StorageBasedStorageHandler
    implements IStorageHandler {
        private LZ4StorageBasedStorageHandler() {
        }

        @Override
        public CompoundTag serializeNBT() {
            return LZ4DataCompressionUtils.compress(compoundTag -> {
                compoundTag.m_128365_("chiseledData", SingleBlockMultiStateItemStack.this.compressedSection.serializeNBT());
                compoundTag.m_128365_("statistics", (Tag)SingleBlockMultiStateItemStack.this.statistics.serializeNBT());
            });
        }

        @Override
        public void deserializeNBT(CompoundTag nbt) {
            LZ4DataCompressionUtils.decompress(nbt, compoundTag -> {
                SingleBlockMultiStateItemStack.this.compressedSection.deserializeNBT(compoundTag.m_128469_("chiseledData"));
                SingleBlockMultiStateItemStack.this.statistics.deserializeNBT(compoundTag.m_128469_("statistics"));
            });
        }
    }

    private static final class ShapeIdentifier
    implements IArrayBackedAreaShapeIdentifier {
        private final IStateEntryStorage snapshot;

        private ShapeIdentifier(IStateEntryStorage chunkSection) {
            this.snapshot = chunkSection.createSnapshot();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IArrayBackedAreaShapeIdentifier)) {
                return false;
            }
            IArrayBackedAreaShapeIdentifier that = (IArrayBackedAreaShapeIdentifier)o;
            return Arrays.equals(this.getBackingData(), that.getBackingData()) && this.getPalette().equals(that.getPalette());
        }

        public int hashCode() {
            return this.snapshot.hashCode();
        }

        @Override
        public byte[] getBackingData() {
            return this.snapshot.getRawData();
        }

        @Override
        public List<BlockInformation> getPalette() {
            return this.snapshot.getContainedPalette();
        }
    }

    private static final class StateEntry
    implements IMutableStateEntryInfo {
        private final BlockInformation blockInformation;
        private final Vec3 startPoint;
        private final Vec3 endPoint;
        private final StateSetter stateSetter;
        private final StateClearer stateClearer;

        public StateEntry(BlockInformation blockInformation, Vec3i startPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this(blockInformation, Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), Vec3.m_82528_((Vec3i)startPoint).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()).m_82520_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit()), stateSetter, stateClearer);
        }

        private StateEntry(BlockInformation blockInformation, Vec3 startPoint, Vec3 endPoint, StateSetter stateSetter, StateClearer stateClearer) {
            this.blockInformation = blockInformation;
            this.startPoint = startPoint;
            this.endPoint = endPoint;
            this.stateSetter = stateSetter;
            this.stateClearer = stateClearer;
        }

        @Override
        @NotNull
        public BlockInformation getBlockInformation() {
            return this.blockInformation;
        }

        @Override
        @NotNull
        public Vec3 getStartPoint() {
            return this.startPoint;
        }

        @Override
        @NotNull
        public Vec3 getEndPoint() {
            return this.endPoint;
        }

        @Override
        public void setBlockInformation(BlockInformation blockInformation) throws SpaceOccupiedException {
            this.stateSetter.set(blockInformation, this.getStartPoint());
        }

        @Override
        public void clear() {
            this.stateClearer.accept(this.getStartPoint());
        }
    }
}

