/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mod.chiselsandbits.ChiselsAndBits;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.IMeasuringManager;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import mod.chiselsandbits.measures.Measurement;
import mod.chiselsandbits.measures.MeasurementNetworkUtil;
import mod.chiselsandbits.network.packets.MeasurementsUpdatedPacket;
import mod.chiselsandbits.platforms.core.dist.Dist;
import mod.chiselsandbits.platforms.core.dist.DistExecutor;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class MeasuringManager
implements IMeasuringManager,
IPacketBufferSerializable {
    private static final MeasuringManager INSTANCE = new MeasuringManager();
    private final Table<ResourceLocation, UUID, Map<MeasuringMode, Measurement>> measurements = HashBasedTable.create();

    public static MeasuringManager getInstance() {
        return INSTANCE;
    }

    private MeasuringManager() {
    }

    @Override
    public Collection<? extends IMeasurement> getInWorld(ResourceLocation worldKey) {
        return this.measurements.row((Object)worldKey).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<? extends IMeasurement> getForPlayer(UUID playerId) {
        return this.measurements.column((Object)playerId).values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet());
    }

    @Override
    public Measurement create(Level world, Player playerEntity, Vec3 from, Vec3 to, Direction hitFace, MeasuringMode mode) {
        return new Measurement(playerEntity.m_142081_(), from, to, hitFace, mode, world.m_46472_().m_135782_());
    }

    @Override
    public void resetMeasurementsFor(UUID playerId) {
        this.measurements.columnMap().remove(playerId);
        this.syncToAll();
    }

    public void syncToAll() {
        ChiselsAndBits.getInstance().getNetworkChannel().sendToEveryone(new MeasurementsUpdatedPacket());
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130130_(this.measurements.size());
        this.measurements.values().forEach(m -> {
            packetBuffer.m_130130_(m.size());
            m.values().forEach(measurement -> measurement.serializeInto(packetBuffer));
        });
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.measurements.clear();
        List measurements = IntStream.range(0, packetBuffer.m_130242_()).mapToObj(index -> {
            int measurementCount = packetBuffer.m_130242_();
            ArrayList measurementList = Lists.newArrayList();
            for (int i = 0; i < measurementCount; ++i) {
                Measurement measurement = new Measurement();
                measurement.deserializeFrom(packetBuffer);
                measurementList.add(measurement);
            }
            return measurementList;
        }).flatMap(Collection::stream).toList();
        measurements.forEach(measurement -> {
            if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
                this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
            }
            ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        });
    }

    public void addOrUpdate(Measurement measurement) {
        if (!this.measurements.contains((Object)measurement.getWorldKey(), (Object)measurement.getOwner())) {
            this.measurements.put((Object)measurement.getWorldKey(), (Object)measurement.getOwner(), new HashMap());
        }
        ((Map)this.measurements.get((Object)measurement.getWorldKey(), (Object)measurement.getOwner())).put(measurement.getMode(), measurement);
        this.syncToAll();
    }

    public void createAndSend(Vec3 from, Vec3 to, Direction hitFace, MeasuringMode mode) {
        DistExecutor.unsafeRunWhenOn(Dist.CLIENT, () -> () -> MeasurementNetworkUtil.createAndSend(from, to, hitFace, mode));
    }
}

