/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.pattern.placement;

import java.util.Optional;
import java.util.stream.Stream;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.exceptions.SpaceOccupiedException;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.multistate.snapshot.IMultiStateSnapshot;
import mod.chiselsandbits.api.pattern.placement.IPatternPlacementType;
import mod.chiselsandbits.api.pattern.placement.PlacementResult;
import mod.chiselsandbits.api.util.BlockPosStreamProvider;
import mod.chiselsandbits.api.util.ColorUtils;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PlacePatternPlacementType
extends AbstractCustomRegistryEntry
implements IPatternPlacementType {
    @Override
    public VoxelShape buildVoxelShapeForWireframe(IMultiStateSnapshot sourceSnapshot, Player player, Vec3 targetedPoint, Direction hitFace) {
        return VoxelShapeManager.getInstance().get((IAreaAccessor)sourceSnapshot, CollisionType.NONE_AIR);
    }

    @Override
    public PlacementResult performPlacement(IMultiStateSnapshot source, BlockPlaceContext context, boolean simulate) {
        boolean hasRequiredBits;
        Vec3 targetedPosition = context.m_43723_().m_6047_() ? context.m_43720_() : Vec3.m_82528_((Vec3i)context.m_8083_());
        IWorldAreaMutator areaMutator = IMutatorFactory.getInstance().covering((LevelAccessor)context.m_43725_(), targetedPosition, targetedPosition.m_82520_(0.9999, 0.9999, 0.9999));
        boolean isAir = BlockPosStreamProvider.getForRange(areaMutator.getInWorldStartPoint(), areaMutator.getInWorldEndPoint()).map(arg_0 -> ((Level)context.m_43725_()).m_8055_(arg_0)).allMatch(BlockBehaviour.BlockStateBase::m_60795_);
        if (!isAir) {
            return PlacementResult.failure(ColorUtils.NOT_FITTING_PATTERN_PLACEMENT_COLOR, (Component)LocalStrings.PatternPlacementNotAnAirBlock.getText());
        }
        IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(context.m_43723_());
        boolean bl = hasRequiredBits = context.m_43723_().m_7500_() || source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockInformation)e.getKey()).isAir()).allMatch(e -> playerBitInventory.canExtract((BlockInformation)e.getKey(), (Integer)e.getValue()));
        if (!hasRequiredBits) {
            return PlacementResult.failure(ColorUtils.MISSING_BITS_OR_SPACE_PATTERN_PLACEMENT_COLOR, (Component)LocalStrings.PatternPlacementNotEnoughBits.getText());
        }
        if (simulate) {
            return PlacementResult.success();
        }
        try (IBatchMutation ignored = areaMutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(context.m_43723_()));){
            ((Stream)source.stream().sequential()).forEach(stateEntryInfo -> {
                try {
                    areaMutator.setInAreaTarget(stateEntryInfo.getBlockInformation(), stateEntryInfo.getStartPoint());
                }
                catch (SpaceOccupiedException spaceOccupiedException) {
                    // empty catch block
                }
            });
        }
        if (!context.m_43723_().m_7500_()) {
            source.getStatics().getStateCounts().entrySet().stream().filter(e -> !((BlockInformation)e.getKey()).isAir()).forEach(e -> playerBitInventory.extract((BlockInformation)e.getKey(), (Integer)e.getValue()));
        }
        return PlacementResult.success();
    }

    @Override
    public Vec3 getTargetedPosition(ItemStack heldStack, Player playerEntity, BlockHitResult blockRayTraceResult) {
        if (playerEntity.m_6047_()) {
            return blockRayTraceResult.m_82450_();
        }
        return Vec3.m_82528_((Vec3i)blockRayTraceResult.m_82425_().m_141952_(blockRayTraceResult.m_82434_().m_122436_()));
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return new ResourceLocation("chiselsandbits", "textures/icons/pattern_place.png");
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.empty();
    }

    @Override
    public Component getDisplayName() {
        return LocalStrings.PatternPlacementModePlacement.getText();
    }
}

