/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import mod.chiselsandbits.storage.IStorageEngine;
import mod.chiselsandbits.storage.IStorageHandler;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;

final class VersionedStorageEngine
implements IStorageEngine {
    private final int minimalVersion;
    private final List<IStorageHandler> handlers;
    private final int currentVersion;
    private final IStorageHandler saveHandler;

    VersionedStorageEngine(LinkedList<IStorageHandler> handlers) {
        this(0, handlers);
    }

    VersionedStorageEngine(int minimalVersion, LinkedList<IStorageHandler> handlers) {
        Validate.notEmpty(handlers);
        this.minimalVersion = minimalVersion;
        this.handlers = Collections.unmodifiableList(handlers);
        this.saveHandler = handlers.getLast();
        this.currentVersion = minimalVersion + handlers.size() - 1;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        this.serializeNBTInto(compoundTag);
        return compoundTag;
    }

    @Override
    public void serializeNBTInto(CompoundTag tag) {
        tag.m_128405_("version", this.currentVersion);
        tag.m_128365_("data", this.saveHandler.serializeNBT());
    }

    @Override
    public void deserializeNBT(@NotNull CompoundTag nbt) {
        if (!nbt.m_128441_("version")) {
            throw new IllegalArgumentException("The given NBT did not contain a versioned storage data entry. Missing the version!");
        }
        int version = nbt.m_128451_("version");
        if (version < this.minimalVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the minimal version is " + this.minimalVersion);
        }
        if (version > this.currentVersion) {
            throw new IllegalArgumentException("The given NBT did contained a version storage data entry, which is of an unsupported version. The version is " + version + ", but the current version is " + this.currentVersion);
        }
        int index = version - this.minimalVersion;
        IStorageHandler handler = this.handlers.get(index);
        handler.deserializeNBT(nbt.m_128469_("data"));
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130079_(this.serializeNBT());
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.deserializeNBT(packetBuffer.m_130261_());
    }

    public Collection<IStorageHandler> getHandlers() {
        return this.handlers;
    }
}

