/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mod.chiselsandbits.api.util.MathUtil;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class DirectionUtils {
    private DirectionUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: DirectionUtils. This is a utility class");
    }

    public static List<Direction> getNotOnAxisOf(@NotNull Direction direction) {
        ArrayList<Direction> list = new ArrayList<Direction>();
        for (Direction d : Direction.values()) {
            if (d.m_122434_() == direction.m_122434_()) continue;
            list.add(d);
        }
        return list;
    }

    public static Optional<Direction> getDirectionVectorBetweenIfAligned(Vec3 l, Vec3 r) {
        return DirectionUtils.getDirectionVectorIfAligned(l.m_82546_(r));
    }

    public static Optional<Direction> getDirectionVectorIfAligned(Vec3 vector) {
        Vec3 scaledToOne = VectorUtils.scaleToOne(vector);
        if (MathUtil.almostEqual(scaledToOne.m_7096_(), 0)) {
            if (MathUtil.almostEqual(scaledToOne.m_7098_(), 0)) {
                if (MathUtil.almostEqual(scaledToOne.m_7094_(), 0)) {
                    return Optional.empty();
                }
                return Optional.of(scaledToOne.m_7094_() < 0.0 ? Direction.NORTH : Direction.SOUTH);
            }
            if (MathUtil.almostEqual(scaledToOne.m_7094_(), 0)) {
                return Optional.of(scaledToOne.m_7098_() < 0.0 ? Direction.DOWN : Direction.UP);
            }
            return Optional.empty();
        }
        if (MathUtil.almostEqual(scaledToOne.m_7098_(), 0)) {
            if (MathUtil.almostEqual(scaledToOne.m_7094_(), 0)) {
                return Optional.of(scaledToOne.m_7094_() < 0.0 ? Direction.WEST : Direction.EAST);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }
}

