/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.crude_burner;

import com.mrh0.createaddition.blocks.base.AbstractBurnerBlock;
import com.mrh0.createaddition.blocks.crude_burner.CrudeBurnerTileEntity;
import com.mrh0.createaddition.index.CATileEntities;
import com.mrh0.createaddition.recipe.crude_burning.CrudeBurningRecipe;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.foundation.block.ITE;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class CrudeBurner
extends AbstractBurnerBlock
implements ITE<CrudeBurnerTileEntity> {
    public CrudeBurner(BlockBehaviour.Properties props) {
        super(props);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CATileEntities.CRUDE_BURNER.create(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tileentity = world.m_7702_(pos);
        if (tileentity instanceof CrudeBurnerTileEntity) {
            CrudeBurnerTileEntity cbte = (CrudeBurnerTileEntity)tileentity;
            ItemStack held = player.m_21205_();
            if (!(held.m_41720_() instanceof BucketItem)) {
                return InteractionResult.CONSUME;
            }
            LazyOptional cap = held.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY);
            if (!cap.isPresent()) {
                return InteractionResult.CONSUME;
            }
            IFluidHandlerItem handler = (IFluidHandlerItem)cap.orElse(null);
            if (handler.getFluidInTank(0).isEmpty()) {
                return InteractionResult.CONSUME;
            }
            FluidStack stack = handler.getFluidInTank(0);
            Optional<CrudeBurningRecipe> recipe = cbte.find(stack, world);
            if (!recipe.isPresent()) {
                return InteractionResult.CONSUME;
            }
            LazyOptional tecap = cbte.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            if (!tecap.isPresent()) {
                return InteractionResult.CONSUME;
            }
            IFluidHandler tehandler = (IFluidHandler)tecap.orElse(null);
            if (tehandler.getTankCapacity(0) - tehandler.getFluidInTank(0).getAmount() < 1000) {
                return InteractionResult.CONSUME;
            }
            if (!tehandler.getFluidInTank(0).isFluidEqual(stack) && !tehandler.getFluidInTank(0).isEmpty()) {
                return InteractionResult.CONSUME;
            }
            tehandler.fill(new FluidStack(handler.getFluidInTank(0).getFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
            if (!player.m_7500_()) {
                player.m_21008_(InteractionHand.MAIN_HAND, new ItemStack((ItemLike)Items.f_42446_, 1));
            }
            player.m_5496_(SoundEvents.f_11778_, 1.0f, 1.0f);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.m_123341_() + 0.5;
            double d1 = pos.m_123342_();
            double d2 = (double)pos.m_123343_() + 0.5;
            if (rand.nextDouble() < 0.1) {
                world.m_7785_(d0, d1, d2, SoundEvents.f_11715_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            Direction.Axis direction$axis = direction.m_122434_();
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            double d5 = direction$axis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = rand.nextDouble() * 9.0 / 16.0;
            double d7 = direction$axis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    public Class<CrudeBurnerTileEntity> getTileEntityClass() {
        return CrudeBurnerTileEntity.class;
    }

    public BlockEntityType<? extends CrudeBurnerTileEntity> getTileEntityType() {
        return (BlockEntityType)CATileEntities.CRUDE_BURNER.get();
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createBurnerTicker(Level level, BlockEntityType<T> type1, BlockEntityType<? extends CrudeBurnerTileEntity> type2) {
        return level.f_46443_ ? null : CrudeBurner.createTickerHelper(type1, type2, CrudeBurnerTileEntity::crudeServerTick);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return CrudeBurner.createBurnerTicker(level, type, (BlockEntityType<? extends CrudeBurnerTileEntity>)((BlockEntityType)CATileEntities.CRUDE_BURNER.get()));
    }

    @Override
    public boolean m_7278_(BlockState state) {
        return true;
    }

    @Override
    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return IComparatorOverride.getComparetorOverride(worldIn, pos);
    }
}

