/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.crude_burner;

import com.mrh0.createaddition.blocks.base.AbstractBurnerBlockEntity;
import com.mrh0.createaddition.network.ObservePacket;
import com.mrh0.createaddition.recipe.FluidRecipeWrapper;
import com.mrh0.createaddition.recipe.crude_burning.CrudeBurningRecipe;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.content.contraptions.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractFurnaceBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class CrudeBurnerTileEntity
extends AbstractBurnerBlockEntity
implements IHaveGoggleInformation,
IComparatorOverride {
    private static final int[] SLOTS = new int[0];
    protected LazyOptional<IFluidHandler> fluidCapability;
    protected FluidTank tankInventory;
    public static final int capacity = 4000;
    private Optional<CrudeBurningRecipe> recipeCache = Optional.empty();
    private Fluid lastFluid = null;
    private int updateTimeout = 10;
    private boolean changed = true;
    public boolean first = true;

    public CrudeBurnerTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.tankInventory = this.createInventory();
        this.fluidCapability = LazyOptional.of(() -> this.tankInventory);
    }

    protected SmartFluidTank createInventory() {
        return new SmartFluidTank(4000, this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        this.update(newFluidStack);
    }

    private void update(FluidStack stack) {
        if (this.f_58857_.m_5776_()) {
            return;
        }
        if (stack.getFluid() != this.lastFluid) {
            this.recipeCache = this.find(stack, this.f_58857_);
        }
        this.lastFluid = stack.getFluid();
        this.changed = true;
    }

    private boolean burning() {
        return this.litTime > 0;
    }

    public int getBurnTime(FluidStack fluid) {
        return this.recipeCache.isPresent() ? this.recipeCache.get().getBurnTime() / 10 : 0;
    }

    public static void crudeServerTick(Level level, BlockPos pos, BlockState state, CrudeBurnerTileEntity be) {
        if (level.m_5776_()) {
            return;
        }
        if (be.first) {
            be.update(be.tankInventory.getFluid());
        }
        be.first = false;
        --be.updateTimeout;
        if (be.updateTimeout < 0) {
            be.updateTimeout = 0;
        }
        if (be.updateTimeout == 0 && be.changed) {
            if (!level.f_46443_) {
                be.m_6596_();
                if (level != null) {
                    level.m_7260_(pos, state, state, 22);
                }
                be.changed = false;
            }
            be.updateTimeout = 10;
        }
        boolean flag = be.burning();
        boolean flag1 = false;
        if (be.burning()) {
            --be.litTime;
        }
        if (!be.f_58857_.m_5776_()) {
            if (!be.burning()) {
                be.litTime = be.getBurnTime(be.tankInventory.getFluid());
                if (be.burning()) {
                    flag1 = true;
                    be.updateTimeout = 0;
                    be.tankInventory.drain(100, IFluidHandler.FluidAction.EXECUTE);
                }
            }
            if (flag != be.burning()) {
                flag1 = true;
                level.m_7731_(pos, (BlockState)be.f_58857_.m_8055_(pos).m_61124_((Property)AbstractFurnaceBlock.f_48684_, (Comparable)Boolean.valueOf(be.burning())), 3);
            }
            if (flag1) {
                be.m_6596_();
            }
        }
    }

    @Override
    public int[] m_7071_(Direction dir) {
        return SLOTS;
    }

    @Override
    public boolean m_7013_(int slot, ItemStack stack) {
        return false;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    @Override
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void read(CompoundTag nbt, boolean clientPacket) {
        if (nbt == null) {
            nbt = new CompoundTag();
        }
        super.read(nbt, clientPacket);
        this.tankInventory.readFromNBT(nbt.m_128469_("TankContent"));
    }

    @Override
    public void write(CompoundTag nbt, boolean clientPacket) {
        super.write(nbt, clientPacket);
        nbt.m_128365_("TankContent", (Tag)this.tankInventory.writeToNBT(new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.read(pkt.m_131708_(), true);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY));
    }

    public Optional<CrudeBurningRecipe> find(FluidStack stack, Level world) {
        return world.m_7465_().m_44015_(CrudeBurningRecipe.TYPE, (Container)new FluidRecipeWrapper(stack), world);
    }

    @Override
    public void onObserved(ServerPlayer player, ObservePacket pack) {
        this.causeBlockUpdate();
    }

    @Override
    public int getComparetorOverride() {
        return (int)((double)this.tankInventory.getFluidAmount() / 4000.0 * 15.0);
    }
}

