/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.sound;

import dan200.computercraft.client.sound.DfpwmStream;
import dan200.computercraft.client.sound.SpeakerSound;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;

public class SpeakerInstance {
    public static final ResourceLocation DFPWM_STREAM = new ResourceLocation("computercraft", "speaker.dfpwm_fake_audio_should_not_be_played");
    private DfpwmStream currentStream;
    private SpeakerSound sound;

    SpeakerInstance() {
    }

    public synchronized void pushAudio(ByteBuf buffer) {
        SpeakerSound sound = this.sound;
        DfpwmStream stream = this.currentStream;
        if (stream == null) {
            stream = this.currentStream = new DfpwmStream();
        }
        boolean exhausted = stream.isEmpty();
        this.currentStream.push(buffer);
        if (exhausted && sound != null && sound.stream == stream && sound.channel != null) {
            sound.executor.execute(() -> {
                if (!sound.channel.m_83680_()) {
                    sound.channel.m_83652_(1);
                }
            });
        }
    }

    public void playAudio(Vec3 position, float volume) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        if (this.sound != null && this.sound.stream != this.currentStream) {
            soundManager.m_120399_((SoundInstance)this.sound);
            this.sound = null;
        }
        if (this.sound != null && !soundManager.m_120403_((SoundInstance)this.sound)) {
            this.sound = null;
        }
        if (this.sound == null && this.currentStream != null) {
            this.sound = new SpeakerSound(DFPWM_STREAM, this.currentStream, position, volume, 1.0f);
            soundManager.m_120367_((SoundInstance)this.sound);
        }
    }

    public void playSound(Vec3 position, ResourceLocation location, float volume, float pitch) {
        SoundManager soundManager = Minecraft.m_91087_().m_91106_();
        this.currentStream = null;
        if (this.sound != null) {
            soundManager.m_120399_((SoundInstance)this.sound);
            this.sound = null;
        }
        this.sound = new SpeakerSound(location, null, position, volume, pitch);
        soundManager.m_120367_((SoundInstance)this.sound);
    }

    void setPosition(Vec3 position) {
        if (this.sound != null) {
            this.sound.setPosition(position);
        }
    }

    void stop() {
        if (this.sound != null) {
            Minecraft.m_91087_().m_91106_().m_120399_((SoundInstance)this.sound);
        }
        this.currentStream = null;
        this.sound = null;
    }
}

