/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.core.lua;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaTable;
import dan200.computercraft.api.lua.LuaValues;
import dan200.computercraft.core.lua.CobaltLuaMachine;
import dan200.computercraft.core.lua.TableImpl;
import java.nio.ByteBuffer;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.squiddev.cobalt.Constants;
import org.squiddev.cobalt.LuaBaseString;
import org.squiddev.cobalt.LuaInteger;
import org.squiddev.cobalt.LuaNumber;
import org.squiddev.cobalt.LuaString;
import org.squiddev.cobalt.LuaValue;
import org.squiddev.cobalt.Varargs;

class VarargArguments
implements IArguments {
    static final IArguments EMPTY = new VarargArguments(Constants.NONE);
    boolean released;
    private final Varargs varargs;
    private Object[] cache;

    VarargArguments(Varargs varargs) {
        this.varargs = varargs;
    }

    @Override
    public int count() {
        return this.varargs.count();
    }

    @Override
    @Nullable
    public Object get(int index) {
        if (index < 0 || index >= this.varargs.count()) {
            return null;
        }
        Object[] cache = this.cache;
        if (cache == null) {
            cache = this.cache = new Object[this.varargs.count()];
        } else {
            Object existing = cache[index];
            if (existing != null) {
                return existing;
            }
        }
        cache[index] = CobaltLuaMachine.toObject(this.varargs.arg(index + 1), null);
        return cache[index];
    }

    @Override
    public IArguments drop(int count) {
        if (count < 0) {
            throw new IllegalStateException("count cannot be negative");
        }
        if (count == 0) {
            return this;
        }
        return new VarargArguments(this.varargs.subargs(count + 1));
    }

    @Override
    public double getDouble(int index) throws LuaException {
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badArgument(index, "number", value.typeName());
        }
        return value.toDouble();
    }

    @Override
    public long getLong(int index) throws LuaException {
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaNumber)) {
            throw LuaValues.badArgument(index, "number", value.typeName());
        }
        return value instanceof LuaInteger ? (long)value.toInteger() : (long)LuaValues.checkFinite(index, value.toDouble());
    }

    @Override
    @Nonnull
    public ByteBuffer getBytes(int index) throws LuaException {
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof LuaBaseString)) {
            throw LuaValues.badArgument(index, "string", value.typeName());
        }
        LuaString str = ((LuaBaseString)value).strvalue();
        return ByteBuffer.wrap(str.bytes, str.offset, str.length).asReadOnlyBuffer();
    }

    @Override
    public Optional<ByteBuffer> optBytes(int index) throws LuaException {
        LuaValue value = this.varargs.arg(index + 1);
        if (value.isNil()) {
            return Optional.empty();
        }
        if (!(value instanceof LuaBaseString)) {
            throw LuaValues.badArgument(index, "string", value.typeName());
        }
        LuaString str = ((LuaBaseString)value).strvalue();
        return Optional.of(ByteBuffer.wrap(str.bytes, str.offset, str.length).asReadOnlyBuffer());
    }

    @Override
    @Nonnull
    public LuaTable<?, ?> getTableUnsafe(int index) throws LuaException {
        if (this.released) {
            throw new IllegalStateException("Cannot use getTableUnsafe after IArguments has been released");
        }
        LuaValue value = this.varargs.arg(index + 1);
        if (!(value instanceof org.squiddev.cobalt.LuaTable)) {
            throw LuaValues.badArgument(index, "table", value.typeName());
        }
        return new TableImpl(this, (org.squiddev.cobalt.LuaTable)value);
    }

    @Override
    @Nonnull
    public Optional<LuaTable<?, ?>> optTableUnsafe(int index) throws LuaException {
        if (this.released) {
            throw new IllegalStateException("Cannot use optTableUnsafe after IArguments has been released");
        }
        LuaValue value = this.varargs.arg(index + 1);
        if (value.isNil()) {
            return Optional.empty();
        }
        if (!(value instanceof org.squiddev.cobalt.LuaTable)) {
            throw LuaValues.badArgument(index, "table", value.typeName());
        }
        return Optional.of(new TableImpl(this, (org.squiddev.cobalt.LuaTable)value));
    }

    @Override
    public void releaseImmediate() {
        this.released = true;
    }
}

