/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.client.sound.SpeakerManager;
import dan200.computercraft.shared.network.NetworkMessage;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;

public class SpeakerPlayClientMessage
implements NetworkMessage {
    private final UUID source;
    private final Vec3 pos;
    private final ResourceLocation sound;
    private final float volume;
    private final float pitch;

    public SpeakerPlayClientMessage(UUID source, Vec3 pos, ResourceLocation event, float volume, float pitch) {
        this.source = source;
        this.pos = pos;
        this.sound = event;
        this.volume = volume;
        this.pitch = pitch;
    }

    public SpeakerPlayClientMessage(FriendlyByteBuf buf) {
        this.source = buf.m_130259_();
        this.pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.sound = buf.m_130281_();
        this.volume = buf.readFloat();
        this.pitch = buf.readFloat();
    }

    @Override
    public void toBytes(@Nonnull FriendlyByteBuf buf) {
        buf.m_130077_(this.source);
        buf.writeDouble(this.pos.m_7096_());
        buf.writeDouble(this.pos.m_7098_());
        buf.writeDouble(this.pos.m_7094_());
        buf.m_130085_(this.sound);
        buf.writeFloat(this.volume);
        buf.writeFloat(this.pitch);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handle(NetworkEvent.Context context) {
        SpeakerManager.getSound(this.source).playSound(this.pos, this.sound, this.volume, this.pitch);
    }
}

