/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.monitor;

import com.mojang.blaze3d.platform.GlStateManager;
import dan200.computercraft.client.util.DirectBuffers;
import dan200.computercraft.client.util.DirectVertexBuffer;
import dan200.computercraft.shared.common.ClientTerminal;
import dan200.computercraft.shared.peripheral.monitor.MonitorRenderer;
import dan200.computercraft.shared.peripheral.monitor.TileMonitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL31;

public final class ClientMonitor
extends ClientTerminal {
    private static final Set<ClientMonitor> allMonitors = new HashSet<ClientMonitor>();
    private final TileMonitor origin;
    public long lastRenderFrame = -1L;
    public BlockPos lastRenderPos = null;
    public int tboBuffer;
    public int tboTexture;
    public int tboUniform;
    public DirectVertexBuffer buffer;

    public ClientMonitor(boolean colour, TileMonitor origin) {
        super(colour);
        this.origin = origin;
    }

    public TileMonitor getOrigin() {
        return this.origin;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean createBuffer(MonitorRenderer renderer) {
        switch (renderer) {
            case TBO: {
                if (this.tboBuffer != 0) {
                    return false;
                }
                this.deleteBuffers();
                this.tboBuffer = DirectBuffers.createBuffer();
                DirectBuffers.setEmptyBufferData(35882, this.tboBuffer, 35044);
                this.tboTexture = GlStateManager.m_84111_();
                GL11.glBindTexture((int)35882, (int)this.tboTexture);
                GL31.glTexBuffer((int)35882, (int)33330, (int)this.tboBuffer);
                GL11.glBindTexture((int)35882, (int)0);
                this.tboUniform = DirectBuffers.createBuffer();
                DirectBuffers.setEmptyBufferData(35345, this.tboUniform, 35044);
                this.addMonitor();
                return true;
            }
            case VBO: {
                if (this.buffer != null) {
                    return false;
                }
                this.deleteBuffers();
                this.buffer = new DirectVertexBuffer();
                this.addMonitor();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addMonitor() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            allMonitors.add(this);
        }
    }

    private void deleteBuffers() {
        if (this.tboBuffer != 0) {
            DirectBuffers.deleteBuffer(35882, this.tboBuffer);
            this.tboBuffer = 0;
        }
        if (this.tboTexture != 0) {
            GlStateManager.m_84541_((int)this.tboTexture);
            this.tboTexture = 0;
        }
        if (this.tboUniform != 0) {
            DirectBuffers.deleteBuffer(35345, this.tboUniform);
            this.tboUniform = 0;
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public void destroy() {
        if (this.tboBuffer != 0 || this.buffer != null) {
            Set<ClientMonitor> set = allMonitors;
            synchronized (set) {
                allMonitors.remove(this);
            }
            this.deleteBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @OnlyIn(value=Dist.CLIENT)
    public static void destroyAll() {
        Set<ClientMonitor> set = allMonitors;
        synchronized (set) {
            Iterator<ClientMonitor> iterator = allMonitors.iterator();
            while (iterator.hasNext()) {
                ClientMonitor monitor = iterator.next();
                monitor.deleteBuffers();
                iterator.remove();
            }
        }
    }
}

