/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.inventory;

import dan200.computercraft.shared.Registry;
import dan200.computercraft.shared.computer.core.ComputerFamily;
import dan200.computercraft.shared.computer.core.IComputer;
import dan200.computercraft.shared.computer.inventory.ContainerComputerBase;
import dan200.computercraft.shared.network.container.ComputerContainerData;
import dan200.computercraft.shared.turtle.core.TurtleBrain;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerTurtle
extends ContainerComputerBase {
    public static final int BORDER = 8;
    public static final int PLAYER_START_Y = 134;
    public static final int TURTLE_START_X = 192;
    public static final int PLAYER_START_X = 25;
    private final ContainerData properties;

    private ContainerTurtle(int id, Predicate<Player> canUse, IComputer computer, ComputerFamily family, Inventory playerInventory, Container inventory, ContainerData properties) {
        super((MenuType<? extends ContainerComputerBase>)((MenuType)Registry.ModContainers.TURTLE.get()), id, canUse, computer, family);
        int x;
        int y;
        this.properties = properties;
        this.m_38884_(properties);
        for (y = 0; y < 4; ++y) {
            for (x = 0; x < 4; ++x) {
                this.m_38897_(new Slot(inventory, x + y * 4, 193 + x * 18, 135 + y * 18));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, x + y * 9 + 9, 25 + x * 18, 135 + y * 18));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            this.m_38897_(new Slot((Container)playerInventory, x2, 25 + x2 * 18, 193));
        }
    }

    public ContainerTurtle(int id, Inventory player, TurtleBrain turtle) {
        this(id, p -> turtle.getOwner().m_6542_((Player)p), turtle.getOwner().createServerComputer(), turtle.getFamily(), player, turtle.getInventory(), turtle::getSelectedSlot);
    }

    public ContainerTurtle(int id, Inventory player, ComputerContainerData data) {
        this(id, x -> true, ContainerTurtle.getComputer(player, data), data.getFamily(), player, (Container)new SimpleContainer(16), (ContainerData)new SimpleContainerData(1));
    }

    public int getSelectedSlot() {
        return this.properties.m_6413_(0);
    }

    @Nonnull
    private ItemStack tryItemMerge(Player player, int slotNum, int firstSlot, int lastSlot, boolean reverse) {
        Slot slot = (Slot)this.f_38839_.get(slotNum);
        ItemStack originalStack = ItemStack.f_41583_;
        if (slot != null && slot.m_6657_()) {
            ItemStack clickedStack = slot.m_7993_();
            originalStack = clickedStack.m_41777_();
            if (!this.m_38903_(clickedStack, firstSlot, lastSlot, reverse)) {
                return ItemStack.f_41583_;
            }
            if (clickedStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (clickedStack.m_41613_() != originalStack.m_41613_()) {
                slot.m_142406_(player, clickedStack);
            } else {
                return ItemStack.f_41583_;
            }
        }
        return originalStack;
    }

    @Nonnull
    public ItemStack m_7648_(@Nonnull Player player, int slotNum) {
        if (slotNum >= 0 && slotNum < 16) {
            return this.tryItemMerge(player, slotNum, 16, 52, true);
        }
        if (slotNum >= 16) {
            return this.tryItemMerge(player, slotNum, 0, 16, false);
        }
        return ItemStack.f_41583_;
    }
}

