/*
 * Decompiled with CFR 0.152.
 */
package org.squiddev.cobalt.lib.doubles;

import java.math.BigInteger;
import org.checkerframework.checker.signedness.qual.Signed;
import org.checkerframework.checker.signedness.qual.SignedPositive;
import org.checkerframework.checker.signedness.qual.SignednessGlb;
import org.checkerframework.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.checker.signedness.qual.Unsigned;
import org.checkerframework.common.value.qual.UnknownVal;

public final class UnsignedValues {
    private static final @UnknownVal @Signed int ASCII_ZERO = 48;
    private static final @Unsigned @UnknownVal long INT_MASK = 0xFFFFFFFFL;
    private static final @Unsigned @UnknownVal long NOT_INT_MASK = -4294967296L;
    private static final @Unsigned @UnknownVal int INT_MIN_VALUE = Integer.MIN_VALUE;
    private static final @Unsigned @UnknownVal long LONG_MIN_VALUE = Long.MIN_VALUE;

    public static @UnknownVal @UnknownSignedness boolean isAssignableToUint(@Unsigned @UnknownVal long value) {
        return (value & 0xFFFFFFFF00000000L) == 0L;
    }

    public static @Unsigned @UnknownVal long toUlong(@Unsigned @UnknownVal int value) {
        return Integer.toUnsignedLong(value);
    }

    public static @Unsigned @UnknownVal long toUlongFromSigned(@SignedPositive @UnknownVal @SignednessGlb int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value must be positive");
        }
        return Integer.toUnsignedLong(value);
    }

    public static @Unsigned @UnknownVal int toUint(@Unsigned @UnknownVal long value) {
        return (int)(value & 0xFFFFFFFFL);
    }

    public static @Unsigned @UnknownVal int toUint(@UnknownVal @UnknownSignedness BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("value must be positive");
        }
        return (int)value.and(BigInteger.valueOf(0xFFFFFFFFL)).longValue();
    }

    public static @Unsigned @UnknownVal int uDivide(@Unsigned @UnknownVal int dividend, @Unsigned @UnknownVal int divisor) {
        return Integer.divideUnsigned(dividend, divisor);
    }

    public static @Unsigned @UnknownVal int uRemainder(@Unsigned @UnknownVal int dividend, @Unsigned @UnknownVal int divisor) {
        return Integer.remainderUnsigned(dividend, divisor);
    }

    public static @Unsigned @UnknownVal long uDivide(@Unsigned @UnknownVal long dividend, @Unsigned @UnknownVal long divisor) {
        return Long.divideUnsigned(dividend, divisor);
    }

    public static @Unsigned @UnknownVal long uRemainder(@Unsigned @UnknownVal long dividend, @Unsigned @UnknownVal long divisor) {
        return Long.remainderUnsigned(dividend, divisor);
    }

    public static @UnknownVal @UnknownSignedness boolean uintLE(@Unsigned @UnknownVal int lval, @Unsigned @UnknownVal int rval) {
        return lval + Integer.MIN_VALUE <= rval + Integer.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean uintLT(@Unsigned @UnknownVal int lval, @Unsigned @UnknownVal int rval) {
        return lval + Integer.MIN_VALUE < rval + Integer.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean uintGE(@Unsigned @UnknownVal int lval, @Unsigned @UnknownVal int rval) {
        return lval + Integer.MIN_VALUE >= rval + Integer.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean uintGT(@Unsigned @UnknownVal int lval, @Unsigned @UnknownVal int rval) {
        return lval + Integer.MIN_VALUE > rval + Integer.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean ulongGE(@Unsigned @UnknownVal long lval, @Unsigned @UnknownVal long rval) {
        return lval + Long.MIN_VALUE >= rval + Long.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean ulongGT(@Unsigned @UnknownVal long lval, @Unsigned @UnknownVal long rval) {
        return lval + Long.MIN_VALUE > rval + Long.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean ulongLE(@Unsigned @UnknownVal long lval, @Unsigned @UnknownVal long rval) {
        return lval + Long.MIN_VALUE <= rval + Long.MIN_VALUE;
    }

    public static @UnknownVal @UnknownSignedness boolean ulongLT(@Unsigned @UnknownVal long lval, @Unsigned @UnknownVal long rval) {
        return lval + Long.MIN_VALUE < rval + Long.MIN_VALUE;
    }

    private UnsignedValues() {
    }

    public static @UnknownVal @Unsigned char digitToChar(@Unsigned @UnknownVal long digit) {
        if (UnsignedValues.ulongGT(digit, 9L)) {
            throw new IllegalArgumentException("digit must be 0-9");
        }
        return (char)(digit + 48L);
    }

    public static @UnknownVal @Unsigned char digitToChar(@Unsigned @UnknownVal int digit) {
        if (UnsignedValues.uintGT(digit, 9)) {
            throw new IllegalArgumentException("digit must be 0-9");
        }
        return (char)(digit + 48);
    }

    public static @UnknownVal @Unsigned char digitToCharWithOverflow(@Unsigned @UnknownVal long digit) {
        if (UnsignedValues.ulongGT(digit, 10L)) {
            throw new IllegalArgumentException("digit must be 0-10");
        }
        return (char)(digit + 48L);
    }

    public static @UnknownVal @Unsigned char digitToCharWithOverflow(@Unsigned @UnknownVal int digit) {
        if (UnsignedValues.uintGT(digit, 10)) {
            throw new IllegalArgumentException("digit must be 0-10");
        }
        return (char)(digit + 48);
    }
}

