/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.level.block.state.BlockState;
import xaero.map.MapProcessor;
import xaero.map.MapWriter;
import xaero.map.WorldMap;
import xaero.map.biome.BiomeColorCalculator;
import xaero.map.biome.BiomeGetter;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.cache.BlockStateShortShapeCache;
import xaero.map.cache.BrokenBlockTintCache;
import xaero.map.controls.ControlsHandler;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.file.MapSaveLoad;
import xaero.map.file.worldsave.WorldDataHandler;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.graphics.TextureUploader;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.gui.message.MessageBox;
import xaero.map.gui.message.render.MessageBoxRenderer;
import xaero.map.highlight.HighlighterRegistry;
import xaero.map.highlight.MapRegionHighlightsPreparer;

public class WorldMapSession {
    private ControlsHandler controlsHandler;
    private MapProcessor mapProcessor;
    private MapWriter mapWriter;
    private MultiTextureRenderTypeRendererProvider multiTextureRenderTypeRenderers;
    private boolean usable;

    public void init() throws NoSuchFieldException {
        BiomeKeyManager biomeKeyManager = new BiomeKeyManager();
        BlockStateShortShapeCache blockStateShortShapeCache = new BlockStateShortShapeCache();
        MapSaveLoad mapSaveLoad = new MapSaveLoad(WorldMap.overlayManager, WorldMap.pngExporter, WorldMap.oldFormatSupport, biomeKeyManager, blockStateShortShapeCache);
        TextureUploader textureUploader = new TextureUploader(WorldMap.normalTextureUploadPool, WorldMap.compressedTextureUploadPool, WorldMap.branchUpdatePool, WorldMap.branchUpdateAllocatePool, WorldMap.branchDownloadPool, WorldMap.subsequentNormalTextureUploadPool, WorldMap.textureUploadBenchmark);
        BiomeGetter biomeGetter = new BiomeGetter(biomeKeyManager);
        BrokenBlockTintCache brokenBlockTintCache = new BrokenBlockTintCache(new HashSet<BlockState>(32));
        BiomeColorCalculator biomeColorCalculator = new BiomeColorCalculator(biomeKeyManager);
        WorldDataReader worldDataReader = new WorldDataReader(WorldMap.overlayManager, biomeKeyManager, blockStateShortShapeCache);
        WorldDataHandler worldDataHandler = new WorldDataHandler(worldDataReader);
        this.multiTextureRenderTypeRenderers = new MultiTextureRenderTypeRendererProvider(2);
        this.mapWriter = new MapWriter(WorldMap.overlayManager, blockStateShortShapeCache, biomeGetter);
        HighlighterRegistry highlightRegistry = new HighlighterRegistry();
        highlightRegistry.end();
        MapRegionHighlightsPreparer mapRegionHighlightsPreparer = new MapRegionHighlightsPreparer();
        this.mapProcessor = new MapProcessor(mapSaveLoad, this.mapWriter, WorldMap.mapLimiter, WorldMap.bufferDeallocator, WorldMap.tilePool, WorldMap.overlayManager, textureUploader, worldDataHandler, WorldMap.worldMapClient.branchTextureRenderer, this.multiTextureRenderTypeRenderers, WorldMap.worldMapClient.customVertexConsumers, biomeColorCalculator, blockStateShortShapeCache, biomeGetter, brokenBlockTintCache, highlightRegistry, mapRegionHighlightsPreparer, MessageBox.Builder.begin().build(), new MessageBoxRenderer());
        this.mapWriter.setMapProcessor(this.mapProcessor);
        mapSaveLoad.setMapProcessor(this.mapProcessor);
        worldDataReader.setMapProcessor(this.mapProcessor);
        this.controlsHandler = new ControlsHandler(this.mapProcessor);
        this.mapProcessor.onInit();
        this.usable = true;
        WorldMap.LOGGER.info("New world map session initialized!");
    }

    public void cleanup() {
        try {
            if (this.usable) {
                this.mapProcessor.stop();
                WorldMap.LOGGER.info("Finalizing world map session...");
                WorldMap.mapRunnerThread.interrupt();
                while (!this.mapProcessor.isFinished()) {
                    this.mapProcessor.waitForLoadingToFinish(() -> {});
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            WorldMap.LOGGER.info("World map session finalized.");
        }
        catch (Throwable t) {
            WorldMap.LOGGER.error("World map session failed to finalize properly.", t);
        }
        this.usable = false;
    }

    public ControlsHandler getControlsHandler() {
        return this.controlsHandler;
    }

    public MapProcessor getMapProcessor() {
        return this.mapProcessor;
    }

    public static WorldMapSession getCurrentSession() {
        WorldMapSession session = WorldMapSession.getForPlayer(Minecraft.m_91087_().f_91074_);
        if (session == null && XaeroWorldMapCore.currentSession != null && XaeroWorldMapCore.currentSession.usable) {
            session = XaeroWorldMapCore.currentSession;
        }
        return session;
    }

    public static WorldMapSession getForPlayer(LocalPlayer player) {
        if (player == null || player.f_108617_ == null) {
            return null;
        }
        return ((IWorldMapClientPlayNetHandler)player.f_108617_).getXaero_worldmapSession();
    }

    public boolean isUsable() {
        return this.usable;
    }
}

