/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import xaero.map.MapProcessor;
import xaero.map.biome.BiomeKey;
import xaero.map.biome.BiomeKeyManager;
import xaero.map.region.MapTile;

public class BiomeColorCalculator {
    public final BiomeKey UNREACHABLE_BIOME;
    public final BiomeKey RIVER_BIOME;
    private BiomeKeyManager biomeKeyManager;

    public BiomeColorCalculator(BiomeKeyManager biomeKeyManager) {
        this.UNREACHABLE_BIOME = biomeKeyManager.get("xaeroworldmap:unreachable_biome");
        this.RIVER_BIOME = biomeKeyManager.get(Biomes.f_48208_.m_135782_().toString());
        this.biomeKeyManager = biomeKeyManager;
    }

    public int getBiomeColor(ColorResolver stateColorResolver, boolean overlay, BlockPos.MutableBlockPos pos, MapTile tile, Registry<Biome> biomeRegistry, MapProcessor mapProcessor) {
        if (stateColorResolver == null) {
            return -1;
        }
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.m_123341_();
        int initZ = pos.m_123343_();
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                if (o != 0 && p != 0) continue;
                pos.m_122178_(initX + o, pos.m_123342_(), initZ + p);
                BiomeKey b = this.getBiomeAtPos((BlockPos)pos, tile, mapProcessor);
                if (b == this.UNREACHABLE_BIOME) continue;
                if (b == null && overlay) {
                    b = this.RIVER_BIOME;
                }
                if (b == null) continue;
                int l = 0;
                Biome gen = this.biomeKeyManager.getBiome(b, biomeRegistry);
                if (gen == null) continue;
                l = stateColorResolver.m_130045_(gen, (double)pos.m_123341_(), (double)pos.m_123343_());
                i += l & 0xFF0000;
                j += l & 0xFF00;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.m_122178_(initX, pos.m_123342_(), initZ);
        if (total == 0) {
            Biome defaultBiome = (Biome)biomeRegistry.m_6246_(Biomes.f_48208_);
            if (defaultBiome == null) {
                return -1;
            }
            return stateColorResolver.m_130045_(defaultBiome, (double)pos.m_123341_(), (double)pos.m_123343_());
        }
        return i / total & 0xFF0000 | j / total & 0xFF00 | k / total;
    }

    public BiomeKey getBiomeAtPos(BlockPos pos, MapTile centerTile, MapProcessor mapProcessor) {
        MapTile tile;
        int tileX = pos.m_123341_() >> 4;
        int tileZ = pos.m_123343_() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : mapProcessor.getMapTile(tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.m_123341_() & 0xF, pos.m_123343_() & 0xF).getBiome();
        }
        return this.UNREACHABLE_BIOME;
    }
}

