/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import com.mojang.blaze3d.shaders.BlendMode;
import com.mojang.blaze3d.shaders.ProgramManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.shader.MapShaders;

public class MapRenderHelper {
    private static BlendMode defaultShaderDisabledBlendState = new BlendMode();
    private static BlendMode defaultShaderBlendState = new BlendMode(770, 771, 32774);

    public static void renderBranchUpdate(float x, float y, float width, float height, int textureX, int textureY, float textureW, float textureH, float fullTextureWidth, float fullTextureHeight, boolean first) {
        RenderSystem.m_157427_(() -> MapShaders.WORLD_MAP_BRANCH);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder vertexBuffer = tessellator.m_85915_();
        vertexBuffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        float normalizedTextureX = (float)textureX / fullTextureWidth;
        float normalizedTextureY = (float)textureY / fullTextureHeight;
        float normalizedTextureX2 = ((float)textureX + textureW) / fullTextureWidth;
        float normalizedTextureY2 = ((float)textureY + textureH) / fullTextureHeight;
        vertexBuffer.m_5483_((double)(x + 0.0f), (double)(y + height), 0.0).m_7421_(normalizedTextureX, normalizedTextureY2).m_5752_();
        vertexBuffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_(normalizedTextureX2, normalizedTextureY2).m_5752_();
        vertexBuffer.m_5483_((double)(x + width), (double)(y + 0.0f), 0.0).m_7421_(normalizedTextureX2, normalizedTextureY).m_5752_();
        vertexBuffer.m_5483_((double)(x + 0.0f), (double)(y + 0.0f), 0.0).m_7421_(normalizedTextureX, normalizedTextureY).m_5752_();
        vertexBuffer.m_85721_();
        if (first) {
            BufferUploader.m_85761_((BufferBuilder)vertexBuffer);
            ProgramManager.m_85578_((int)MapShaders.WORLD_MAP_BRANCH.m_142658_());
        } else {
            BufferUploader.m_166847_((BufferBuilder)vertexBuffer);
        }
    }

    public static void fillIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x1, int y1, int x2, int y2, float r, float g, float b, float a) {
        bufferBuilder.m_85982_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(r, g, b, a).m_5752_();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_85950_(r, g, b, a).m_7421_(textureX1, textureY2).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_85950_(r, g, b, a).m_7421_(textureX2, textureY2).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(textureX2, textureY1).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_85950_(r, g, b, a).m_7421_(textureX1, textureY1).m_5752_();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, r, g, b, a, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_, texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (VertexConsumer)bufferBuilder, x, y, u, v, width, height, r, g, b, a, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, float r, float g, float b, float a, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, r, g, b, a, 256, 256, texture);
    }

    public static void renderDynamicHighlight(PoseStack matrixStack, VertexConsumer overlayBuffer, int flooredCameraX, int flooredCameraZ, int leftX, int rightX, int topZ, int bottomZ, float sideR, float sideG, float sideB, float sideA, float centerR, float centerG, float centerB, float centerA) {
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), overlayBuffer, leftX - 1 - flooredCameraX, topZ - 1 - flooredCameraZ, leftX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), overlayBuffer, leftX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX - flooredCameraX, topZ - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), overlayBuffer, rightX - flooredCameraX, topZ - 1 - flooredCameraZ, rightX + 1 - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), overlayBuffer, leftX - flooredCameraX, bottomZ - flooredCameraZ, rightX - flooredCameraX, bottomZ + 1 - flooredCameraZ, sideR, sideG, sideB, sideA);
        MapRenderHelper.fillIntoExistingBuffer(matrixStack.m_85850_().m_85861_(), overlayBuffer, leftX - flooredCameraX, topZ - flooredCameraZ, rightX - flooredCameraX, bottomZ - flooredCameraZ, centerR, centerG, centerB, centerA);
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float factorX = 1.0f / (float)textureWidth;
        float factorY = 1.0f / (float)textureHeight;
        float textureX1 = (float)u * factorX;
        float textureX2 = (float)(u + width) * factorX;
        float textureY1 = (float)v * factorY;
        float textureY2 = (float)(v + height) * factorY;
        bufferBuilder.m_85982_(matrix, (float)x, (float)(y + height), 0.0f).m_7421_(textureX1, textureY2).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_7421_(textureX2, textureY2).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)(x + width), (float)y, 0.0f).m_7421_(textureX2, textureY1).m_5752_();
        bufferBuilder.m_85982_(matrix, (float)x, (float)y, 0.0f).m_7421_(textureX1, textureY1).m_5752_();
    }

    public static void blitIntoExistingBuffer(Matrix4f matrix, VertexConsumer bufferBuilder, int x, int y, int u, int v, int width, int height) {
        MapRenderHelper.blitIntoExistingBuffer(matrix, bufferBuilder, x, y, u, v, width, height, 256, 256);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int texture) {
        BufferBuilder bufferBuilder = renderer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_, texture);
        MapRenderHelper.blitIntoExistingBuffer(matrix, (VertexConsumer)bufferBuilder, x, y, u, v, width, height, textureWidth, textureHeight);
    }

    public static void blitIntoMultiTextureRenderer(Matrix4f matrix, MultiTextureRenderTypeRenderer renderer, int x, int y, int u, int v, int width, int height, int texture) {
        MapRenderHelper.blitIntoMultiTextureRenderer(matrix, renderer, x, y, u, v, width, height, 256, 256, texture);
    }

    public static void restoreDefaultShaderBlendState() {
        defaultShaderDisabledBlendState.m_85526_();
        defaultShaderBlendState.m_85526_();
        RenderSystem.m_69453_();
    }
}

