/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.highlight;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import xaero.map.highlight.ChunkHighlighter;

public class TestHighlighter
extends ChunkHighlighter {
    public TestHighlighter() {
        super(false);
    }

    @Override
    public boolean regionHasHighlights(ResourceKey<Level> dimension, int regionX, int regionZ) {
        return true;
    }

    @Override
    protected int[] getColors(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        if (!this.chunkIsHighlit(dimension, chunkX, chunkZ)) {
            return null;
        }
        int centerColor = 0x55FF5577;
        int sideColor = 0x55FF55CC;
        this.resultStore[0] = centerColor;
        this.resultStore[1] = (chunkZ & 3) == 0 ? sideColor : centerColor;
        this.resultStore[2] = (chunkX & 3) == 3 ? sideColor : centerColor;
        this.resultStore[3] = (chunkZ & 3) == 3 ? sideColor : centerColor;
        this.resultStore[4] = (chunkX & 3) == 0 ? sideColor : centerColor;
        return this.resultStore;
    }

    @Override
    public int calculateRegionHash(ResourceKey<Level> dimension, int regionX, int regionZ) {
        return 51;
    }

    @Override
    public boolean chunkIsHighlit(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        return (chunkX >> 2 & 1) == (chunkZ >> 2 & 1);
    }

    @Override
    public Component getChunkHighlightSubtleTooltip(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        return new TextComponent("subtle!");
    }

    @Override
    public Component getChunkHighlightBluntTooltip(ResourceKey<Level> dimension, int chunkX, int chunkZ) {
        return new TextComponent("blunt!");
    }

    @Override
    public void addMinimapBlockHighlightTooltips(List<Component> list, ResourceKey<Level> dimension, int blockX, int blockZ, int width) {
        list.add((Component)new TextComponent("minimap tooltip!"));
    }
}

