/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.source.parse;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.jozufozu.flywheel.core.source.parse.AbstractShaderElement;
import com.jozufozu.flywheel.core.source.parse.StructField;
import com.jozufozu.flywheel.core.source.span.Span;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ShaderStruct
extends AbstractShaderElement {
    public static final Pattern struct = Pattern.compile("struct\\s+([\\w\\d]*)\\s*\\{([\\w\\d\\s,;]*)}\\s*;\\s");
    public final Span name;
    public final Span body;
    private final ImmutableList<StructField> fields;
    private final ImmutableMap<String, Span> fields2Types;

    public ShaderStruct(Span self, Span name, Span body) {
        super(self);
        this.name = name;
        this.body = body;
        this.fields = this.parseFields();
        this.fields2Types = this.createTypeLookup();
    }

    public Span getName() {
        return this.name;
    }

    public Span getBody() {
        return this.body;
    }

    public ImmutableList<StructField> getFields() {
        return this.fields;
    }

    private ImmutableMap<String, Span> createTypeLookup() {
        ImmutableMap.Builder lookup = ImmutableMap.builder();
        for (StructField field : this.fields) {
            lookup.put((Object)field.name.get(), (Object)field.type);
        }
        return lookup.build();
    }

    private ImmutableList<StructField> parseFields() {
        Matcher matcher = StructField.fieldPattern.matcher(this.body);
        ImmutableList.Builder fields = ImmutableList.builder();
        while (matcher.find()) {
            Span field = Span.fromMatcher(this.body, matcher);
            Span type = Span.fromMatcher(this.body, matcher, 1);
            Span name = Span.fromMatcher(this.body, matcher, 2);
            fields.add((Object)new StructField(field, type, name));
        }
        return fields.build();
    }

    public String toString() {
        return "struct " + this.name;
    }
}

