/*
 * Decompiled with CFR 0.152.
 */
package com.relatev.minecraft.ariastate.forge;

import com.relatev.minecraft.ariastate.forge.AriaState;
import com.relatev.minecraft.ariastate.forge.PMListener;
import com.relatev.minecraft.ariastate.forge.PositionUtils;
import com.relatev.minecraft.ariastate.protocol.packet.DamageShowPacket;
import com.relatev.minecraft.ariastate.protocol.packet.MissShowPacket;
import com.relatev.minecraft.ariastate.protocol.packet.PMPacket;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class DamageShower
implements PMListener {
    private static int[] numberImageX = new int[]{0, 23, 42, 64, 86, 111, 133, 157, 177, 201, 225};
    public ConcurrentHashMap<DamageShowPacket, Long> numberShows = new ConcurrentHashMap();
    public ConcurrentHashMap<MissShowPacket, Long> missShows = new ConcurrentHashMap();
    private Minecraft mc = Minecraft.func_71410_x();

    public DamageShower() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        AriaState.mainMod.pluginMessager.listeners.add(this);
    }

    @Override
    public void onPacketReceive(PMPacket pmp) {
        if (pmp instanceof DamageShowPacket) {
            this.numberShows.put((DamageShowPacket)pmp, System.currentTimeMillis());
        }
        if (pmp instanceof MissShowPacket) {
            this.missShows.put((MissShowPacket)pmp, System.currentTimeMillis());
        }
    }

    public static void drawNumber(int x, int y, int number, ResourceLocation res) {
        if (number < 0) {
            number = 0;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        String str = number + "";
        for (int i = 0; i < str.length(); ++i) {
            int digit = Integer.parseInt(str.charAt(i) + "");
            mc.func_110434_K().func_110577_a(res);
            int width = numberImageX[digit + 1] - numberImageX[digit];
            Gui.func_146110_a((int)x, (int)y, (float)numberImageX[digit], (float)0.0f, (int)width, (int)26, (float)225.0f, (float)26.0f);
            x += width;
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        Frustum frustum = new Frustum();
        float partialTicks = event.getPartialTicks();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
        frustum.func_78547_a(viewX, viewY, viewZ);
        WorldClient client = mc.field_71441_e;
        Iterator numbersit = ((ConcurrentHashMap.KeySetView)this.numberShows.keySet()).iterator();
        while (numbersit.hasNext()) {
            DamageShowPacket packet = (DamageShowPacket)numbersit.next();
            if (System.currentTimeMillis() - this.numberShows.get(packet) > 1000L) {
                numbersit.remove();
                continue;
            }
            Entity ent = client.func_73045_a(packet.entityId);
            if (ent == null || !(ent instanceof EntityLivingBase)) continue;
            this.renderDamage((EntityLivingBase)ent, event.getPartialTicks(), cameraEntity, packet, this.numberShows.get(packet));
        }
        Iterator missesit = ((ConcurrentHashMap.KeySetView)this.missShows.keySet()).iterator();
        while (missesit.hasNext()) {
            MissShowPacket packet = (MissShowPacket)missesit.next();
            if (System.currentTimeMillis() - this.missShows.get(packet) > 1000L) {
                missesit.remove();
                continue;
            }
            Entity ent = client.func_73045_a(packet.entityId);
            if (ent == null || !(ent instanceof EntityLivingBase)) continue;
            this.renderMiss((EntityLivingBase)ent, event.getPartialTicks(), cameraEntity, packet, this.missShows.get(packet));
        }
    }

    public void renderMiss(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint, MissShowPacket packet, long time) {
        Stack<EntityLivingBase> ridingStack = new Stack<EntityLivingBase>();
        EntityLivingBase entity = passedEntity;
        ridingStack.push(entity);
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        float pastTranslate = 0.0f;
        while (!ridingStack.isEmpty()) {
            boolean boss;
            entity = (EntityLivingBase)ridingStack.pop();
            boolean bl = boss = !entity.func_184222_aU();
            if (!passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || boss) continue;
            double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
            double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
            double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
            float scale = 0.026666673f;
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O)), (float)((float)(z - renderManager.field_78728_n)));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            boolean lighting = GL11.glGetBoolean((int)2896);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179084_k();
            GlStateManager.func_179112_b((int)770, (int)771);
            float padding = 2.0f;
            int bgHeight = 6;
            int barHeight = 4;
            float size = 25.0f;
            GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
            float s = 0.5f;
            GlStateManager.func_179098_w();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            GlStateManager.func_179152_a((float)0.05f, (float)0.05f, (float)0.05f);
            ScaledResolution res = new ScaledResolution(this.mc);
            GlStateManager.func_179109_b((float)PositionUtils.posX(AriaState.mainMod.modSetting.positionDamageShow, res.func_78326_a()), (float)PositionUtils.posY(AriaState.mainMod.modSetting.positionDamageShow, res.func_78328_b()), (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)((int)(-(System.currentTimeMillis() - time))), (float)0.0f);
            GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
            this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/damage_show/miss.png"));
            Gui.func_146110_a((int)-35, (int)-13, (float)0.0f, (float)0.0f, (int)70, (int)27, (float)70.0f, (float)27.0f);
            GlStateManager.func_179094_E();
            float s2 = 0.75f;
            GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            s2 = 0.5f;
            GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
            GlStateManager.func_179109_b((float)(size / (s * s2) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            if (lighting) {
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            pastTranslate -= (float)(bgHeight + barHeight) + padding;
        }
    }

    public void renderDamage(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint, DamageShowPacket packet, long time) {
        Stack<EntityLivingBase> ridingStack = new Stack<EntityLivingBase>();
        EntityLivingBase entity = passedEntity;
        ridingStack.push(entity);
        while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
            entity = (EntityLivingBase)entity.func_184187_bx();
            ridingStack.push(entity);
        }
        float pastTranslate = 0.0f;
        while (!ridingStack.isEmpty()) {
            boolean boss;
            entity = (EntityLivingBase)ridingStack.pop();
            boolean bl = boss = !entity.func_184222_aU();
            if (!passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || boss) continue;
            double x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
            double y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
            double z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
            float scale = 0.026666673f;
            RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O)), (float)((float)(z - renderManager.field_78728_n)));
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
            boolean lighting = GL11.glGetBoolean((int)2896);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179084_k();
            GlStateManager.func_179112_b((int)770, (int)771);
            float padding = 2.0f;
            int bgHeight = 6;
            int barHeight = 4;
            GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
            float s = 0.5f;
            GlStateManager.func_179098_w();
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)s, (float)s, (float)s);
            GlStateManager.func_179152_a((float)0.05f, (float)0.05f, (float)0.05f);
            ScaledResolution res = new ScaledResolution(this.mc);
            GlStateManager.func_179109_b((float)PositionUtils.posX(AriaState.mainMod.modSetting.positionDamageShow, res.func_78326_a()), (float)PositionUtils.posY(AriaState.mainMod.modSetting.positionDamageShow, res.func_78328_b()), (float)0.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)((int)(-(System.currentTimeMillis() - time))), (float)0.0f);
            GlStateManager.func_179152_a((float)20.0f, (float)20.0f, (float)20.0f);
            if (packet.type == DamageShowPacket.DamageType.PLAYER_ATTACK_CRIT) {
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/damage_show/crit.png"));
                Gui.func_146110_a((int)-13, (int)-13, (float)0.0f, (float)0.0f, (int)26, (int)24, (float)26.0f, (float)24.0f);
            }
            DamageShower.drawNumber(0, 0, (int)packet.damage, new ResourceLocation("ariastate", "textures/damage_show/" + packet.type.name().toLowerCase() + ".png"));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179121_F();
            GlStateManager.func_179084_k();
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            if (lighting) {
                GlStateManager.func_179145_e();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            pastTranslate -= (float)(bgHeight + barHeight) + padding;
        }
    }
}

