/*
 * Decompiled with CFR 0.152.
 */
package com.relatev.minecraft.ariastate.forge;

import com.relatev.minecraft.ariastate.forge.AriaState;
import com.relatev.minecraft.ariastate.forge.EntityUtils;
import com.relatev.minecraft.ariastate.forge.PMListener;
import com.relatev.minecraft.ariastate.protocol.object.healthbar.HealthBar;
import com.relatev.minecraft.ariastate.protocol.object.healthbar.HealthBarBossEntity;
import com.relatev.minecraft.ariastate.protocol.object.healthbar.HealthBarBossScreen;
import com.relatev.minecraft.ariastate.protocol.object.healthbar.HealthBarCommon;
import com.relatev.minecraft.ariastate.protocol.packet.PMPacket;
import com.relatev.minecraft.ariastate.protocol.packet.ServerEntityHealthBarPacket;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class HealthBarRender
implements PMListener {
    private Minecraft mc;
    private ConcurrentHashMap<UUID, HealthBar> bars = new ConcurrentHashMap();

    public HealthBarRender() {
        this.mc = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
        AriaState.mainMod.pluginMessager.listeners.add(this);
    }

    private void setRenderNameTag(boolean b) {
        if (b) {
            RenderLivingBase.NAME_TAG_RANGE = 64.0f;
            RenderLivingBase.NAME_TAG_RANGE_SNEAK = 32.0f;
        } else {
            RenderLivingBase.NAME_TAG_RANGE = 0.0f;
            RenderLivingBase.NAME_TAG_RANGE_SNEAK = 0.0f;
        }
    }

    @SubscribeEvent
    public void onRenderLiving(RenderLivingEvent.Pre<EntityLivingBase> event) {
        EntityLivingBase entity = event.getEntity();
        if (this.bars.containsKey(entity.func_110124_au())) {
            this.setRenderNameTag(false);
        } else {
            this.setRenderNameTag(true);
        }
    }

    public static Entity getEntityByUUID(UUID uuid) {
        if (Minecraft.func_71410_x().field_71441_e.func_152378_a(uuid) != null) {
            return Minecraft.func_71410_x().field_71441_e.func_152378_a(uuid);
        }
        for (Entity ent : Minecraft.func_71410_x().field_71441_e.field_72996_f) {
            if (!ent.func_110124_au().equals(uuid)) continue;
            return ent;
        }
        return null;
    }

    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity cameraEntity = mc.func_175606_aa();
        BlockPos renderingVector = cameraEntity.func_180425_c();
        Frustum frustum = new Frustum();
        float partialTicks = event.getPartialTicks();
        double viewX = cameraEntity.field_70142_S + (cameraEntity.field_70165_t - cameraEntity.field_70142_S) * (double)partialTicks;
        double viewY = cameraEntity.field_70137_T + (cameraEntity.field_70163_u - cameraEntity.field_70137_T) * (double)partialTicks;
        double viewZ = cameraEntity.field_70136_U + (cameraEntity.field_70161_v - cameraEntity.field_70136_U) * (double)partialTicks;
        frustum.func_78547_a(viewX, viewY, viewZ);
        for (UUID eid : this.bars.keySet()) {
            EntityLivingBase entity;
            Entity ent = HealthBarRender.getEntityByUUID(eid);
            if (ent == null || !(ent instanceof EntityLivingBase) || (entity = (EntityLivingBase)ent) == mc.field_71439_g || !entity.func_145770_h((double)renderingVector.func_177958_n(), (double)renderingVector.func_177956_o(), (double)renderingVector.func_177952_p()) || !entity.field_70158_ak && !frustum.func_78546_a(entity.func_174813_aQ()) || !entity.func_70089_S() || !entity.func_184182_bu().isEmpty()) continue;
            this.renderHealthBar(entity, partialTicks, cameraEntity);
        }
    }

    public void renderHealthBar(EntityLivingBase passedEntity, float partialTicks, Entity viewPoint) {
        float s2;
        String text;
        int fillwidth;
        String name;
        float s;
        float size;
        int barHeight;
        int bgHeight;
        float padding;
        boolean lighting;
        RenderManager renderManager;
        float scale;
        double z;
        double y;
        double x;
        boolean boss;
        float pastTranslate;
        EntityLivingBase entity;
        Stack<EntityLivingBase> ridingStack;
        HealthBar bar;
        HealthBar hb = this.bars.get(passedEntity.func_110124_au());
        if (hb == null) {
            return;
        }
        if (hb instanceof HealthBarCommon) {
            bar = (HealthBarCommon)hb;
            ridingStack = new Stack<EntityLivingBase>();
            entity = passedEntity;
            ridingStack.push(entity);
            while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
                entity = (EntityLivingBase)entity.func_184187_bx();
                ridingStack.push(entity);
            }
            pastTranslate = 0.0f;
            while (!ridingStack.isEmpty()) {
                entity = (EntityLivingBase)ridingStack.pop();
                boolean bl = boss = !entity.func_184222_aU();
                if ((double)passedEntity.func_70032_d(viewPoint) > bar.distance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || boss) continue;
                x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
                y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
                z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
                scale = 0.026666673f;
                renderManager = Minecraft.func_71410_x().func_175598_ae();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O + 0.6)), (float)((float)(z - renderManager.field_78728_n)));
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
                lighting = GL11.glGetBoolean((int)2896);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179084_k();
                GlStateManager.func_179112_b((int)770, (int)771);
                padding = 2.0f;
                bgHeight = 6;
                barHeight = 4;
                size = 25.0f;
                GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
                s = 0.5f;
                name = I18n.func_135052_a((String)entity.func_145748_c_().func_150254_d(), (Object[])new Object[0]);
                if (bar.name != null) {
                    name = bar.name;
                } else if (entity instanceof EntityLiving && ((EntityLiving)entity).func_145818_k_()) {
                    name = TextFormatting.ITALIC + ((EntityLiving)entity).func_95999_t();
                } else if (entity instanceof EntityVillager) {
                    name = I18n.func_135052_a((String)"entity.Villager.name", (Object[])new Object[0]);
                }
                GlStateManager.func_179098_w();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(-bar.height), (float)0.0f);
                GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/filling.png"));
                fillwidth = (int)((double)(160.0f * passedEntity.func_110143_aJ()) / EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a));
                Gui.func_146110_a((int)-80, (int)28, (float)0.0f, (float)0.0f, (int)fillwidth, (int)21, (float)160.0f, (float)21.0f);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/common.png"));
                Gui.func_146110_a((int)-85, (int)0, (float)0.0f, (float)0.0f, (int)171, (int)55, (float)171.0f, (float)55.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)20.0f, (float)4.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(name, -this.mc.field_71466_p.func_78256_a(name) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)-65.0f, (float)6.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(bar.level, -this.mc.field_71466_p.func_78256_a(bar.level) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                text = "\u00a7f" + (int)passedEntity.func_110143_aJ() + "/" + (int)EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a);
                GlStateManager.func_179109_b((float)0.0f, (float)30.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(text, -this.mc.field_71466_p.func_78256_a(text) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                s2 = 0.75f;
                GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                s2 = 0.5f;
                GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
                GlStateManager.func_179109_b((float)(size / (s * s2) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
                this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                if (lighting) {
                    GlStateManager.func_179145_e();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                pastTranslate -= (float)(bgHeight + barHeight) + padding;
            }
        }
        if (hb instanceof HealthBarBossEntity) {
            bar = (HealthBarBossEntity)hb;
            ridingStack = new Stack();
            entity = passedEntity;
            ridingStack.push(entity);
            while (entity.func_184187_bx() != null && entity.func_184187_bx() instanceof EntityLivingBase) {
                entity = (EntityLivingBase)entity.func_184187_bx();
                ridingStack.push(entity);
            }
            pastTranslate = 0.0f;
            while (!ridingStack.isEmpty()) {
                entity = (EntityLivingBase)ridingStack.pop();
                boolean bl = boss = !entity.func_184222_aU();
                if ((double)passedEntity.func_70032_d(viewPoint) > ((HealthBarBossEntity)bar).distance || !passedEntity.func_70685_l(viewPoint) || entity.func_82150_aj() || boss) continue;
                x = passedEntity.field_70142_S + (passedEntity.field_70165_t - passedEntity.field_70142_S) * (double)partialTicks;
                y = passedEntity.field_70137_T + (passedEntity.field_70163_u - passedEntity.field_70137_T) * (double)partialTicks;
                z = passedEntity.field_70136_U + (passedEntity.field_70161_v - passedEntity.field_70136_U) * (double)partialTicks;
                scale = 0.026666673f;
                renderManager = Minecraft.func_71410_x().func_175598_ae();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)((float)(x - renderManager.field_78730_l)), (float)((float)(y - renderManager.field_78731_m + (double)passedEntity.field_70131_O + 0.6)), (float)((float)(z - renderManager.field_78728_n)));
                GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)(-scale), (float)(-scale), (float)scale);
                lighting = GL11.glGetBoolean((int)2896);
                GlStateManager.func_179140_f();
                GlStateManager.func_179132_a((boolean)false);
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179084_k();
                GlStateManager.func_179112_b((int)770, (int)771);
                padding = 2.0f;
                bgHeight = 6;
                barHeight = 4;
                size = 25.0f;
                GlStateManager.func_179109_b((float)0.0f, (float)pastTranslate, (float)0.0f);
                s = 0.5f;
                name = I18n.func_135052_a((String)entity.func_145748_c_().func_150254_d(), (Object[])new Object[0]);
                if (((HealthBarBossEntity)bar).name != null) {
                    name = ((HealthBarBossEntity)bar).name;
                } else if (entity instanceof EntityLiving && ((EntityLiving)entity).func_145818_k_()) {
                    name = TextFormatting.ITALIC + ((EntityLiving)entity).func_95999_t();
                } else if (entity instanceof EntityVillager) {
                    name = I18n.func_135052_a((String)"entity.Villager.name", (Object[])new Object[0]);
                }
                GlStateManager.func_179098_w();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(-((HealthBarBossEntity)bar).height), (float)0.0f);
                GlStateManager.func_179152_a((float)s, (float)s, (float)s);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/filling.png"));
                fillwidth = (int)((double)(340.0f * passedEntity.func_110143_aJ()) / EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a));
                Gui.func_146110_a((int)-170, (int)34, (float)0.0f, (float)0.0f, (int)fillwidth, (int)30, (float)fillwidth, (float)30.0f);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/boss.png"));
                Gui.func_146110_a((int)-174, (int)0, (float)0.0f, (float)0.0f, (int)348, (int)68, (float)348.0f, (float)68.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)8.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(name, -this.mc.field_71466_p.func_78256_a(name) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                text = "\u00a7e\u00a7l" + (int)passedEntity.func_110143_aJ() + "/" + (int)EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a);
                GlStateManager.func_179109_b((float)0.0f, (float)41.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(text, -this.mc.field_71466_p.func_78256_a(text) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                s2 = 0.75f;
                GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
                GlStateManager.func_179121_F();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                s2 = 0.5f;
                GlStateManager.func_179152_a((float)s2, (float)s2, (float)s2);
                GlStateManager.func_179109_b((float)(size / (s * s2) * 2.0f - 16.0f), (float)0.0f, (float)0.0f);
                this.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179126_j();
                GlStateManager.func_179132_a((boolean)true);
                if (lighting) {
                    GlStateManager.func_179145_e();
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
                pastTranslate -= (float)(bgHeight + barHeight) + padding;
            }
        }
    }

    @SubscribeEvent
    public void onRenderHud(RenderGameOverlayEvent.Pre event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            ScaledResolution sr = event.getResolution();
            for (Entity ent : this.mc.field_71441_e.func_72910_y()) {
                HealthBar hb = this.bars.get(ent.func_110124_au());
                float dis = ent.func_70032_d((Entity)this.mc.field_71439_g);
                if (!(ent instanceof EntityLivingBase) || hb == null || !(hb instanceof HealthBarBossScreen) || !((double)dis < hb.distance)) continue;
                EntityLivingBase passedEntity = (EntityLivingBase)ent;
                HealthBarBossScreen bar = (HealthBarBossScreen)hb;
                String name = I18n.func_135052_a((String)passedEntity.func_145748_c_().func_150254_d(), (Object[])new Object[0]);
                if (bar.name != null) {
                    name = bar.name;
                } else if (passedEntity instanceof EntityLiving && ((EntityLiving)passedEntity).func_145818_k_()) {
                    name = TextFormatting.ITALIC + ((EntityLiving)passedEntity).func_95999_t();
                } else if (passedEntity instanceof EntityVillager) {
                    name = I18n.func_135052_a((String)"entity.Villager.name", (Object[])new Object[0]);
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179147_l();
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179137_b((double)(sr.func_78327_c() / 2.0), (double)20.0, (double)0.0);
                GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/filling.png"));
                int fillwidth = (int)((double)(340.0f * passedEntity.func_110143_aJ()) / EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a));
                Gui.func_146110_a((int)-170, (int)34, (float)0.0f, (float)0.0f, (int)fillwidth, (int)30, (float)fillwidth, (float)30.0f);
                this.mc.func_110434_K().func_110577_a(new ResourceLocation("ariastate", "textures/health_bar/boss.png"));
                Gui.func_146110_a((int)-174, (int)0, (float)0.0f, (float)0.0f, (int)348, (int)68, (float)348.0f, (float)68.0f);
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)8.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(name, -this.mc.field_71466_p.func_78256_a(name) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179094_E();
                String text = "\u00a7e\u00a7l" + (int)passedEntity.func_110143_aJ() + "/" + (int)EntityUtils.resultAttributeValueIgnoreRange(passedEntity, SharedMonsterAttributes.field_111267_a);
                GlStateManager.func_179109_b((float)0.0f, (float)41.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
                this.mc.field_71466_p.func_78276_b(text, -this.mc.field_71466_p.func_78256_a(text) / 2, 0, 0xFFFFFF);
                GlStateManager.func_179121_F();
                GlStateManager.func_179084_k();
                GlStateManager.func_179121_F();
                break;
            }
            this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
        }
    }

    @Override
    public void onPacketReceive(PMPacket pmp) {
        if (pmp instanceof ServerEntityHealthBarPacket) {
            ServerEntityHealthBarPacket packet = (ServerEntityHealthBarPacket)pmp;
            if (packet.bar != null) {
                this.bars.put(packet.entityID, packet.bar);
            } else {
                this.bars.remove(packet.entityID);
            }
        }
    }
}

