/*
 * Decompiled with CFR 0.152.
 */
package com.relatev.minecraft.ariastate.forge;

import com.relatev.minecraft.ariastate.forge.AriaState;
import com.relatev.minecraft.ariastate.forge.PMListener;
import com.relatev.minecraft.ariastate.protocol.packet.MultiArraySubsectionPacket;
import com.relatev.minecraft.ariastate.protocol.packet.PMPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PluginMessager {
    public static final String channelID = "ariastate:pm";
    private FMLEventChannel Channel;
    private byte[] subsectingArray;
    public List<PMListener> listeners = new ArrayList<PMListener>();

    public PluginMessager() {
        this.Channel = NetworkRegistry.INSTANCE.newEventDrivenChannel(channelID);
        this.Channel.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent evt) {
        ByteBuf bb = evt.getPacket().payload();
        byte[] array = new byte[bb.readableBytes()];
        bb.readBytes(array);
        PMPacket pmp = PMPacket.toPacket(array);
        AriaState.logger.info("PluginMessager receive: " + pmp);
        if (pmp != null) {
            if (pmp instanceof MultiArraySubsectionPacket) {
                MultiArraySubsectionPacket packet = (MultiArraySubsectionPacket)pmp;
                if (this.subsectingArray == null) {
                    this.subsectingArray = new byte[0];
                }
                int oldlength = this.subsectingArray.length;
                this.subsectingArray = Arrays.copyOf(this.subsectingArray, oldlength + packet.array.length);
                for (int i = 0; i < packet.array.length; ++i) {
                    this.subsectingArray[i + oldlength] = packet.array[i];
                }
                if (packet.isLastSubsection) {
                    pmp = PMPacket.toPacket(this.subsectingArray);
                    this.subsectingArray = null;
                }
            }
            for (PMListener listener : this.listeners) {
                listener.onPacketReceive(pmp);
            }
        }
    }

    public void sendPacket(PMPacket pmp) {
        byte[] array = pmp.toArray();
        if (array.length >= Short.MAX_VALUE) {
            return;
        }
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])array);
        FMLProxyPacket packet = new FMLProxyPacket(new PacketBuffer(buf), channelID);
        this.Channel.sendToServer(packet);
        AriaState.logger.info("PluginMessager send: " + pmp);
    }
}

