/*
 * Decompiled with CFR 0.152.
 */
package bre.smoothfont.config;

import bre.smoothfont.util.Logger;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class OldConfig {
    private static Configuration config;
    private static final String configVersion;
    public static boolean debugLog;
    public static boolean chatMsg;
    public static boolean enableInterpolation;
    public static boolean enableAlphaBlend;
    public static boolean enablePremultipliedAlpha;
    public static boolean enableDouble;
    public static boolean excludeIntMultiple;
    public static double fontScaleRoundingTolerance;
    public static boolean excludeHighMag;
    public static double limitMagnification;
    public static boolean alternativeInterpolation;
    public static boolean removeScaleRestriction;
    public static boolean disableSmallItalic;
    public static boolean enableMipmap;
    public static int mipmapLevel;
    public static int mipmapLodBias;
    public static int overlayLodBias;
    public static int brightness;
    public static boolean autoBrightness;
    public static boolean useOSFont;
    public static String fontName;
    public static String secondaryFontName;
    public static int fontAntiAlias;
    public static int fontEmphasis;
    public static int fontResIndex;
    public static boolean fontAutoSizing;
    public static int fontSizeAdjustment;
    public static int fontGap;
    public static boolean fontAlignBaseline;
    public static boolean fontDetailList;
    public static int verticalMargin;
    public static int horizontalMargin;
    public static String sizeAdjustChars;
    public static int shadowLength;
    public static int blurReduction;
    public static boolean allowNPOTTexture;
    public static boolean enableAnisotropicFilter;
    public static boolean forceUnicode;
    public static String[] normalPrecisionClasses;
    public static String[] vanillaPrecisionClasses;
    public static String[] unaffectedClasses;
    public static boolean workaroundTransparentScoreboard;
    public static boolean workaroundWrongGlState;
    private static Property debugLogProp;
    private static Property chatMsgProp;
    private static Property enableInterpolationProp;
    private static Property enableAlphaBlendProp;
    private static Property enablePremultipliedAlphaProp;
    private static Property enableDoubleProp;
    private static Property excludeIntMultipleProp;
    private static Property fontScaleRoundingToleranceProp;
    private static Property excludeHighMagProp;
    private static Property limitMagnificationProp;
    private static Property alternativeInterpolationProp;
    private static Property removeScaleRestrictionProp;
    private static Property disableSmallItalicProp;
    private static Property enableMipmapProp;
    private static Property mipmapLevelProp;
    private static Property mipmapLodBiasProp;
    private static Property overlayLodBiasProp;
    private static Property brightnessProp;
    private static Property autoBrightnessProp;
    private static Property useOSFontProp;
    private static Property fontNameProp;
    private static Property secondaryFontNameProp;
    private static Property fontAntiAliasProp;
    private static Property fontEmphasisProp;
    private static Property fontResIndexProp;
    private static Property fontAutoSizingProp;
    private static Property fontSizeAdjProp;
    private static Property fontGapProp;
    private static Property fontAlignBaselineProp;
    private static Property fontDetailListProp;
    private static Property verticalMarginProp;
    private static Property horizontalMarginProp;
    private static Property sizeAdjustCharsProp;
    private static Property shadowLengthProp;
    private static Property blurReductionProp;
    private static Property allowNPOTTextureProp;
    private static Property enableAnisotropicFilterProp;
    private static Property forceUnicodeProp;
    private static Property normalPrecisionClassesProp;
    private static Property vanillaPrecisionClassesProp;
    private static Property unaffectedClassesProp;
    private static Property workaroundTransparentScoreboardProp;
    private static Property workaroundWrongGlStateProp;

    public static void readConfig(File configFile) {
        config = new Configuration(configFile, configVersion);
        try {
            OldConfig.loadConfig(config);
        }
        catch (Exception e) {
            Logger.error("Configuration file access error. (OldConfig)");
        }
    }

    private static void loadConfig(Configuration cfg) {
        cfg.load();
        debugLogProp = cfg.get("debug", "debugLog", false, "Enable debug log.");
        chatMsgProp = cfg.get("debug", "showLogInChat", false, "Show event log on the game screen.");
        enableInterpolationProp = cfg.get("settings", "enableInterpolation", true, "Enable linear interpolation");
        enableAlphaBlendProp = cfg.get("settings", "enableAlphaBlend", true, "Enable alpha blending");
        enablePremultipliedAlphaProp = cfg.get("experiments", "enablePremultipliedAlpha", false, "Enable premultiplied alpha instead of straight alpha.");
        enableDoubleProp = cfg.get("settings", "enableDouble", false, "Enable double rendering");
        excludeIntMultipleProp = cfg.get("settings", "excludeIntMultiple", true, "Disable interpolation for the integral multiple of default size.");
        fontScaleRoundingToleranceProp = cfg.get("settings", "fontScaleRoundingTolerance", 0.5, "Tolerance (in percent) for rounding font scale to integer.(Default: 0.5)");
        excludeHighMagProp = cfg.get("settings", "excludeHighMag", true, "Disable interpolation for characters drawn with high magnification.");
        limitMagnificationProp = cfg.get("settings", "limitMagnification", 3.0, "Disable interpolation for fonts above this magnification when excludeHighMag is enabled.(Default: 3.0)");
        alternativeInterpolationProp = cfg.get("experiments", "alternativeInterpolation", false, "Experimental: Try interpolation for MOD original font renderer.");
        removeScaleRestrictionProp = cfg.get("settings", "removeScaleRestriction", true, "Enable odd multiple GUI scale factors (x3,x5,...) when using unicode font.");
        disableSmallItalicProp = cfg.get("settings", "disableSmallItalic", false, "Disable italic for small fonts.");
        enableMipmapProp = cfg.get("settings", "enableMipmap", true, "Enable mipmap for fonts.");
        mipmapLevelProp = cfg.get("settings", "mipmapLevel", 4, "Mipmap level.");
        mipmapLodBiasProp = cfg.get("settings", "mipmapLodBias", -3, "Mipmap LOD bias.");
        overlayLodBiasProp = cfg.get("settings", "overlayLodBias", -5, "Mipmap LOD bias for overlay screen.");
        brightnessProp = cfg.get("settings", "brightness", 3, "Brightness correction level for interpolated fonts.");
        autoBrightnessProp = cfg.get("settings", "autoBrightness", true, "Automatic detection of brightness.");
        useOSFontProp = cfg.get("settings", "useOSFont", false, "Use the installed fonts in the operating system.");
        fontNameProp = cfg.get("settings", "fontName", "SansSerif", "Primary system font name.");
        secondaryFontNameProp = cfg.get("settings", "secondaryFontName", "SansSerif", "Secondary system font name. It is used if the primary font cannot be displayed.");
        fontAntiAliasProp = cfg.get("settings", "fontAntiAlias", 0, "Enable anti-alias for OS fonts.(0:off, 1:normal, 2:high precision)");
        fontEmphasisProp = cfg.get("settings", "fontEmphasis", 0, "Enable emphasis for OS fonts. (0:off, 1:Ascii only, 2:Non-Ascii, 3:All)");
        fontResIndexProp = cfg.get("settings", "fontResolution", 3, "OS font resolution. (0:8px, 1:10px, 2:12px, 3:16px, 4:24px, 5:32px, 6:48px, 7:64px)");
        fontAutoSizingProp = cfg.get("settings", "fontAutoSizing", true, "Enable automatic font size detection for the font resolution.");
        fontSizeAdjProp = cfg.get("settings", "fontSizeAdjustment", 0, "OS font size. (-4:-20%, ... 0:normal, ... 6:+30%)");
        fontGapProp = cfg.get("settings", "fontGap", -2, "Font gap.");
        fontAlignBaselineProp = cfg.get("settings", "fontAlignBaseline", true, "Align baseline among different fonts.");
        fontDetailListProp = cfg.get("state", "fontDetailList", false, "Internal state.");
        verticalMarginProp = cfg.get("settings", "verticalMargin", 1, "Vertical margin width.");
        horizontalMarginProp = cfg.get("settings", "horizontalMargin", 1, "Horizontal margin width.");
        sizeAdjustCharsProp = cfg.get("settings", "sizeAdjustmentChars", "", "The size of the font is determined so that the height and width of these characters will not protrude.");
        shadowLengthProp = cfg.get("settings", "shadowLength", 5, "Shadow length. (0~10)");
        blurReductionProp = cfg.get("settings", "blurReduction", 10, "Enable a blur reduction for fonts less than or equal to the specified size.(0~16)");
        allowNPOTTextureProp = cfg.get("settings", "allowNPOTTexture", false, "Allow to use NOPT Texture in order to reduce resource consumption.");
        enableAnisotropicFilterProp = cfg.get("settings", "enableAnisotropicFilter", true, "Enable anisotropic filtering.");
        forceUnicodeProp = cfg.get("settings", "forceUnicode", false, "Force to use unicode font.");
        normalPrecisionClassesProp = cfg.get("settings", "normalPrecisionClasses", normalPrecisionClasses, "These font renderer classes use normal precision font width instead of high precision font width.\nAlthough the balance of character spacing is worse, compatibility of string width improves.");
        vanillaPrecisionClassesProp = cfg.get("settings", "vanillaPrecisionClasses", vanillaPrecisionClasses, "These font renderer classes is most high compatibility with vanilla font width calculation,\nbut the precision of font width calculation is more poorer than the other precision modes.");
        unaffectedClassesProp = cfg.get("settings", "unaffectedClasses", unaffectedClasses, "These font renderer classes are not affected by this mod.");
        workaroundTransparentScoreboardProp = cfg.get("settings", "workaroundTransparentScoreboard", true, "Workaround for transparent texts on a scoreboard.");
        workaroundWrongGlStateProp = cfg.get("settings", "workaroundWrongGlState", true, "Workaround for wrong GL state in GlStateManager.\nSome mods directly call GL11 method and don't use GlStateManager properly.\nIf the color of the transparent part changes or the alpha blending is wrong, try this option.");
        OldConfig.setValues();
    }

    private static void setValues() {
        debugLog = debugLogProp.getBoolean();
        chatMsg = chatMsgProp.getBoolean();
        enableInterpolation = enableInterpolationProp.getBoolean();
        enableAlphaBlend = enableAlphaBlendProp.getBoolean();
        enablePremultipliedAlpha = enablePremultipliedAlphaProp.getBoolean();
        enableDouble = enableDoubleProp.getBoolean();
        excludeIntMultiple = excludeIntMultipleProp.getBoolean();
        fontScaleRoundingTolerance = fontScaleRoundingToleranceProp.getDouble();
        excludeHighMag = excludeHighMagProp.getBoolean();
        limitMagnification = limitMagnificationProp.getDouble();
        alternativeInterpolation = alternativeInterpolationProp.getBoolean();
        removeScaleRestriction = removeScaleRestrictionProp.getBoolean();
        disableSmallItalic = disableSmallItalicProp.getBoolean();
        enableMipmap = enableMipmapProp.getBoolean();
        mipmapLevel = mipmapLevelProp.getInt();
        mipmapLodBias = mipmapLodBiasProp.getInt();
        overlayLodBias = overlayLodBiasProp.getInt();
        brightness = brightnessProp.getInt();
        autoBrightness = autoBrightnessProp.getBoolean();
        useOSFont = useOSFontProp.getBoolean();
        fontName = fontNameProp.getString();
        secondaryFontName = secondaryFontNameProp.getString();
        fontAntiAlias = fontAntiAliasProp.getInt();
        fontEmphasis = fontEmphasisProp.getInt();
        fontResIndex = fontResIndexProp.getInt();
        fontAutoSizing = fontAutoSizingProp.getBoolean();
        fontSizeAdjustment = fontSizeAdjProp.getInt();
        fontGap = fontGapProp.getInt();
        fontAlignBaseline = fontAlignBaselineProp.getBoolean();
        fontDetailList = fontDetailListProp.getBoolean();
        verticalMargin = verticalMarginProp.getInt();
        horizontalMargin = horizontalMarginProp.getInt();
        sizeAdjustChars = sizeAdjustCharsProp.getString();
        shadowLength = shadowLengthProp.getInt();
        blurReduction = blurReductionProp.getInt();
        allowNPOTTexture = allowNPOTTextureProp.getBoolean();
        enableAnisotropicFilter = enableAnisotropicFilterProp.getBoolean();
        forceUnicode = forceUnicodeProp.getBoolean();
        normalPrecisionClasses = normalPrecisionClassesProp.getStringList();
        vanillaPrecisionClasses = vanillaPrecisionClassesProp.getStringList();
        unaffectedClasses = unaffectedClassesProp.getStringList();
        workaroundTransparentScoreboard = workaroundTransparentScoreboardProp.getBoolean();
        workaroundWrongGlState = workaroundWrongGlStateProp.getBoolean();
    }

    static {
        configVersion = null;
        normalPrecisionClasses = new String[]{"slimeknights.tconstruct.library.client.CustomFontRenderer", "cofh.core.render.FontRendererCore", "blusunrize.immersiveengineering.client.IEItemFontRender"};
        vanillaPrecisionClasses = new String[0];
        unaffectedClasses = new String[]{"malte0811.industrialWires.client.panelmodel.RawModelFontRenderer"};
    }
}

