/*
 * Decompiled with CFR 0.152.
 */
package com.mrjoshuat.coppergolem.entity;

import com.mrjoshuat.coppergolem.OxidizableBlockCallback;
import com.mrjoshuat.coppergolem.entity.goals.EscapeWaterGoal;
import com.mrjoshuat.coppergolem.entity.goals.PressButtonGoal;
import com.mrjoshuat.coppergolem.entity.goals.RodWiggleGoal;
import com.mrjoshuat.coppergolem.entity.goals.SearchForButtonsGoal;
import com.mrjoshuat.coppergolem.entity.goals.SpinHeadGoal;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1376;
import net.minecraft.class_1427;
import net.minecraft.class_1439;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5274;
import net.minecraft.class_7;
import org.jetbrains.annotations.Nullable;

public class CopperGolemEntity
extends class_1427 {
    protected static final class_2940<Float> LAST_ROD_WIGGLE_TICKS;
    protected static final class_2940<Float> SHOULD_BEND_OVER;
    protected static final class_2940<Integer> OXIDIZATION_LEVEL;
    protected static final class_2940<Integer> LAST_HEAD_SPIN_TICKS;
    protected static final class_2940<Float> LAST_BUTTON_PRESS_TICKS;
    protected static final class_2940<Boolean> IS_WAXED;
    protected static final List<class_1792> ALL_AXES;
    private static final int MIN_LEVEL = 0;
    private static final int MAX_LEVEL = 3;
    private static final float INGOT_HEALTH_INCREASE = 5.0f;
    private class_2338 blockTarget;
    private float headSpinProgress;
    private int cachedOxidationLevel = 0;

    public CopperGolemEntity(class_1299<? extends class_1427> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        if (!world.field_9236) {
            this.setupRandomTickListener();
        }
    }

    protected boolean oxidizationLevelValidForGoals() {
        return this.getOxidisation() != Oxidisation.OXIDIZED;
    }

    protected void method_5959() {
        if (!this.oxidizationLevelValidForGoals()) {
            return;
        }
        int priority = 0;
        this.field_6201.method_6277(++priority, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(++priority, (class_1352)new EscapeWaterGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new class_1374((class_1314)this, 0.5));
        this.field_6201.method_6277(++priority, (class_1352)new SearchForButtonsGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new PressButtonGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new class_5274((class_1314)this, 0.25));
        this.field_6201.method_6277(++priority, (class_1352)new SpinHeadGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new RodWiggleGoal(this));
        this.field_6201.method_6277(++priority, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(++priority, (class_1352)new class_1361((class_1308)this, class_1439.class, 10.0f));
        this.field_6201.method_6277(++priority, (class_1352)new class_1376((class_1308)this));
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        super.method_5800(world, lightning);
        if (!this.getWaxed()) {
            this.setOxidisationLevel(0);
        }
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOULD_BEND_OVER, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(OXIDIZATION_LEVEL, (Object)0);
        this.field_6011.method_12784(LAST_BUTTON_PRESS_TICKS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LAST_ROD_WIGGLE_TICKS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(LAST_HEAD_SPIN_TICKS, (Object)0);
        this.field_6011.method_12784(IS_WAXED, (Object)false);
    }

    public void method_6007() {
        super.method_6007();
        if (this.field_6002.field_9236) {
            return;
        }
        this.tickButtonMovements();
        this.tickHeadSpin();
        this.tickOxidisationAI();
    }

    private void tickButtonMovements() {
        float bendOverTicks;
        float buttonTicksLeft = this.getButtonTicksLeft();
        if (buttonTicksLeft > 0.0f) {
            this.field_6011.method_12778(LAST_BUTTON_PRESS_TICKS, (Object)Float.valueOf(buttonTicksLeft -= 1.0f));
        }
        if (buttonTicksLeft == 0.0f && (bendOverTicks = this.getBendOverTicks()) != 0.0f) {
            if (bendOverTicks > 0.0f) {
                this.setBendOverTicks(bendOverTicks -= 1.0f);
            } else if (bendOverTicks < 0.0f) {
                this.setBendOverTicks(bendOverTicks += 1.0f);
            }
        }
    }

    private void tickHeadSpin() {
        int spinHeadTicks = this.getLastHeadSpinTicks();
        if (spinHeadTicks > 0) {
            this.field_6011.method_12778(LAST_HEAD_SPIN_TICKS, (Object)(spinHeadTicks -= 2));
        }
        if (spinHeadTicks <= 0) {
            return;
        }
        this.headSpinProgress = (float)spinHeadTicks * 0.01f - 0.05f;
    }

    protected void tickOxidisationAI() {
        Oxidisation oxidisation = this.getOxidisation();
        boolean aiDisabled = this.method_5987();
        if (oxidisation == Oxidisation.OXIDIZED && !aiDisabled) {
            this.method_5977(true);
            this.method_35056();
            this.setLastRodWiggleTicksLeft(0.0f);
        } else if (oxidisation != Oxidisation.OXIDIZED && aiDisabled) {
            this.method_5977(false);
            this.method_5959();
        }
    }

    private void setupRandomTickListener() {
        OxidizableBlockCallback.EVENT.register((state, world, pos, random) -> {
            if (this.method_5805() && !this.getWaxed()) {
                this.tickDegradation();
            }
            return class_1269.field_5811;
        });
    }

    private void tickDegradation() {
        int i = this.getOxidizationLevel();
        if (i == 3) {
            return;
        }
        AtomicInteger j = new AtomicInteger();
        AtomicInteger k = new AtomicInteger();
        class_2338 pos = this.method_24515();
        class_238 box = new class_238(pos).method_1009(4.0, 4.0, 4.0);
        List entities = this.field_6002.method_8390(CopperGolemEntity.class, box, golem -> golem != this);
        entities.forEach(entity -> {
            Oxidisation enum_ = entity.getOxidisation();
            if (((Object)((Object)this.getOxidisation())).getClass() == ((Object)((Object)enum_)).getClass()) {
                int m = enum_.ordinal();
                if (m < i) {
                    return;
                }
                if (m > i) {
                    k.getAndIncrement();
                } else {
                    j.getAndIncrement();
                }
            }
        });
        float f = (float)(k.get() + 1) / (float)(k.get() + j.get() + 1);
        float g = f * f * 0.01f;
        float rf = this.field_5974.nextFloat();
        if (rf < g) {
            this.incrementOxidisation();
        }
    }

    public void incrementOxidisation() {
        int level = this.getOxidizationLevel();
        if (level >= 3) {
            return;
        }
        this.setOxidisationLevel(++level);
    }

    public boolean decrementOxidization() {
        int level = this.getOxidizationLevel();
        if (level <= 0) {
            return false;
        }
        this.setOxidisationLevel(--level);
        return true;
    }

    private int oxidisationToItemCountDrop() {
        Oxidisation level = this.getOxidisation();
        if (level == Oxidisation.UNAFFECTED) {
            return 3;
        }
        if (level == Oxidisation.EXPOSED) {
            return 2;
        }
        if (level == Oxidisation.WEATHERED) {
            return 1;
        }
        if (level == Oxidisation.OXIDIZED) {
            return 0;
        }
        return 3;
    }

    protected void method_16077(class_1282 source, boolean causedByPlayer) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_27022, this.oxidisationToItemCountDrop());
        class_2338 pos = this.method_24515();
        class_1542 itemEntity = new class_1542(this.field_6002, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), stack);
        this.field_6002.method_8649((class_1297)itemEntity);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (hand != class_1268.field_5808) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 handItem = stack.method_7909();
        if (ALL_AXES.contains(handItem)) {
            if (this.getWaxed()) {
                this.setWaxed(false);
                if (!player.method_7337()) {
                    stack.method_7970(1, this.method_6051(), (class_3222)null);
                }
                this.addParticle(3004, class_3417.field_29542);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            if (this.decrementOxidization()) {
                this.tickOxidisationAI();
                if (!player.method_7337()) {
                    stack.method_7970(1, this.method_6051(), (class_3222)null);
                }
                this.addParticle(3005, class_3417.field_29541);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
            return class_1269.field_5811;
        }
        if (handItem == class_1802.field_20414 && !this.getWaxed()) {
            this.setWaxed(true);
            if (!player.method_7337()) {
                stack.method_7934(1);
            }
            this.addParticle(3003, class_3417.field_29543);
            return class_1269.method_29236((boolean)this.field_6002.field_9236);
        }
        if (handItem == class_1802.field_27022) {
            float currentHealth = this.method_6032();
            this.method_6025(5.0f);
            if (this.method_6032() > currentHealth) {
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                this.produceParticles((class_2394)class_2398.field_11201);
                return class_1269.method_29236((boolean)this.field_6002.field_9236);
            }
        }
        return class_1269.field_5811;
    }

    protected void produceParticles(class_2394 parameters) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.nextGaussian() * 0.02;
            double e = this.field_5974.nextGaussian() * 0.02;
            double f = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406(parameters, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    private void addParticle(int worldEvent, class_3414 soundEvent) {
        this.field_6002.method_8396(null, this.method_24515(), soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        this.field_6002.method_8444(null, worldEvent, this.method_24515(), 0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("Oxidation", this.getOxidizationLevel());
        nbt.method_10556("Waxed", this.getWaxed());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setOxidisationLevel(nbt.method_10550("Oxidation"));
        this.setWaxed(nbt.method_10577("Waxed"));
    }

    @Nullable
    public class_2338 getBlockTarget() {
        return this.blockTarget;
    }

    public void setBlockTarget(@Nullable class_2338 blockTarget) {
        this.blockTarget = blockTarget;
    }

    public void clearBlockTarget() {
        this.blockTarget = null;
    }

    public Oxidisation getOxidisation() {
        int level = this.getOxidizationLevel();
        if (level <= 0) {
            return Oxidisation.UNAFFECTED;
        }
        if (level == 1) {
            return Oxidisation.EXPOSED;
        }
        if (level == 2) {
            return Oxidisation.WEATHERED;
        }
        return Oxidisation.OXIDIZED;
    }

    public int getOxidizationLevel() {
        return this.cachedOxidationLevel;
    }

    protected void setOxidisationLevel(int f) {
        this.cachedOxidationLevel = f;
        this.field_6011.method_12778(OXIDIZATION_LEVEL, (Object)f);
    }

    public void updateOxidizationLevel() {
        this.cachedOxidationLevel = (Integer)this.field_6011.method_12789(OXIDIZATION_LEVEL);
    }

    protected boolean getWaxed() {
        return (Boolean)this.field_6011.method_12789(IS_WAXED);
    }

    protected void setWaxed(boolean waxed) {
        this.field_6011.method_12778(IS_WAXED, (Object)waxed);
    }

    public void setLastButtonPressTicks(int ticks) {
        this.field_6011.method_12778(LAST_HEAD_SPIN_TICKS, (Object)ticks);
    }

    public int getLastHeadSpinTicks() {
        return (Integer)this.field_6011.method_12789(LAST_HEAD_SPIN_TICKS);
    }

    public float getHeadSpinProgress() {
        return this.headSpinProgress;
    }

    public void setButtonTicksLeft(float ticks) {
        this.field_6011.method_12778(LAST_BUTTON_PRESS_TICKS, (Object)Float.valueOf(ticks));
    }

    public float getButtonTicksLeft() {
        return ((Float)this.field_6011.method_12789(LAST_BUTTON_PRESS_TICKS)).floatValue();
    }

    public void setBendOverTicks(float ticks) {
        this.field_6011.method_12778(SHOULD_BEND_OVER, (Object)Float.valueOf(ticks));
    }

    public float getBendOverTicks() {
        return ((Float)this.field_6011.method_12789(SHOULD_BEND_OVER)).floatValue();
    }

    public void setLastRodWiggleTicksLeft(float ticks) {
        this.field_6011.method_12778(LAST_ROD_WIGGLE_TICKS, (Object)Float.valueOf(ticks));
    }

    public float getLastRodWiggleTicks() {
        return ((Float)this.field_6011.method_12789(LAST_ROD_WIGGLE_TICKS)).floatValue();
    }

    public void method_5674(class_2940<?> data) {
        super.method_5674(data);
        if (this.field_6002.field_9236 && data.equals(OXIDIZATION_LEVEL)) {
            this.updateOxidizationLevel();
        }
    }

    static {
        SHOULD_BEND_OVER = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        OXIDIZATION_LEVEL = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
        LAST_HEAD_SPIN_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13327);
        LAST_BUTTON_PRESS_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        LAST_ROD_WIGGLE_TICKS = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13320);
        IS_WAXED = class_2945.method_12791(CopperGolemEntity.class, (class_2941)class_2943.field_13323);
        ALL_AXES = Arrays.asList(class_1802.field_22025, class_1802.field_8556, class_1802.field_8475, class_1802.field_8825, class_1802.field_8062, class_1802.field_8406);
    }

    public static enum Oxidisation {
        UNAFFECTED,
        EXPOSED,
        WEATHERED,
        OXIDIZED;

    }
}

