/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Ordering;
import java.io.File;
import java.util.Calendar;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import journeymap.client.JourneymapClient;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1074;
import net.minecraft.class_2477;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3283;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class Constants {
    public static final Ordering<String> CASE_INSENSITIVE_NULL_SAFE_ORDER = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).nullsLast();
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private static final Joiner path = Joiner.on((String)File.separator).useForNull("");
    private static final String END = null;
    public static String JOURNEYMAP_DIR = "journeymap";
    public static String CONFIG_DIR_LEGACY = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[0]);
    public static String CONFIG_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"config", new Object[]{Journeymap.JM_VERSION.toMajorMinorString(), END});
    public static String DATA_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"data", new Object[0]);
    public static String SP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.sp, new Object[]{END});
    public static String MP_DATA_DIR = path.join((Object)DATA_DIR, (Object)WorldType.mp, new Object[]{END});
    public static String RESOURCE_PACKS_DEFAULT = "Default";
    private static String ICON_DIR = path.join((Object)JOURNEYMAP_DIR, (Object)"icon", new Object[0]);
    public static String ENTITY_ICON_DIR = path.join((Object)ICON_DIR, (Object)"entity", new Object[]{END});
    public static String WAYPOINT_ICON_DIR = path.join((Object)ICON_DIR, (Object)"waypoint", new Object[]{END});
    public static String THEME_ICON_DIR = path.join((Object)ICON_DIR, (Object)"theme", new Object[]{END});

    public static Locale getLocale() {
        Locale locale = Locale.getDefault();
        try {
            String lang = class_310.method_1551().method_1526().method_4669().getCode();
            locale = new Locale(lang);
        }
        catch (Exception e) {
            Journeymap.getLogger().warn("Couldn't determine locale from game settings, defaulting to " + locale);
        }
        return locale;
    }

    public static String getString(String key) {
        if (class_310.method_1551() == null) {
            return key;
        }
        try {
            String result = Constants.getTranslatedTextComponent(key).getString();
            if (!result.equals(key) || JourneymapClient.getInstance().isMapping().booleanValue()) {
                // empty if block
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static class_2585 getStringTextComponent(String key) {
        return new class_2585(key);
    }

    public static class_2588 getTranslatedTextComponent(String key) {
        return new class_2588(key);
    }

    public static class_5481 getFormattedText(String text, class_2583 style, class_327 fontRenderer, int size) {
        class_2585 textComponent = Constants.getStringTextComponent(text);
        List toolTipList = class_2477.method_10517().method_30933(fontRenderer.method_27527().method_27495((class_5348)textComponent, size, style));
        return class_5481.method_30749((List)toolTipList);
    }

    public static String getString(String key, Object ... params) {
        if (class_310.method_1551() == null) {
            return String.format("%s (%s)", key, Joiner.on((String)",").join(params));
        }
        try {
            String result = class_1074.method_4662((String)key, (Object[])params);
            if (result.equals(key) && JourneymapClient.getInstance().isMapping().booleanValue()) {
                Journeymap.getLogger().warn("Message key not found: " + String.format("%s (%s)", key, Joiner.on((String)",").join(params)));
            }
            return result;
        }
        catch (Throwable t) {
            Journeymap.getLogger().warn(String.format("Message key '%s' threw exception: %s", key, t.getMessage()));
            return key;
        }
    }

    public static boolean safeEqual(String first, String second) {
        int result = CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second);
        if (result != 0) {
            return false;
        }
        return CASE_INSENSITIVE_NULL_SAFE_ORDER.compare((Object)first, (Object)second) == 0;
    }

    public static class_3283 getResourcePacks() {
        class_3283 resourcepackrepository = null;
        try {
            resourcepackrepository = class_310.method_1551().method_1520();
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Can't get resource pack names: %s", LogFormatter.toString(t)));
        }
        return resourcepackrepository;
    }

    public static String birthdayMessage() {
        Calendar today = Calendar.getInstance();
        int month = today.get(2);
        int date = today.get(5);
        if (month == 6 && date == 2) {
            return Constants.getString("jm.common.birthday", "techbrew");
        }
        if (month == 8 && date == 21) {
            return Constants.getString("jm.common.birthday", "mysticdrew");
        }
        if (month == 8 && date == 27) {
            return Constants.getString("jm.common.birthday", "gdude2002");
        }
        return null;
    }

    public static enum WorldType {
        mp,
        sp;

    }
}

