/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.cache.CacheLoader;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.log.JMLogger;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.EntityDTO;
import journeymap.common.helper.BiomeHelper;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;

public class PlayerData
extends CacheLoader<Class, EntityDTO> {
    public static boolean playerIsUnderground(class_310 mc, class_1657 player) {
        if (class_1937.field_25180.equals(player.field_6002.method_27983())) {
            return true;
        }
        int posX = class_3532.method_15357((double)player.method_23317());
        int posY = class_3532.method_15357((double)player.method_5829().field_1322);
        int posZ = class_3532.method_15357((double)player.method_23321());
        boolean offset = true;
        boolean isUnderground = false;
        if (posY < player.method_37908().method_31607()) {
            return true;
        }
        int y = posY;
        block0: for (int x = posX - 1; x <= posX + 1; ++x) {
            for (int z = posZ - 1; z <= posZ + 1; ++z) {
                y = posY + 1;
                ChunkMD chunkMD = DataCache.INSTANCE.getChunkMD(new class_1923(x >> 4, z >> 4));
                if (chunkMD == null) continue;
                if (chunkMD.ceiling(x & 0xF, z & 0xF) <= y) {
                    isUnderground = false;
                    break block0;
                }
                isUnderground = true;
            }
        }
        return isUnderground;
    }

    public EntityDTO load(Class aClass) throws Exception {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        EntityDTO dto = DataCache.INSTANCE.getEntityDTO((class_1309)player);
        dto.update((class_1309)player, false);
        dto.biome = this.getPlayerBiome((class_1657)player);
        dto.underground = PlayerData.playerIsUnderground(mc, (class_1657)player);
        return dto;
    }

    private String getPlayerBiome(class_1657 player) {
        if (player != null) {
            try {
                class_1959 biome = (class_1959)class_310.method_1551().field_1687.method_23753(player.method_24515()).comp_349();
                if (biome != null) {
                    return BiomeHelper.getTranslatedBiomeName(biome);
                }
            }
            catch (Exception e) {
                JMLogger.logOnce("Couldn't get player biome: " + e.getMessage(), e);
            }
        }
        return "?";
    }

    public long getTTL() {
        return JourneymapClient.getInstance().getCoreProperties().cachePlayerData.get().intValue();
    }
}

