/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.data;

import com.google.common.base.Strings;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.feature.Feature;
import journeymap.client.feature.FeatureManager;
import journeymap.client.log.JMLogger;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import journeymap.common.log.LogFormatter;
import journeymap.common.version.VersionCheck;
import net.minecraft.class_1066;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_4877;
import net.minecraft.class_4905;
import net.minecraft.class_5321;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_642;
import net.minecraft.class_746;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.Level;

public class WorldData
extends CacheLoader<Class, WorldData> {
    private static String DAYTIME = Constants.getString("jm.theme.labelsource.gametime.day");
    private static String SUNRISE = Constants.getString("jm.theme.labelsource.gametime.sunrise");
    private static String SUNSET = Constants.getString("jm.theme.labelsource.gametime.sunset");
    private static String NIGHT = Constants.getString("jm.theme.labelsource.gametime.night");
    String name;
    String dimension;
    long time;
    boolean hardcore;
    boolean singlePlayer;
    Map<Feature, Boolean> features;
    String jm_version;
    String latest_journeymap_version;
    String mc_version;
    String mod_name = JourneymapClient.MOD_NAME;
    String iconSetName;
    String[] iconSetNames;
    int browser_poll;

    public static boolean isHardcoreAndMultiplayer() {
        WorldData world = DataCache.INSTANCE.getWorld(false);
        return world.hardcore && !world.singlePlayer;
    }

    private static String getServerName() {
        try {
            class_310 mc;
            String serverName;
            block9: {
                serverName = null;
                mc = class_310.method_1551();
                if (!mc.method_1496()) {
                    try {
                        class_4905 realmsScreen;
                        class_634 netHandler = mc.method_1562();
                        class_437 callbackScreen = netHandler.field_3701;
                        if (!(callbackScreen instanceof class_4905) || !((realmsScreen = (class_4905)callbackScreen) instanceof class_4325)) break block9;
                        class_4325 mainScreen = (class_4325)realmsScreen;
                        class_4877 selectedServer = mainScreen.method_38503();
                        List realmsServers = mainScreen.field_19491;
                        for (class_4877 realmsServer : realmsServers) {
                            if (realmsServer.field_22599 != selectedServer.field_22599) continue;
                            serverName = realmsServer.field_22601;
                            break;
                        }
                    }
                    catch (Throwable t) {
                        Journeymap.getLogger().error("Unable to get Realms server name: " + LogFormatter.toString(t));
                    }
                }
            }
            if (serverName != null) {
                return serverName;
            }
            mc = class_310.method_1551();
            class_642 serverData = mc.method_1558();
            if (serverData != null && (serverName = serverData.field_3752) != null) {
                if (Strings.isNullOrEmpty((String)(serverName = serverName.replaceAll("\\W+", "~").trim()).replaceAll("~", ""))) {
                    serverName = serverData.field_3761;
                }
                return serverName;
            }
            return null;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get service name: " + LogFormatter.toString(t));
            return WorldData.getLegacyServerName();
        }
    }

    public static String getLegacyServerName() {
        try {
            SocketAddress socketAddress;
            class_2535 netManager = class_310.method_1551().method_1562().method_2872();
            if (netManager != null && (socketAddress = netManager.method_10755()) != null && socketAddress instanceof InetSocketAddress) {
                InetSocketAddress inetAddr = (InetSocketAddress)socketAddress;
                return inetAddr.getHostName();
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Couldn't get server name: " + LogFormatter.toString(t));
        }
        return "server";
    }

    public static String getWorldName(class_310 mc) {
        String serverName = null;
        if (mc.method_1496()) {
            return mc.method_1576().field_23784.method_27005();
        }
        serverName = WorldData.getServerName();
        if (serverName == null) {
            return "offline";
        }
        if (Strings.isNullOrEmpty((String)serverName.trim())) {
            serverName = "unnamed";
        }
        return serverName.trim();
    }

    public static List<DimensionProvider> getDimensionProviders() {
        return WorldData.getDimensionProviders(Lists.newArrayList());
    }

    public static List<DimensionProvider> getDimensionProviders(List<String> requiredDimensionList) {
        try {
            HashSet<String> requiredDims = new HashSet<String>(requiredDimensionList);
            HashMap<String, DimensionProvider> dimProviders = new HashMap<String, DimensionProvider>();
            Level logLevel = Level.DEBUG;
            Journeymap.getLogger().log(logLevel, String.format("Required dimensions from waypoints: %s", requiredDimensionList));
            class_310 mc = class_310.method_1551();
            class_5321<class_1937> dimension = DimensionHelper.getDimension((class_1297)mc.field_1724);
            String dimId = DimensionHelper.getDimKeyName(dimension);
            WrappedProvider playerDimProvider = new WrappedProvider(dimension);
            dimProviders.put(dimId, playerDimProvider);
            requiredDims.remove(dimId);
            Journeymap.getLogger().log(logLevel, String.format("Using player's provider for dim %s: %s", dimId, WorldData.getSafeDimensionName(playerDimProvider)));
            for (class_5321<class_1937> class_53212 : DimensionHelper.getClientDimList()) {
                try {
                    WrappedProvider dimProvider = new WrappedProvider(class_53212);
                    dimProviders.put(DimensionHelper.getDimKeyName(class_53212), dimProvider);
                    Journeymap.getLogger().log(logLevel, String.format("DimensionManager.getProvider(%s): %s", class_53212, WorldData.getSafeDimensionName(dimProvider)));
                }
                catch (Throwable t) {
                    JMLogger.logOnce(String.format("Couldn't DimensionManager.getProvider(%s) because of error: %s", class_53212, t), t);
                }
            }
            requiredDims.removeAll(dimProviders.keySet());
            for (String string : requiredDims) {
                if (dimProviders.containsKey(string)) continue;
                dimProviders.put(string, new DummyProvider(DimensionHelper.getWorldKeyForName(string)));
                Journeymap.getLogger().warn(String.format("Used DummyProvider for required dim: %s", string));
            }
            ArrayList<DimensionProvider> providerList = new ArrayList<DimensionProvider>(dimProviders.values());
            Collections.sort(providerList, new Comparator<DimensionProvider>(){

                @Override
                public int compare(DimensionProvider o1, DimensionProvider o2) {
                    return String.valueOf(o1.getDimensionId()).compareTo(o2.getDimensionId());
                }
            });
            return providerList;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Unexpected error in WorldData.getDimensionProviders(): ", t);
            return Collections.emptyList();
        }
    }

    public static String getSafeDimensionName(DimensionProvider dimensionProvider) {
        if (dimensionProvider == null || dimensionProvider.getDimensionId() == null) {
            return null;
        }
        try {
            return dimensionProvider.getDimensionId();
        }
        catch (Exception e) {
            class_310 mc = class_310.method_1551();
            return Constants.getString("jm.common.dimension", DimensionHelper.getDimName((class_1937)mc.field_1687));
        }
    }

    public static String getDimension() {
        class_746 player = class_310.method_1551().field_1724;
        String dim = DimensionHelper.getDimName((class_1297)player);
        String dimName = WorldData.getSafeDimensionName(new WrappedProvider((class_5321<class_1937>)class_310.method_1551().field_1724.field_6002.method_27983()));
        return dimName + " (" + dim + ")";
    }

    public WorldData load(Class aClass) throws Exception {
        class_310 mc = class_310.method_1551();
        class_638.class_5271 worldInfo = mc.field_1687.method_28104();
        class_1132 server = mc.method_1576();
        boolean multiplayer = server == null || server.method_3860();
        this.name = WorldData.getWorldName(mc);
        this.dimension = DimensionHelper.getDimKeyName((class_1937)mc.field_1687);
        this.hardcore = worldInfo.method_152();
        this.singlePlayer = !multiplayer;
        this.time = mc.field_1687.method_8532() % 24000L;
        this.features = FeatureManager.getInstance().getAllowedFeatures();
        this.mod_name = JourneymapClient.MOD_NAME;
        this.jm_version = Journeymap.JM_VERSION.toString();
        this.latest_journeymap_version = VersionCheck.getVersionAvailable();
        this.mc_version = (String)class_1066.method_4636().get("X-Minecraft-Version");
        this.browser_poll = Math.max(1000, JourneymapClient.getInstance().getCoreProperties().browserPoll.get());
        return this;
    }

    public static String getLightLevel() {
        class_2338 blockpos = class_310.method_1551().field_1724.method_24515();
        class_638 world = class_310.method_1551().field_1687;
        class_2818 chunk = world.method_8500(blockpos);
        int light = chunk.method_12200().method_22336().method_22363(blockpos, 0);
        int lightSky = world.method_8314(class_1944.field_9284, blockpos);
        int lightBlock = world.method_8314(class_1944.field_9282, blockpos);
        return String.format("Light: %s (%s sky, %s block)", light, lightSky, lightBlock);
    }

    public static String getRegion() {
        class_2338 blockpos = class_310.method_1551().field_1724.method_24515();
        class_2818 chunk = class_310.method_1551().field_1687.method_8500(blockpos);
        RegionCoord regionCoord = RegionCoord.fromChunkPos(null, MapType.none(), chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        return "Region: x:" + regionCoord.regionX + " z:" + regionCoord.regionZ;
    }

    public static String getRealGameTime() {
        String format = JourneymapClient.getInstance().getActiveMiniMapProperties().gameTimeRealFormat.get();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(format);
        class_310 minecraft = class_310.method_1551();
        long time = minecraft.field_1687.method_8532();
        long hour = (time / 1000L + 6L) % 24L;
        long minute = time % 1000L * 60L / 1000L;
        double ticks = (double)time - Math.floor((double)time / 16.666666666666668) * 16.666666666666668;
        long seconds = (long)Math.floor(ticks / 0.2777777777777778);
        String timeString = String.format(Locale.ENGLISH, "%02d:%02d:%02d", hour, minute, seconds);
        String formattedTime = LocalTime.parse(timeString).format(dtf);
        return formattedTime + " " + WorldData.getContextTime(time % 24000L);
    }

    public static String getMoonPhase() {
        int phase = class_310.method_1551().field_1687.method_30273();
        long worldTime = class_310.method_1551().field_1687.method_8532() % 24000L;
        if (WorldData.isDay(worldTime)) {
            phase = 10;
        }
        return MoonPhase.fromPhase(phase);
    }

    public static String getSystemTime() {
        SimpleDateFormat timeFormat = new SimpleDateFormat(JourneymapClient.getInstance().getActiveMiniMapProperties().systemTimeRealFormat.get());
        return timeFormat.format(new Date());
    }

    public static String getGameTime() {
        if (class_310.method_1551().field_1687 != null) {
            long worldTime = class_310.method_1551().field_1687.method_8532() % 24000L;
            long allSecs = worldTime / 20L;
            return String.format("%02d:%02d %s", (long)Math.floor(allSecs / 60L), (long)Math.ceil(allSecs % 60L), WorldData.getContextTime(worldTime));
        }
        return "";
    }

    private static String getContextTime(long worldTime) {
        if (worldTime < 12000L) {
            return DAYTIME;
        }
        if (worldTime < 13800L) {
            return SUNSET;
        }
        if (worldTime < 22200L) {
            return NIGHT;
        }
        return SUNRISE;
    }

    public static boolean isDay(long worldTime) {
        return worldTime % 24000L < 13800L;
    }

    public static boolean isNight(long worldTime) {
        return worldTime % 24000L >= 13800L;
    }

    public long getTTL() {
        return 1000L;
    }

    public static class WrappedProvider
    implements DimensionProvider {
        class_5321<class_1937> dimension;

        public WrappedProvider(class_5321<class_1937> dimension) {
            this.dimension = dimension;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dimension);
        }

        @Override
        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        @Override
        public String getName() {
            String dim = DimensionHelper.getDimName(this.dimension).replace("_", " ");
            return WordUtils.capitalize((String)dim);
        }
    }

    public static interface DimensionProvider {
        public String getDimensionId();

        public class_5321<class_1937> getDimension();

        public String getName();
    }

    static class DummyProvider
    implements DimensionProvider {
        final class_5321<class_1937> dim;

        DummyProvider(class_5321<class_1937> dim) {
            this.dim = dim;
        }

        @Override
        public String getDimensionId() {
            return DimensionHelper.getDimKeyName(this.dim);
        }

        @Override
        public class_5321<class_1937> getDimension() {
            return null;
        }

        @Override
        public String getName() {
            return "Dimension " + DimensionHelper.getDimName(this.dim);
        }
    }

    static enum MoonPhase {
        DAY_TIME(10, "jm.theme.labelsource.moonphase.day"),
        FULL_MOON(0, "jm.theme.labelsource.moonphase.full_moon"),
        WANING_GIBBOUS(1, "jm.theme.labelsource.moonphase.waning_gibbous"),
        THIRD_QUARTER(2, "jm.theme.labelsource.moonphase.third_quarter"),
        WANING_CRESCENT(3, "jm.theme.labelsource.moonphase.waning_crescent"),
        NEW_MOON(4, "jm.theme.labelsource.moonphase.new_moon"),
        WAXING_CRESCENT(5, "jm.theme.labelsource.moonphase.waxing_crescent"),
        FIRST_QUARTER(6, "jm.theme.labelsource.moonphase.first_quarter"),
        WAXING_GIBBOUS(7, "jm.theme.labelsource.moonphase.waxing_gibbous");

        final int phase;
        final String key;
        static final Map<Integer, String> PHASE_MAP;

        private MoonPhase(int phase, String key) {
            this.phase = phase;
            this.key = key;
        }

        public static String fromPhase(int phase) {
            String phaseName = Constants.getString(PHASE_MAP.get(phase));
            String moonPhase = Constants.getString("jm.theme.labelsource.moonphase.pre");
            return moonPhase + phaseName;
        }

        static {
            PHASE_MAP = Stream.of(MoonPhase.values()).collect(Collectors.toMap(e -> e.phase, e -> e.key));
        }
    }
}

