/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.model;

import java.awt.Color;
import journeymap.client.Constants;
import journeymap.client.api.option.KeyedEnum;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import net.minecraft.class_2960;
import net.minecraft.class_757;

public class GridSpec {
    public final Style style;
    public final float red;
    public final float green;
    public final float blue;
    public final float alpha;
    private int colorX = -1;
    private int colorY = -1;
    private transient TextureImpl texture = null;

    public GridSpec(Style style, Color color, float alpha) {
        this.style = style;
        float[] rgb = RGB.floats(color.getRGB());
        this.red = rgb[0];
        this.green = rgb[1];
        this.blue = rgb[2];
        if (alpha < 0.0f) {
            alpha = 0.0f;
        }
        while (alpha > 1.0f) {
            alpha /= 100.0f;
        }
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec(Style style, float red, float green, float blue, float alpha) {
        this.style = style;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        assert (alpha <= 1.0f);
    }

    public GridSpec setColorCoords(int x, int y) {
        this.colorX = x;
        this.colorY = y;
        return this;
    }

    public void beginTexture(int textureFilter, int textureWrap, float mapAlpha) {
        RenderWrapper.enableBlend();
        RenderWrapper.defaultBlendFunc();
        RenderWrapper.enableTexture();
        RenderWrapper.setShader(class_757::method_34542);
        RenderWrapper.activeTexture(33984);
        RenderWrapper.bindTexture(this.getTexture().getGlTextureId(false));
        RenderWrapper.setShaderTexture(0, this.getTexture().getGlTextureId(false));
        RenderWrapper.setColor4f(this.red, this.green, this.blue, this.alpha * mapAlpha);
        RenderWrapper.texParameter(3553, 10241, textureFilter);
        RenderWrapper.texParameter(3553, 10240, textureFilter);
        RenderWrapper.texParameter(3553, 10242, textureWrap);
        RenderWrapper.texParameter(3553, 10243, textureWrap);
    }

    public TextureImpl getTexture() {
        if (this.texture == null || this.texture.isDefunct()) {
            this.texture = TextureCache.getTexture(this.style.textureLocation);
        }
        return this.texture;
    }

    public GridSpec clone() {
        return new GridSpec(this.style, this.red, this.green, this.blue, this.alpha).setColorCoords(this.colorX, this.colorY);
    }

    public void finishTexture() {
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.clearColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Integer getColor() {
        return RGB.toInteger(this.red, this.green, this.blue);
    }

    public int getColorX() {
        return this.colorX;
    }

    public int getColorY() {
        return this.colorY;
    }

    public static enum Style implements KeyedEnum
    {
        Squares("jm.common.grid_style_squares", TextureCache.GridSquares),
        SquaresWithRegion("jm.common.grid_style_squares_region", TextureCache.GridRegionSquares),
        GridRegion("jm.common.grid_style_region", TextureCache.GridRegion),
        Dots("jm.common.grid_style_dots", TextureCache.GridDots),
        Checkers("jm.common.grid_style_checkers", TextureCache.GridCheckers);

        private final String key;
        private final class_2960 textureLocation;

        private Style(String key, class_2960 textureLocation) {
            this.key = key;
            this.textureLocation = textureLocation;
        }

        public String displayName() {
            return Constants.getString(this.key);
        }

        public String getKey() {
            return this.key;
        }
    }
}

