/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.task.multi;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.function.Consumer;
import journeymap.client.api.display.Context;
import journeymap.client.io.FileHandler;
import journeymap.client.io.RegionImageHandler;
import journeymap.client.model.MapType;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_5321;

public class ApiImageTask
implements Runnable {
    final String modId;
    final class_5321<class_1937> dimension;
    final MapType mapType;
    final class_1923 startChunk;
    final class_1923 endChunk;
    final Integer vSlice;
    final int zoom;
    final boolean showGrid;
    final File jmWorldDir;
    final Consumer<BufferedImage> callback;

    public ApiImageTask(String modId, class_5321<class_1937> dimension, Context.MapType apiMapType, class_1923 startChunk, class_1923 endChunk, Integer vSlice, int zoom, boolean showGrid, Consumer<BufferedImage> callback) {
        this.modId = modId;
        this.dimension = dimension;
        this.startChunk = startChunk;
        this.endChunk = endChunk;
        this.zoom = zoom;
        this.showGrid = showGrid;
        this.callback = callback;
        this.vSlice = vSlice;
        this.mapType = MapType.fromApiContextMapType(apiMapType, vSlice, dimension);
        this.jmWorldDir = FileHandler.getJMWorldDir(class_310.method_1551());
    }

    @Override
    public void run() {
        BufferedImage image = null;
        try {
            int scale = (int)Math.pow(2.0, this.zoom);
            image = RegionImageHandler.getMergedChunks(this.jmWorldDir, this.startChunk, this.endChunk, this.mapType, scale, this.showGrid);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in ApiImageTask: {}" + t, (Object)LogFormatter.toString(t));
        }
        BufferedImage finalImage = image;
        class_310.method_1551().method_20493(() -> this.callback.accept(finalImage));
    }
}

