/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import journeymap.client.Constants;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.render.texture.TextureCache;
import journeymap.client.render.texture.TextureImpl;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.accessors.ScreenAccess;
import journeymap.common.log.LogFormatter;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5481;
import org.apache.logging.log4j.Logger;

public abstract class JmUI
extends class_437
implements ScreenAccess {
    protected final String title;
    protected final int headerHeight = 35;
    protected final Logger logger = Journeymap.getLogger();
    protected int scaleFactor = 1;
    protected TextureImpl logo = TextureCache.getTexture(TextureCache.Logo);
    protected static Stack<class_437> returnDisplayStack = new Stack();
    protected boolean renderBottomBar = false;

    public JmUI(String title) {
        this(title, null);
    }

    public JmUI(String title, class_437 returnDisplay) {
        super((class_2561)Constants.getStringTextComponent(title));
        this.title = title;
        returnDisplayStack.push(returnDisplay);
    }

    public class_310 getMinecraft() {
        this.field_22787 = class_310.method_1551();
        return this.field_22787;
    }

    public void method_25423(class_310 minecraft, int width, int height) {
        super.method_25423(minecraft, width, height);
        this.scaleFactor = (int)minecraft.method_22683().method_4495();
    }

    public boolean method_25421() {
        return true;
    }

    public class_327 getFontRenderer() {
        return this.field_22793;
    }

    public void sizeDisplay(class_4587 mStack, boolean scaled) {
        int glwidth = scaled ? this.field_22789 : this.field_22787.method_22683().method_4480();
        int glheight = scaled ? this.field_22790 : this.field_22787.method_22683().method_4507();
        DrawUtil.sizeDisplay(mStack, glwidth, glheight);
    }

    protected boolean isMouseOverButton(double mouseX, double mouseY) {
        for (int k = 0; k < this.getRenderables().size(); ++k) {
            Button button;
            class_4185 guibutton = (class_4185)this.getRenderables().get(k);
            if (!(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int mouseEvent) {
        return super.method_25406(mouseX, mouseY, mouseEvent);
    }

    protected void drawLogo(class_4587 mStack) {
        if (this.logo.isDefunct()) {
            this.logo = TextureCache.getTexture(TextureCache.Logo);
        }
        DrawUtil.sizeDisplay(mStack, this.field_22787.method_22683().method_4480(), this.field_22787.method_22683().method_4507());
        DrawUtil.drawImage(mStack, this.logo, 8.0, 8.0, false, 0.5f, 0.0);
        DrawUtil.sizeDisplay(mStack, this.field_22789, this.field_22790);
    }

    protected void renderBottomBar(class_4587 stack) {
        if (this.renderBottomBar) {
            DrawUtil.drawRectangle(stack, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.6f);
        }
    }

    protected void drawTitle(class_4587 mStack) {
        DrawUtil.drawRectangle(mStack, 0.0, 0.0, this.field_22789, 35.0, 0, 0.9f);
        DrawUtil.drawLabel(mStack, this.title, this.field_22789 / 2, 17.0, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 0.0f, Color.CYAN.getRGB(), 1.0f, 1.0, true, 0.0);
        String apiVersion = "API v1.8-SNAPSHOT";
        DrawUtil.drawLabel(mStack, apiVersion, this.field_22789 - 10, 17.0, DrawUtil.HAlign.Left, DrawUtil.VAlign.Middle, 0, 0.0f, 0xCCCCCC, 1.0f, 0.5, true, 0.0);
    }

    public void method_25426() {
        this.getRenderables().clear();
    }

    public void method_25420(class_4587 mStack) {
        if (class_310.method_1551().field_1687 == null) {
            this.drawGradientRect(mStack, 0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        } else {
            super.method_25420(mStack);
        }
    }

    protected abstract void layoutButtons(class_4587 var1);

    public List getButtonList() {
        return this.getRenderables();
    }

    public void method_25394(class_4587 mStack, int x, int y, float par3) {
        try {
            this.method_25420(mStack);
            this.renderBottomBar(mStack);
            this.layoutButtons(mStack);
            this.drawTitle(mStack);
            this.drawLogo(mStack);
            List<class_5481> tooltip = null;
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                Button button;
                class_4185 guibutton = (class_4185)this.getRenderables().get(k);
                guibutton.method_25394(mStack, x, y, 0.0f);
                if (tooltip != null || !(guibutton instanceof Button) || !(button = (Button)guibutton).mouseOver(x, y)) continue;
                tooltip = button.getTooltip();
            }
            if (tooltip != null && !tooltip.isEmpty()) {
                this.renderWrappedToolTip(mStack, tooltip, x, y, this.getFontRenderer());
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error in UI: " + LogFormatter.toString(t));
            this.closeAndReturn();
        }
    }

    public void drawGradientRect(class_4587 mStack, int p_73733_1_, int p_73733_2_, int p_73733_3_, int p_73733_4_, int p_73733_5_, int p_73733_6_) {
        super.method_25296(mStack, p_73733_1_, p_73733_2_, p_73733_3_, p_73733_4_, p_73733_5_, p_73733_6_);
    }

    protected void closeAndReturn() {
        if (returnDisplayStack == null || returnDisplayStack.peek() == null) {
            if (this.field_22787.field_1687 != null) {
                UIManager.INSTANCE.openFullscreenMap();
            } else {
                UIManager.INSTANCE.closeAll();
            }
        } else {
            UIManager.INSTANCE.open(returnDisplayStack.pop());
        }
    }

    public boolean method_25400(char c, int i) {
        return super.method_25400(c, i);
    }

    public void setRenderBottomBar(boolean renderBottomBar) {
        this.renderBottomBar = renderBottomBar;
    }

    public boolean method_25404(int key, int value, int modifier) {
        switch (key) {
            case 256: {
                this.closeAndReturn();
                return true;
            }
        }
        return super.method_25404(key, value, modifier);
    }

    public void renderTooltip(class_4587 mStack, String[] tooltip, int mouseX, int mouseY) {
        List tooltips = Arrays.stream(tooltip).map(e -> class_5481.method_30747((String)e, (class_2583)class_2583.field_24360)).collect(Collectors.toList());
        this.renderWrappedToolTip(mStack, tooltips, mouseX, mouseY, this.getFontRenderer());
    }

    public class_437 getReturnDisplay() {
        return returnDisplayStack.peek();
    }

    public void renderWrappedToolTip(class_4587 mStack, List tooltip, int mouseX, int mouseY, class_327 fontRenderer) {
        if (!tooltip.isEmpty() && tooltip.get(0) instanceof class_5481 && class_310.method_1551().field_1755 == this) {
            RenderWrapper.disableDepthTest();
            int maxLineWidth = 0;
            for (class_5481 line : tooltip) {
                int lineWidth = fontRenderer.method_30880(line);
                if (fontRenderer.method_1726()) {
                    lineWidth = (int)Math.ceil((double)lineWidth * 1.25);
                }
                if (lineWidth <= maxLineWidth) continue;
                maxLineWidth = lineWidth;
            }
            int drawX = mouseX + 12;
            int drawY = mouseY - 12;
            int boxHeight = 8;
            if (tooltip.size() > 1) {
                boxHeight += 2 + (tooltip.size() - 1) * 10;
            }
            if (drawX + maxLineWidth > this.field_22789) {
                drawX -= 28 + maxLineWidth;
            }
            if (drawY + boxHeight + 6 > this.field_22790) {
                drawY = this.field_22790 - boxHeight - 6;
            }
            this.method_25304(300);
            this.field_22788.field_4730 = 300.0f;
            int j1 = -267386864;
            this.drawGradientRect(mStack, drawX - 3, drawY - 4, drawX + maxLineWidth + 3, drawY - 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 3, drawX + maxLineWidth + 3, drawY + boxHeight + 4, j1, j1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX - 4, drawY - 3, drawX - 3, drawY + boxHeight + 3, j1, j1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 3, drawY - 3, drawX + maxLineWidth + 4, drawY + boxHeight + 3, j1, j1);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            this.drawGradientRect(mStack, drawX - 3, drawY - 3 + 1, drawX - 3 + 1, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX + maxLineWidth + 2, drawY - 3 + 1, drawX + maxLineWidth + 3, drawY + boxHeight + 3 - 1, k1, l1);
            this.drawGradientRect(mStack, drawX - 3, drawY - 3, drawX + maxLineWidth + 3, drawY - 3 + 1, k1, k1);
            this.drawGradientRect(mStack, drawX - 3, drawY + boxHeight + 2, drawX + maxLineWidth + 3, drawY + boxHeight + 3, l1, l1);
            for (int i2 = 0; i2 < tooltip.size(); ++i2) {
                class_5481 line = (class_5481)tooltip.get(i2);
                if (fontRenderer.method_1726()) {
                    int lineWidth = (int)Math.ceil((double)fontRenderer.method_30880(line) * 1.1);
                    fontRenderer.method_27517(mStack, line, (float)(drawX + maxLineWidth - lineWidth), (float)drawY, -1);
                } else {
                    fontRenderer.method_27517(mStack, line, (float)drawX, (float)drawY, -1);
                }
                if (i2 == 0) {
                    drawY += 2;
                }
                drawY += 10;
            }
            this.method_25304(0);
            this.field_22788.field_4730 = 0.0f;
            RenderWrapper.enableDepthTest();
        }
    }

    @Override
    public List<class_4068> getRenderables() {
        return this.field_33816;
    }
}

