/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.util.Objects;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.properties.ClientCategory;
import journeymap.client.task.main.IMainThreadTask;
import journeymap.client.task.multi.MapRegionTask;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4587;

public class AutoMapConfirmation
extends JmUI {
    Button buttonOptions;
    Button buttonAll;
    Button buttonMissing;
    Button buttonClose;

    public AutoMapConfirmation() {
        this((JmUI)null);
    }

    public AutoMapConfirmation(JmUI returnDisplay) {
        super(Constants.getString("jm.common.automap_dialog"), returnDisplay);
    }

    @Override
    public void method_25426() {
        this.getRenderables().clear();
        super.setRenderBottomBar(true);
        this.buttonOptions = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Cartography)));
        this.buttonAll = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.automap_dialog_all"), button -> this.initAutoMapping(true, Boolean.TRUE)));
        this.buttonMissing = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.automap_dialog_missing"), button -> this.initAutoMapping(true, Boolean.FALSE)));
        this.buttonClose = (Button)this.method_37063((class_364)new Button(Constants.getString("jm.common.close"), button -> this.closeAndReturn()));
        this.buttonOptions.setDefaultStyle(false);
        this.buttonAll.setDefaultStyle(false);
        this.buttonMissing.setDefaultStyle(false);
        this.buttonClose.setDefaultStyle(false);
        this.getRenderables().add((class_4068)this.buttonOptions);
        this.getRenderables().add((class_4068)this.buttonAll);
        this.getRenderables().add((class_4068)this.buttonMissing);
        this.getRenderables().add((class_4068)this.buttonClose);
    }

    @Override
    protected void layoutButtons(class_4587 mStack) {
        if (this.getRenderables().isEmpty()) {
            this.method_25426();
        }
        int x = this.field_22789 / 2;
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 9 + 3;
        int y = 35 + lineHeight * 2;
        AutoMapConfirmation.method_25300((class_4587)mStack, (class_327)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_summary_1"), (int)x, (int)y, (int)0xFFFFFF);
        AutoMapConfirmation.method_25300((class_4587)mStack, (class_327)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_summary_2"), (int)x, (int)(y += lineHeight), (int)0xFFFFFF);
        this.buttonOptions.centerHorizontalOn(x).centerVerticalOn(y += lineHeight * 2);
        AutoMapConfirmation.method_25300((class_4587)mStack, (class_327)this.getFontRenderer(), (String)Constants.getString("jm.common.automap_dialog_text"), (int)x, (int)(y += lineHeight * 3), (int)0xFFFF00);
        ButtonList buttons = new ButtonList(this.buttonAll, this.buttonMissing);
        buttons.equalizeWidths(this.field_22793, 4, 200);
        buttons.layoutCenteredHorizontal(x, y += lineHeight * 2, true, 4);
        this.buttonClose.centerHorizontalOn(x).below(this.buttonMissing, lineHeight);
    }

    protected void initAutoMapping(final boolean enable, final Object arg) {
        MapRegionTask.MAP_TYPE = Fullscreen.state().getMapType();
        JourneymapClient.getInstance().queueMainThreadTask(new IMainThreadTask(){

            @Override
            public IMainThreadTask perform(class_310 mc, JourneymapClient jm) {
                JourneymapClient.getInstance().toggleTask(MapRegionTask.Manager.class, enable, arg);
                return null;
            }

            @Override
            public String getName() {
                return "Automap";
            }
        });
        this.closeAndReturn();
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        return true;
    }
}

