/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.fullscreen.menu;

import java.util.ArrayList;
import java.util.List;
import journeymap.client.api.display.ModPopupMenu;
import journeymap.client.api.impl.ModPopupMenuImpl;
import journeymap.client.event.dispatchers.CustomEventDispatcher;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.ui.GuiHooks;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.DropDownItem;
import journeymap.client.ui.component.Removable;
import journeymap.client.ui.component.ScrollPaneScreen;
import journeymap.client.ui.component.SelectableParent;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.waypoint.Waypoint;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_437;
import net.minecraft.class_4587;

public class PopupMenu
extends ScrollPaneScreen
implements Removable,
SelectableParent {
    private static final int MAX_DISPLAY_SIZE = 6;
    private int mouseX;
    private int mouseY;
    private final class_437 parent;
    private DropDownItem selected;
    private boolean pass = false;
    private boolean isSub = false;
    private boolean mouseOver = false;

    public PopupMenu(Fullscreen parent) {
        this((class_437)parent);
    }

    public PopupMenu(PopupMenu parent) {
        this((class_437)parent);
        this.isSub = true;
    }

    private PopupMenu(class_437 parent) {
        super(null, null, 0, 0, 0, 0);
        this.parent = parent;
        this.setParent(this);
    }

    public void displayBasicOptions(class_2338 blockPos) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupMenuEvent((Fullscreen)this.parent, menu)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayWaypointOptions(class_2338 blockPos, Waypoint wp) {
        ModPopupMenuImpl menu = new ModPopupMenuImpl(((Fullscreen)this.parent).popupMenu);
        if (CustomEventDispatcher.getInstance().popupWaypointMenuEvent((Fullscreen)this.parent, menu, wp)) {
            this.displayOptions(blockPos, menu);
        }
    }

    public void displayOptions(class_2338 blockPos, ModPopupMenu popupMenu) {
        ModPopupMenuImpl menu = (ModPopupMenuImpl)popupMenu;
        if (menu.getMenuItemList() != null && !menu.getMenuItemList().isEmpty()) {
            ArrayList<DropDownItem> items = new ArrayList<DropDownItem>();
            menu.getMenuItemList().forEach(menuItem -> items.add(this.dropDownItemBuilder((ModPopupMenuImpl.MenuItem)menuItem, menu, blockPos)));
            this.display(items);
        }
    }

    private DropDownItem dropDownItemBuilder(ModPopupMenuImpl.MenuItem menuItem, ModPopupMenuImpl menu, class_2338 blockPos) {
        DropDownItem dropDownItem;
        if (menuItem.isAutoCloseable()) {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> {
                if (menu.isSub()) {
                    this.closeStack();
                }
                menuItem.getAction().doAction(blockPos);
            });
        } else {
            dropDownItem = new DropDownItem((SelectableParent)this, (Object)menuItem, menuItem.isAutoCloseable(), menuItem.getLabel(), b -> menuItem.getSubMenuAction().doAction(blockPos, (Button)b));
            dropDownItem.setOnHover((button, isHovered) -> menuItem.getSubMenuAction().onHoverState(blockPos, button, isHovered));
        }
        return dropDownItem;
    }

    private void display(List<DropDownItem> items) {
        if (!this.pass) {
            for (DropDownItem item : items) {
                item.setHorizontalAlignment(DrawUtil.HAlign.Right);
            }
            this.pass = true;
            this.setRenderDecorations(false);
            this.setRenderSolidBackground(true);
            this.setItems(items);
            this.setPaneWidth(this.getPaneWidth(items));
            this.setPaneHeight(this.getPaneHeight(items));
            this.setPointsInScreenBounds();
            super.display();
        }
    }

    private void setPointsInScreenBounds() {
        int x;
        boolean inBoundsY;
        int screenWidth = class_310.method_1551().method_22683().method_4486();
        int screenHeight = class_310.method_1551().method_22683().method_4502();
        boolean inBoundsX = this.mouseX + this.getPaneWidth() < screenWidth;
        boolean bl = inBoundsY = this.mouseY + this.getPaneHeight() < screenHeight;
        if (this.parent instanceof PopupMenu) {
            int width = this.scrollPane != null ? this.getPaneWidth() : this.getPaneWidth() - 6;
            x = inBoundsX ? this.mouseX : ((PopupMenu)this.parent).getPaneX() - width;
        } else {
            x = inBoundsX ? this.mouseX : screenWidth - this.getPaneWidth() - 4;
        }
        int y = inBoundsY ? this.mouseY : screenHeight - this.getPaneHeight() - 2;
        this.mouseX = x;
        this.mouseY = y;
        this.setPaneX(x);
        this.setPaneY(y);
    }

    public void resetPass() {
        this.pass = false;
    }

    @Override
    public void method_25394(class_4587 mStack, int mouseX, int mouseY, float partialTicks) {
        this.mouseOver = this.mouseOverPane(mouseX, mouseY);
        int x = (int)(class_310.method_1551().field_1729.method_1603() * (double)class_310.method_1551().method_22683().method_4486() / (double)class_310.method_1551().method_22683().method_4480());
        int y = (int)(class_310.method_1551().field_1729.method_1604() * (double)class_310.method_1551().method_22683().method_4502() / (double)class_310.method_1551().method_22683().method_4507());
        super.method_25394(mStack, x, y, partialTicks);
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean clicked = super.method_25402(mouseX, mouseY, button);
        if (!clicked && !this.mouseOverPane(mouseX, mouseY)) {
            this.resetPass();
            return this.parent.method_25402(mouseX, mouseY, button);
        }
        return clicked;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    @Override
    public void method_16014(double mouseX, double mouseY) {
        if (!this.mouseOverPane(mouseX, mouseY)) {
            this.parent.method_16014(mouseX, mouseY);
        }
        super.method_16014(mouseX, mouseY);
    }

    private int getPaneHeight(List<DropDownItem> items) {
        int size = Math.min(items.size(), 6);
        return size * (items.get(0).method_25364() + (size == 1 ? 7 : 5));
    }

    private int getPaneWidth(List<DropDownItem> items) {
        int width = 0;
        if (items != null) {
            class_327 fontRenderer = class_310.method_1551().field_1772;
            for (DropDownItem item : items) {
                width = Math.max(width, fontRenderer.method_1727(item.getLabel()));
            }
            this.field_22789 = width + 40;
        }
        return this.field_22789;
    }

    public void setClickLoc(int mouseX, int mouseY) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
    }

    @Override
    public void setSelected(DropDownItem button) {
        this.selected = button;
    }

    public void closeStack() {
        if (this.isSub) {
            ((PopupMenu)this.parent).closeStack();
            this.method_25419();
        }
    }

    @Override
    public void onClick(DropDownItem pressed) {
        if (pressed.isAutoClose()) {
            this.method_25419();
        }
        ((ScrollPaneScreen)this).parent.onRemove();
    }

    @Override
    public void method_25419() {
        this.visible = false;
        GuiHooks.popGuiLayer();
    }

    @Override
    public void onRemove() {
        if (this.selected != null) {
            this.selected.press();
            this.selected = null;
        }
    }
}

