/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.waypoint;

import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.regex.Pattern;
import journeymap.client.Constants;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.helper.DimensionHelper;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import org.apache.commons.lang3.StringUtils;

public class WaypointParser {
    public static String[] QUOTES = new String[]{"'", "\""};
    public static Pattern PATTERN = Pattern.compile("(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+,\\s*)+(\\w+\\s*:\\s*-?[\\w\\d\\s'\"]+)", 2);
    private static Pattern TEXT_BETWEEN_QUOTES = Pattern.compile("\".*?\"|'.*?'|`.*`");

    public static List<String> getWaypointStrings(String line) {
        ArrayList<CallSite> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                if (!PATTERN.matcher(candidate).find() || WaypointParser.parse(candidate) == null) continue;
                if (list == null) {
                    list = new ArrayList<CallSite>(1);
                }
                list.add((CallSite)((Object)("[" + candidate + "]")));
            }
        }
        return list;
    }

    public static List<Waypoint> getWaypoints(String line) {
        ArrayList<Waypoint> list = null;
        String[] candidates = StringUtils.substringsBetween((String)line, (String)"[", (String)"]");
        if (candidates != null) {
            for (String candidate : candidates) {
                Waypoint waypoint;
                if (!PATTERN.matcher(candidate).find() || (waypoint = WaypointParser.parse(candidate)) == null) continue;
                if (list == null) {
                    list = new ArrayList<Waypoint>(1);
                }
                list.add(waypoint);
            }
        }
        return list;
    }

    public static Waypoint parse(String original) {
        String[] quotedVals = null;
        String raw = original.replaceAll("[\\[\\]]", "");
        for (String quoteChar : QUOTES) {
            if (!raw.contains(quoteChar) || (quotedVals = StringUtils.substringsBetween((String)raw, (String)quoteChar, (String)quoteChar)) == null) continue;
            for (int i = 0; i < quotedVals.length; ++i) {
                raw = raw.replaceAll(TEXT_BETWEEN_QUOTES.pattern(), "__TEMP_" + i);
            }
        }
        Integer x = null;
        Integer y = 63;
        Integer z = null;
        String dim = null;
        String name = null;
        boolean showDeviation = false;
        for (String part : raw.split(",")) {
            String[] prop;
            if (!part.contains(":") || (prop = part.split(":")).length != 2) continue;
            String key = prop[0].trim().toLowerCase();
            String val = prop[1].trim();
            try {
                if ("x".equals(key)) {
                    x = Integer.parseInt(val);
                } else if ("y".equals(key)) {
                    y = Integer.parseInt(val);
                } else if ("z".equals(key)) {
                    z = Integer.parseInt(val);
                } else if ("dim".equals(key)) {
                    dim = val;
                } else if ("name".equals(key)) {
                    name = val;
                }
                if (!"showDeviation".equals(key)) continue;
                showDeviation = Boolean.parseBoolean(val);
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Bad format in waypoint text part: " + part + ": " + e);
            }
        }
        if (x != null && z != null) {
            if (name != null && quotedVals != null) {
                for (int i = 0; i < quotedVals.length; ++i) {
                    String val = quotedVals[i];
                    name = name.replaceAll("__TEMP_" + i, val);
                }
            }
            if (name == null) {
                name = String.format("%s,%s", x, z);
            }
            Random r = new Random();
            if (dim == null) {
                dim = class_310.method_1551().field_1687 == null ? "minecraft:overwrold" : DimensionHelper.getDimKeyName((class_5321<class_1937>)class_310.method_1551().field_1687.method_27983());
            }
            Waypoint waypoint = new Waypoint(name, new class_2338(x.intValue(), y.intValue(), z.intValue()), new Color(r.nextInt(255), r.nextInt(255), r.nextInt(255)), Waypoint.Type.Normal, dim, showDeviation);
            return waypoint;
        }
        return null;
    }

    public static class_2561 parseChatForWaypoints(class_2561 component, String unformattedText) {
        List<String> matches = WaypointParser.getWaypointStrings(unformattedText);
        class_2561 response = component;
        if (matches != null) {
            boolean changed = false;
            if (component instanceof class_2588) {
                Object[] formatArgs = ((class_2588)component).method_11023();
                for (int i = 0; i < formatArgs.length && !matches.isEmpty(); ++i) {
                    class_2561 result;
                    Object arg;
                    if (formatArgs[i] instanceof class_2561) {
                        arg = (class_2561)formatArgs[i];
                        result = WaypointParser.addWaypointMarkup(arg.method_10851(), matches);
                        if (result == null) continue;
                        formatArgs[i] = result;
                        changed = true;
                        continue;
                    }
                    if (!(formatArgs[i] instanceof String) || (result = WaypointParser.addWaypointMarkup((String)(arg = (String)formatArgs[i]), matches)) == null) continue;
                    formatArgs[i] = result;
                    changed = true;
                }
                if (changed) {
                    response = new class_2588(((class_2588)component).method_11022(), formatArgs);
                }
            } else if (component instanceof class_2585) {
                response = WaypointParser.addWaypointMarkup(component.getString(), matches);
                if (response != null) {
                    changed = true;
                }
            } else {
                Journeymap.getLogger().warn("No implementation for handling waypoints in ITextComponent " + component.getClass());
            }
            if (!changed) {
                Journeymap.getLogger().warn(String.format("Matched waypoint in chat but failed to update message for %s : %s\n%s", component.getClass(), component.getString(), class_2561.class_2562.method_10867((class_2561)component)));
            }
        }
        return response;
    }

    private static class_2561 addWaypointMarkup(String text, List<String> matches) {
        ArrayList<class_2585> newParts = new ArrayList<class_2585>();
        int index = 0;
        boolean matched = false;
        Iterator<String> iterator2 = matches.iterator();
        while (iterator2.hasNext()) {
            String match = iterator2.next();
            if (!text.contains(match)) continue;
            int start = text.indexOf(match);
            if (start > index) {
                newParts.add(Constants.getStringTextComponent(text.substring(index, start)));
            }
            matched = true;
            class_2585 class_25852 = Constants.getStringTextComponent(match);
            class_25852.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/jm wpedit " + match)));
            class_2585 hover = Constants.getStringTextComponent("JourneyMap: ");
            hover.method_27694(style -> style.method_27703(class_5251.method_27718((class_124)class_124.field_1054)));
            class_2585 hover2 = Constants.getStringTextComponent("Click to create Waypoint.\nCtrl+Click to view on map.");
            hover2.method_27694(style -> style.method_27703(class_5251.method_27718((class_124)class_124.field_1075)));
            hover.method_10852((class_2561)hover2);
            class_25852.method_27694(style -> style.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)hover)));
            class_25852.method_27694(style -> style.method_27703(class_5251.method_27718((class_124)class_124.field_1075)));
            newParts.add(class_25852);
            index = start + match.length();
            iterator2.remove();
        }
        if (!matched) {
            return null;
        }
        if (index < text.length() - 1) {
            newParts.add(Constants.getStringTextComponent(text.substring(index, text.length())));
        }
        if (!newParts.isEmpty()) {
            class_2585 replacement = Constants.getStringTextComponent("");
            for (class_2561 class_25612 : newParts) {
                replacement.method_10852(class_25612);
            }
            return replacement;
        }
        return null;
    }
}

