/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common;

import com.google.common.base.Joiner;
import java.net.URL;
import java.util.ArrayList;
import journeymap.common.Journeymap;
import journeymap.common.network.data.model.Location;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.dimension.v1.FabricDimensions;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class LoaderHooks {
    public static boolean isDedicatedServer() {
        return LoaderHooks.getServer().method_3816();
    }

    public static MinecraftServer getServer() {
        return Journeymap.getInstance().getServer();
    }

    public static ArrayList<String> getMods() {
        ArrayList<String> list = new ArrayList<String>();
        for (ModContainer mod : FabricLoader.getInstance().getAllMods()) {
            ModMetadata meta = mod.getMetadata();
            if (!LoaderHooks.isModLoaded(meta.getId())) continue;
            list.add(String.format("%s:%s", meta.getName(), meta.getVersion()));
        }
        return list;
    }

    public static String getModNames() {
        return Joiner.on((String)", ").join(LoaderHooks.getMods());
    }

    public static String getMCVersion() {
        return "1.18.2";
    }

    public static String getLoaderVersion() {
        return "0.13.3";
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId) || FabricLoader.getInstance().isModLoaded(modId.toLowerCase());
    }

    public static URL getModFileLocation(String domain) throws Exception {
        URL fileLocation = null;
        ModContainer mod = FabricLoader.getInstance().getModContainer(domain).orElse(null);
        if (mod == null) {
            for (ModContainer modEntry : FabricLoader.getInstance().getAllMods()) {
                ModMetadata meta = modEntry.getMetadata();
                if (!meta.getId().toLowerCase().equals(domain)) continue;
                mod = FabricLoader.getInstance().getModContainer(domain).orElse(null);
                break;
            }
        }
        if (mod != null) {
            fileLocation = mod.getRoot().toUri().toURL();
        }
        return fileLocation;
    }

    public static boolean isClient() {
        return EnvType.CLIENT.equals((Object)FabricLoader.getInstance().getEnvironmentType());
    }

    public static void doTeleport(class_3222 player, class_3218 destinationWorld, Location location) {
        class_243 position = new class_243(location.getX() + 0.5, location.getY() + 0.5, location.getZ() + 0.5);
        FabricDimensions.teleport((class_1297)player, (class_3218)destinationWorld, (class_5454)new class_5454(position, new class_243(0.0, 0.0, 0.0), player.method_36454(), player.method_36455()));
    }
}

