/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt;

import journeymap.client.JourneymapClient;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.client.model.MapType;
import journeymap.client.model.RegionCoord;
import journeymap.common.helper.BiomeHelper;
import journeymap.common.nbt.RegionDataStorageHandler;
import journeymap.common.nbt.cache.CacheStorage;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;

public class RegionData {
    public static final String BIOME_TAG_NAME = "biome_name";
    public static final String BLOCK_TAG_NAME = "block";
    public static final String BLOCKSTATES_TAG_NAME = "blockstates";
    public static final String BLOCK_LIGHT_VALUE = "light_value";
    public static final String TOP_Y_TAG_NAME = "top_y";
    public static final String SURFACE_Y_TAG_NAME = "surface_y";
    public static final String BLOCK_COLOR_TAG_NAME = "block_color_";
    public static final String CHUNK_POS_NAME = "pos";
    protected final RegionCoord regionCoord;
    protected final MapType mapType;
    protected static boolean enabled;
    protected boolean loaded = false;
    protected final RegionDataStorageHandler.Key key;
    private final CacheStorage storage;

    public RegionData(RegionDataStorageHandler.Key key, CacheStorage storage) {
        this.regionCoord = key.rCoord;
        this.mapType = key.mapType;
        this.key = key;
        this.storage = storage;
        enabled = JourneymapClient.getInstance().getCoreProperties().dataCachingEnabled.get();
    }

    public class_1959 getBiome(class_2338 blockPos) {
        class_2487 blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).method_10545(BIOME_TAG_NAME)) {
            String biomeName = blockData.method_10558(BIOME_TAG_NAME);
            return BiomeHelper.getBiomeFromResourceString(biomeName);
        }
        return null;
    }

    public Integer getTopY(class_2338 blockPos) {
        class_2487 blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).method_10545(TOP_Y_TAG_NAME)) {
            return blockData.method_10550(TOP_Y_TAG_NAME);
        }
        return blockPos.method_10264();
    }

    public Integer getColor(class_2338 blockPos) {
        class_2487 blockData;
        if (enabled && (blockData = this.getBlockDataFromBlockPos(blockPos)).method_10545(BLOCK_COLOR_TAG_NAME)) {
            return blockData.method_10550(BLOCK_COLOR_TAG_NAME);
        }
        return null;
    }

    public class_2680 getBlockState(class_2338 blockPos) {
        if (enabled) {
            class_2487 blockData = this.getBlockDataFromBlockPos(blockPos);
            return RegionData.getBlockState(blockData, blockPos, this.mapType);
        }
        return null;
    }

    public static class_2680 getBlockState(class_2487 blockData, class_2338 blockPos, MapType mapType) {
        if (enabled) {
            if (blockData.method_10545(BLOCKSTATES_TAG_NAME) && !mapType.isUnderground()) {
                String key;
                class_2487 states = RegionData.getBlockStates(blockData, mapType);
                if (states.method_10545(key = String.valueOf(blockPos.method_10264()))) {
                    class_2487 blockState = states.method_10562(key);
                    return class_2512.method_10681((class_2487)blockState);
                }
                if (states.method_10541().size() > 0 && states.method_10541().stream().findFirst().isPresent()) {
                    class_2487 blockState = states.method_10562((String)states.method_10541().stream().findFirst().get());
                    return class_2512.method_10681((class_2487)blockState);
                }
            } else if (blockData.method_10545(BLOCK_TAG_NAME)) {
                class_2487 blockState = blockData.method_10562(BLOCK_TAG_NAME);
                class_2680 state = class_2512.method_10681((class_2487)blockState);
                if (!mapType.isUnderground()) {
                    RegionData.setBlockState(blockData, state, blockPos, mapType);
                }
                return state;
            }
        }
        return null;
    }

    public void setBiome(class_2487 blockData, class_1959 biome) {
        if (enabled) {
            String biomeName;
            String biomeString = BiomeHelper.getBiomeResource(biome).toString();
            if (blockData.method_10545(BIOME_TAG_NAME) && (biomeName = blockData.method_10558(BIOME_TAG_NAME)).equals(biomeString)) {
                return;
            }
            blockData.method_10582(BIOME_TAG_NAME, biomeString);
        }
    }

    public void setBlockState(class_2487 blockData, ChunkMD chunkMD, class_2338 pos) {
        BlockMD blockMD = chunkMD.getBlockMD(pos);
        if (!(!blockMD.hasNoShadow() || blockMD.isIgnore() || blockMD.isWater() || blockMD.isFluid() || blockMD.getBlockState().method_28501().contains(class_2320.field_10929) || this.mapType.isUnderground())) {
            RegionData.setBlockState(blockData, chunkMD.getBlockMD(pos.method_10074()).getBlockState(), pos.method_10074(), this.mapType);
        }
        RegionData.setBlockState(blockData, blockMD.getBlockState(), pos, this.mapType);
    }

    private static void setBlockState(class_2487 blockData, class_2680 state, class_2338 pos, MapType mapType) {
        if (enabled && blockData != null) {
            if (mapType.isUnderground()) {
                class_2487 blockState = class_2512.method_10686((class_2680)state);
                blockData.method_10566(BLOCK_TAG_NAME, (class_2520)blockState);
            } else {
                class_2487 states = RegionData.getBlockStates(blockData, mapType);
                class_2487 blockState = class_2512.method_10686((class_2680)state);
                states.method_10566(String.valueOf(pos.method_10264()), (class_2520)blockState);
                blockData.method_10566(BLOCKSTATES_TAG_NAME, (class_2520)states);
            }
        }
    }

    public void setY(class_2487 blockData, int topY) {
        if (enabled) {
            int savedTopY;
            if (blockData.method_10545(TOP_Y_TAG_NAME) && (savedTopY = blockData.method_10550(TOP_Y_TAG_NAME)) == topY) {
                return;
            }
            blockData.method_10569(TOP_Y_TAG_NAME, topY);
        }
    }

    public void setLightValue(class_2487 blockData, int light) {
        if (enabled) {
            int savedLight;
            if (blockData.method_10545(BLOCK_LIGHT_VALUE) && (savedLight = blockData.method_10550(BLOCK_LIGHT_VALUE)) == light) {
                return;
            }
            blockData.method_10569(BLOCK_LIGHT_VALUE, light);
        }
    }

    public void setSurfaceY(class_2487 blockData, int surfaceY) {
        if (enabled) {
            int savedTopY;
            if (blockData.method_10545(SURFACE_Y_TAG_NAME) && (savedTopY = blockData.method_10550(SURFACE_Y_TAG_NAME)) == surfaceY) {
                return;
            }
            blockData.method_10569(SURFACE_Y_TAG_NAME, surfaceY);
        }
    }

    public void setBlockColor(class_2487 blockData, int color, MapType.Name mapTypeName) {
    }

    private static class_2487 getBlockStates(class_2487 blockData, MapType mapType) {
        if (enabled) {
            if (mapType.isUnderground()) {
                if (blockData.method_10545(BLOCK_TAG_NAME)) {
                    return blockData.method_10562(BLOCK_TAG_NAME);
                }
            } else if (blockData.method_10545(BLOCKSTATES_TAG_NAME)) {
                return blockData.method_10562(BLOCKSTATES_TAG_NAME);
            }
            return new class_2487();
        }
        return null;
    }

    public class_2487 getBlockDataFromBlockPos(class_1923 chunkPos, class_2487 chunk, int x, int z) {
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.field_9181 << 4) + x, (chunkPos.field_9180 << 4) + z);
        }
        return null;
    }

    public class_2487 getBlockDataFromBlockPos(class_1923 chunkPos, int x, int z) {
        class_2487 chunk = this.getChunkNbt(chunkPos);
        if (enabled && chunk != null) {
            return RegionData.getBlockDataForChunk(chunk, (chunkPos.field_9181 << 4) + x, (chunkPos.field_9180 << 4) + z);
        }
        return null;
    }

    private class_2487 getBlockDataFromBlockPos(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        class_2487 chunk = this.getChunkNbt(chunkPos);
        return RegionData.getBlockDataForChunk(chunk, pos.method_10263(), pos.method_10260());
    }

    public class_2487 getChunkNbt(class_1923 chunkPos) {
        if (enabled) {
            class_2487 chunkTag = this.storage.read(chunkPos);
            if (chunkTag == null) {
                chunkTag = new class_2487();
            }
            if (!chunkTag.method_10545(CHUNK_POS_NAME)) {
                chunkTag.method_10544(CHUNK_POS_NAME, chunkPos.method_8324());
            }
            return chunkTag;
        }
        return null;
    }

    public static class_2487 getBlockDataForChunk(class_2487 chunk, int x, int z) {
        if (chunk != null) {
            class_2487 blockTag;
            String blockTagName = x + "," + z;
            if (chunk.method_10545(blockTagName)) {
                blockTag = chunk.method_10562(blockTagName);
            } else {
                blockTag = new class_2487();
                chunk.method_10566(blockTagName, (class_2520)blockTag);
            }
            return blockTag;
        }
        return null;
    }

    public void writeChunk(class_1923 chunkPos, class_2487 tag) {
        this.storage.write(chunkPos, tag);
    }
}

