/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.nbt.cache;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Either;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import journeymap.common.nbt.cache.CacheFileStorage;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_3846;
import net.minecraft.class_3847;
import net.minecraft.class_3902;
import net.minecraft.class_3906;

public class CacheWorker
implements AutoCloseable {
    private final AtomicBoolean shutdownRequested = new AtomicBoolean();
    private final class_3846<class_3847.class_3907> mailbox;
    private final CacheFileStorage storage;
    private final Map<class_1923, PendingStore> pendingWrites = Maps.newLinkedHashMap();

    protected CacheWorker(Path path, boolean async) {
        this.storage = new CacheFileStorage(path, async);
        this.mailbox = new class_3846((class_3847)new class_3847.class_3848(Priority.values().length), (Executor)class_156.method_27958(), "JM-Cache");
    }

    public CompletableFuture<Void> store(class_1923 chunkPos, @Nullable class_2487 tag) {
        return this.submitTask(() -> {
            PendingStore pendingStore = this.pendingWrites.computeIfAbsent(chunkPos, func -> new PendingStore(tag));
            pendingStore.data = tag;
            return Either.left(pendingStore.result);
        }).thenCompose(Function.identity());
    }

    @Nullable
    public class_2487 load(class_1923 chunkPos) throws IOException {
        CompletableFuture<class_2487> future = this.loadAsync(chunkPos);
        try {
            return future.join();
        }
        catch (CompletionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    protected CompletableFuture<class_2487> loadAsync(class_1923 chunkPos) {
        return this.submitTask(() -> {
            PendingStore store = this.pendingWrites.get(chunkPos);
            if (store != null) {
                return Either.left((Object)store.data);
            }
            try {
                class_2487 compoundtag = this.storage.read(chunkPos);
                return Either.left((Object)compoundtag);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        });
    }

    public CompletableFuture<Void> synchronize(boolean sync) {
        CompletionStage future = this.submitTask(() -> Either.left(CompletableFuture.allOf((CompletableFuture[])this.pendingWrites.values().stream().map(pendingStore -> pendingStore.result).toArray(CompletableFuture[]::new)))).thenCompose(Function.identity());
        return sync ? ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> {
            try {
                this.storage.flush();
                return Either.left(null);
            }
            catch (Exception e) {
                return Either.right((Object)e);
            }
        })) : ((CompletableFuture)future).thenCompose(func -> this.submitTask(() -> Either.left(null)));
    }

    private <T> CompletableFuture<T> submitTask(Supplier<Either<T, Exception>> supplier) {
        return this.mailbox.method_27918(processorHandle -> new class_3847.class_3907(Priority.FOREGROUND.ordinal(), () -> this.lambda$submitTask$10(processorHandle, (Supplier)supplier)));
    }

    private void storePendingChunk() {
        if (!this.pendingWrites.isEmpty()) {
            Iterator<Map.Entry<class_1923, PendingStore>> iterator2 = this.pendingWrites.entrySet().iterator();
            Map.Entry<class_1923, PendingStore> entry = iterator2.next();
            iterator2.remove();
            this.runStore(entry.getKey(), entry.getValue());
            this.tellStorePending();
        }
    }

    private void tellStorePending() {
        this.mailbox.method_16901((Object)new class_3847.class_3907(Priority.BACKGROUND.ordinal(), this::storePendingChunk));
    }

    private void runStore(class_1923 pos, PendingStore store) {
        try {
            this.storage.write(pos, store.data);
            store.result.complete(null);
        }
        catch (Exception e) {
            store.result.completeExceptionally(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.shutdownRequested.compareAndSet(false, true)) {
            this.mailbox.method_17345(processorHandle -> new class_3847.class_3907(Priority.SHUTDOWN.ordinal(), () -> processorHandle.method_16901((Object)class_3902.field_17274))).join();
            this.mailbox.close();
            try {
                this.storage.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private /* synthetic */ void lambda$submitTask$10(class_3906 processorHandle, Supplier supplier) {
        if (!this.shutdownRequested.get()) {
            processorHandle.method_16901((Object)((Either)supplier.get()));
        }
        this.tellStorePending();
    }

    static enum Priority {
        FOREGROUND,
        BACKGROUND,
        SHUTDOWN;

    }

    static class PendingStore {
        @Nullable
        class_2487 data;
        final CompletableFuture<Void> result = new CompletableFuture();

        public PendingStore(@Nullable class_2487 data) {
            this.data = data;
        }
    }
}

