/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.extraorigins.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.apoli.component.PowerHolderComponent;
import java.util.List;
import moriyashiine.extraorigins.common.packet.ChangeRadialDirectionPacket;
import moriyashiine.extraorigins.common.power.RadialMenuPower;
import moriyashiine.extraorigins.common.util.RadialMenuDirection;
import moriyashiine.extraorigins.mixin.client.ApoliClientAccessor;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;

@Environment(value=EnvType.CLIENT)
public class RadialMenuEvents {
    public static boolean directionChanged = false;
    private static List<RadialMenuPower> activePowers;
    private static RadialMenuPower lastUsedPower;
    private static RadialMenuDirection targetDirection;
    private static boolean renderModeSwitch;
    private static int timer;

    public static void init() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            activePowers.clear();
            lastUsedPower = null;
            directionChanged = false;
            targetDirection = null;
            renderModeSwitch = false;
            timer = 0;
        });
        ClientTickEvents.END_CLIENT_TICK.register((Object)new ClientTickEvents.EndTick(){

            public void onEndTick(class_310 client) {
                if (client.field_1755 != null) {
                    return;
                }
                activePowers = PowerHolderComponent.getPowers((class_1297)client.field_1724, RadialMenuPower.class).stream().filter(power -> ApoliClientAccessor.extraorigins$idToKeyBindingMap().containsKey(power.getKey().key) && ApoliClientAccessor.extraorigins$idToKeyBindingMap().get(power.getKey().key).method_1434()).toList();
                if (!activePowers.isEmpty()) {
                    client.field_1729.method_1610();
                    this.changeTargetMode(client);
                    this.handleModeChange();
                    renderModeSwitch = true;
                } else {
                    client.field_1729.method_1612();
                    lastUsedPower = null;
                    directionChanged = false;
                    targetDirection = null;
                    renderModeSwitch = false;
                    timer = 0;
                }
            }

            private void changeTargetMode(class_310 client) {
                double x = client.field_1729.method_1603() - (double)((float)client.method_22683().method_4480() / 2.0f);
                double y = (double)((float)client.method_22683().method_4507() / 2.0f) - client.field_1729.method_1604();
                if (Math.abs(x) > 48.0 || Math.abs(y) > 48.0) {
                    RadialMenuDirection direction;
                    switch (class_2350.method_10142((double)x, (double)y, (double)0.0)) {
                        case field_11036: {
                            RadialMenuDirection radialMenuDirection = RadialMenuDirection.UP;
                            break;
                        }
                        case field_11033: {
                            RadialMenuDirection radialMenuDirection = RadialMenuDirection.DOWN;
                            break;
                        }
                        case field_11039: {
                            RadialMenuDirection radialMenuDirection = RadialMenuDirection.LEFT;
                            break;
                        }
                        case field_11034: {
                            RadialMenuDirection radialMenuDirection = RadialMenuDirection.RIGHT;
                            break;
                        }
                        default: {
                            RadialMenuDirection radialMenuDirection = direction = null;
                        }
                    }
                    if (targetDirection != direction) {
                        targetDirection = direction;
                        timer = 0;
                    }
                } else {
                    targetDirection = null;
                    timer = 0;
                }
            }

            private void handleModeChange() {
                if (activePowers.get(0) != lastUsedPower) {
                    timer = 0;
                    lastUsedPower = activePowers.get(0);
                }
                if (targetDirection != null && lastUsedPower.getDirection() != targetDirection && lastUsedPower.getActionFromDirection(targetDirection) != null) {
                    if (!directionChanged) {
                        ++timer;
                    }
                    if (timer == RadialMenuEvents.lastUsedPower.swapTime) {
                        directionChanged = true;
                        timer = 0;
                        ChangeRadialDirectionPacket.send(targetDirection, lastUsedPower.getType());
                    }
                }
            }
        });
        HudRenderCallback.EVENT.register((Object)new HudRenderCallback(){

            public void onHudRender(class_4587 matrixStack, float tickDelta) {
                if (!renderModeSwitch) {
                    return;
                }
                class_310 client = class_310.method_1551();
                RenderSystem.setShaderTexture((int)0, (class_2960)RadialMenuEvents.lastUsedPower.spriteLocation);
                class_332.method_25290((class_4587)matrixStack, (int)(client.method_22683().method_4486() / 2 - 64), (int)(client.method_22683().method_4502() / 2 - 64), (float)0.0f, (float)0.0f, (int)128, (int)128, (int)320, (int)256);
                this.renderSection(RadialMenuDirection.UP, matrixStack, -32, -80, 0);
                this.renderSection(RadialMenuDirection.DOWN, matrixStack, -32, 16, 64);
                this.renderSection(RadialMenuDirection.LEFT, matrixStack, -80, -32, 128);
                this.renderSection(RadialMenuDirection.RIGHT, matrixStack, 16, -32, 192);
                if (timer > 0) {
                    class_332.method_25290((class_4587)matrixStack, (int)(client.method_22683().method_4486() / 2 - 13), (int)(client.method_22683().method_4502() / 2 - 13), (float)48.0f, (float)128.0f, (int)26, (int)26, (int)320, (int)256);
                    class_332.method_25290((class_4587)matrixStack, (int)(client.method_22683().method_4486() / 2 - 12), (int)(client.method_22683().method_4502() / 2 - 12), (float)24.0f, (float)128.0f, (int)24, (int)24, (int)320, (int)256);
                    class_332.method_25290((class_4587)matrixStack, (int)(client.method_22683().method_4486() / 2 - 12), (int)(client.method_22683().method_4502() / 2 - 12), (float)0.0f, (float)128.0f, (int)24, (int)((int)(24.0f - 24.0f * ((float)(timer + 1) / (float)RadialMenuEvents.lastUsedPower.swapTime))), (int)320, (int)256);
                }
                RenderSystem.setShaderTexture((int)0, (class_2960)class_329.field_22737);
            }

            private void renderSection(RadialMenuDirection targetMode, class_4587 matrixStack, int posXOffset, int posYOffset, int v) {
                if (lastUsedPower.getActionFromDirection(targetMode) == null) {
                    return;
                }
                int u = 128;
                if (lastUsedPower.getDirection() == targetMode) {
                    u += 128;
                } else if (targetDirection == targetMode) {
                    u += 64;
                }
                class_332.method_25290((class_4587)matrixStack, (int)(class_310.method_1551().method_22683().method_4486() / 2 + posXOffset), (int)(class_310.method_1551().method_22683().method_4502() / 2 + posYOffset), (float)u, (float)v, (int)64, (int)64, (int)320, (int)256);
            }
        });
    }

    static {
        targetDirection = null;
        renderModeSwitch = false;
        timer = 0;
    }
}

