/*
 * Decompiled with CFR 0.152.
 */
package me.steinborn.krypton.mixin.shared.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import java.util.List;
import me.steinborn.krypton.mod.shared.network.VarintByteDecoder;
import net.minecraft.class_2550;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={class_2550.class})
public class SplitterHandlerMixin {
    private final VarintByteDecoder reader = new VarintByteDecoder();

    @Overwrite
    public void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        this.reader.reset();
        int varintEnd = in.forEachByte((ByteProcessor)this.reader);
        if (varintEnd == -1) {
            return;
        }
        if (this.reader.getResult() == VarintByteDecoder.DecodeResult.SUCCESS) {
            int readLen = this.reader.readVarint();
            if (readLen < 0) {
                throw new DecoderException("Bad packet length");
            }
            if (readLen == 0) {
                in.readerIndex(varintEnd + 1);
            } else {
                int minimumRead = this.reader.varintBytes() + readLen;
                if (in.isReadable(minimumRead)) {
                    out.add(in.retainedSlice(varintEnd + 1, readLen));
                    in.skipBytes(minimumRead);
                }
            }
        } else if (this.reader.getResult() == VarintByteDecoder.DecodeResult.TOO_BIG) {
            throw new DecoderException("Varint too big");
        }
    }
}

