/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.helpers.TickSpeed;
import carpet.network.ServerNetworkHandler;
import carpet.settings.SettingsManager;
import carpet.utils.CarpetProfiler;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class TickCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tick").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandTick))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"rate").executes(c -> TickCommand.queryTps((class_2168)c.getSource()))).then(class_2170.method_9244((String)"rate", (ArgumentType)FloatArgumentType.floatArg((float)0.1f, (float)500.0f)).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"20.0"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.setTps((class_2168)c.getSource(), FloatArgumentType.getFloat((CommandContext)c, (String)"rate")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").executes(c -> TickCommand.setWarp((class_2168)c.getSource(), 0, null))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)0)).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"3600", "72000"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.setWarp((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), null))).then(class_2170.method_9244((String)"tail command", (ArgumentType)StringArgumentType.greedyString()).executes(c -> TickCommand.setWarp((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks"), StringArgumentType.getString((CommandContext)c, (String)"tail command"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"freeze").executes(c -> TickCommand.toggleFreeze((class_2168)c.getSource(), false))).then(class_2170.method_9247((String)"status").executes(c -> TickCommand.freezeStatus((class_2168)c.getSource())))).then(class_2170.method_9247((String)"deep").executes(c -> TickCommand.toggleFreeze((class_2168)c.getSource(), true)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"on").executes(c -> TickCommand.setFreeze((class_2168)c.getSource(), false, true))).then(class_2170.method_9247((String)"deep").executes(c -> TickCommand.setFreeze((class_2168)c.getSource(), true, true))))).then(class_2170.method_9247((String)"off").executes(c -> TickCommand.setFreeze((class_2168)c.getSource(), false, false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"step").executes(c -> TickCommand.step((class_2168)c.getSource(), 1))).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1, (int)72000)).suggests((c, b) -> class_2172.method_9253((String[])new String[]{"20"}, (SuggestionsBuilder)b)).executes(c -> TickCommand.step((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))).then(class_2170.method_9247((String)"superHot").executes(c -> TickCommand.toggleSuperHot((class_2168)c.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"health").executes(c -> TickCommand.healthReport((class_2168)c.getSource(), 100))).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20, (int)24000)).executes(c -> TickCommand.healthReport((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"entities").executes(c -> TickCommand.healthEntities((class_2168)c.getSource(), 100))).then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)20, (int)24000)).executes(c -> TickCommand.healthEntities((class_2168)c.getSource(), IntegerArgumentType.getInteger((CommandContext)c, (String)"ticks")))));
        dispatcher.register(literalargumentbuilder);
    }

    private static int setTps(class_2168 source, float tps) {
        TickSpeed.tickrate(tps, true);
        TickCommand.queryTps(source);
        return (int)tps;
    }

    private static int queryTps(class_2168 source) {
        Messenger.m(source, "w Current tps is: ", String.format("wb %.1f", Float.valueOf(TickSpeed.tickrate)));
        return (int)TickSpeed.tickrate;
    }

    private static int setWarp(class_2168 source, int advance, String tail_command) {
        class_3222 player = null;
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        class_2554 message = TickSpeed.tickrate_advance(player, advance, tail_command, source);
        source.method_9226((class_2561)message, false);
        return 1;
    }

    private static int freezeStatus(class_2168 source) {
        if (TickSpeed.isPaused()) {
            Messenger.m(source, "gi Freeze Status: Game is " + (TickSpeed.deeplyFrozen() ? "deeply " : "") + "frozen");
        } else {
            Messenger.m(source, "gi Freeze Status: Game runs normally");
        }
        return 1;
    }

    private static int setFreeze(class_2168 source, boolean isDeep, boolean freeze) {
        TickSpeed.setFrozenState(freeze, isDeep);
        if (TickSpeed.isPaused()) {
            Messenger.m(source, "gi Game is " + (isDeep ? "deeply " : "") + "frozen");
        } else {
            Messenger.m(source, "gi Game runs normally");
        }
        return 1;
    }

    private static int toggleFreeze(class_2168 source, boolean isDeep) {
        return TickCommand.setFreeze(source, isDeep, !TickSpeed.isPaused());
    }

    private static int step(class_2168 source, int advance) {
        TickSpeed.add_ticks_to_run_in_pause(advance);
        Messenger.m(source, "gi Stepping " + advance + " tick" + (advance != 1 ? "s" : ""));
        return 1;
    }

    private static int toggleSuperHot(class_2168 source) {
        TickSpeed.is_superHot = !TickSpeed.is_superHot;
        ServerNetworkHandler.updateSuperHotStateToConnectedPlayers();
        if (TickSpeed.is_superHot) {
            Messenger.m(source, "gi Superhot enabled");
        } else {
            Messenger.m(source, "gi Superhot disabled");
        }
        return 1;
    }

    public static int healthReport(class_2168 source, int ticks) {
        CarpetProfiler.prepare_tick_report(source, ticks);
        return 1;
    }

    public static int healthEntities(class_2168 source, int ticks) {
        CarpetProfiler.prepare_entity_report(source, ticks);
        return 1;
    }
}

