/*
 * Decompiled with CFR 0.152.
 */
package carpet.logging.logHelpers;

import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.utils.Messenger;
import java.util.ArrayList;
import net.minecraft.class_243;
import net.minecraft.class_2554;

public class TrajectoryLogHelper {
    private static final int MAX_TICKS_PER_LINE = 20;
    private boolean doLog;
    private Logger logger;
    private ArrayList<class_243> positions = new ArrayList();
    private ArrayList<class_243> motions = new ArrayList();

    public TrajectoryLogHelper(String logName) {
        this.logger = LoggerRegistry.getLogger(logName);
        this.doLog = this.logger.hasOnlineSubscribers();
    }

    public void onTick(double x, double y, double z, class_243 velocity) {
        if (!this.doLog) {
            return;
        }
        this.positions.add(new class_243(x, y, z));
        this.motions.add(velocity);
    }

    public void onFinish() {
        if (!this.doLog) {
            return;
        }
        this.logger.log(option -> {
            ArrayList<class_2554> comp = new ArrayList<class_2554>();
            switch (option) {
                case "brief": {
                    comp.add(Messenger.s(""));
                    ArrayList<String> line = new ArrayList<String>();
                    for (int i = 0; i < this.positions.size(); ++i) {
                        class_243 pos = this.positions.get(i);
                        class_243 mot = this.motions.get(i);
                        line.add("w  x");
                        line.add(String.format("^w Tick: %d\nx: %f\ny: %f\nz: %f\n------------\nmx: %f\nmy: %f\nmz: %f", i, pos.field_1352, pos.field_1351, pos.field_1350, mot.field_1352, mot.field_1351, mot.field_1350));
                        if ((i + 1) % 20 != 0 && i != this.positions.size() - 1) continue;
                        comp.add(Messenger.c(line.toArray(new Object[0])));
                        line.clear();
                    }
                    break;
                }
                case "full": {
                    comp.add(Messenger.c("w ---------"));
                    for (int i = 0; i < this.positions.size(); ++i) {
                        class_243 pos = this.positions.get(i);
                        class_243 mot = this.motions.get(i);
                        comp.add(Messenger.c(String.format("w tick: %3d pos", i), Messenger.dblt("w", pos.field_1352, pos.field_1351, pos.field_1350), "w   mot", Messenger.dblt("w", mot.field_1352, mot.field_1351, mot.field_1350)));
                    }
                    break;
                }
            }
            return comp.toArray(new class_2554[0]);
        });
        this.doLog = false;
    }
}

