/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.bundled;

import carpet.script.bundled.Module;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Locale;

public class FileModule
extends Module {
    private String name;
    private String code;
    private boolean library;

    public FileModule(Path sourcePath) {
        this.library = sourcePath.getFileName().toString().endsWith(".scl");
        try {
            this.name = sourcePath.getFileName().toString().replaceFirst("\\.scl?", "").toLowerCase(Locale.ROOT);
            this.code = new String(Files.readAllBytes(sourcePath), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            this.name = null;
            this.code = null;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public boolean isLibrary() {
        return this.library;
    }
}

