/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.language;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.AbstractListValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Iterator;

public class Loops {
    public static void apply(Expression expression) {
        expression.addImpureFunction("break", lv -> {
            if (lv.size() == 0) {
                throw new BreakStatement(null);
            }
            if (lv.size() == 1) {
                throw new BreakStatement((Value)lv.get(0));
            }
            throw new InternalExpressionException("'break' can only be called with zero or one argument");
        });
        expression.addImpureFunction("continue", lv -> {
            if (lv.size() == 0) {
                throw new ContinueStatement(null);
            }
            if (lv.size() == 1) {
                throw new ContinueStatement((Value)lv.get(0));
            }
            throw new InternalExpressionException("'continue' can only be called with zero or one argument");
        });
        expression.addLazyFunction("while", 3, (c, t, lv) -> {
            long limit = NumericValue.asNumber(((LazyValue)lv.get(1)).evalValue((Context)c)).getLong();
            LazyValue condition = (LazyValue)lv.get(0);
            LazyValue expr = (LazyValue)lv.get(2);
            long i = 0L;
            Value lastOne = Value.NULL;
            LazyValue _val = c.getVariable("_");
            c.setVariable("_", (cc, tt) -> new NumericValue(0L).bindTo("_"));
            while (i < limit && condition.evalValue((Context)c, Context.BOOLEAN).getBoolean()) {
                try {
                    lastOne = expr.evalValue((Context)c, (Context.Type)((Object)t));
                }
                catch (BreakStatement | ContinueStatement stmt) {
                    if (stmt.retval != null) {
                        lastOne = stmt.retval;
                    }
                    if (stmt instanceof BreakStatement) break;
                }
                long seriously = ++i;
                c.setVariable("_", (cc, tt) -> new NumericValue(seriously).bindTo("_"));
            }
            c.setVariable("_", _val);
            NullValue lastValueNoKidding = lastOne;
            return (cc, tt) -> lastValueNoKidding;
        });
        expression.addLazyFunction("loop", 2, (c, t, lv) -> {
            long limit = NumericValue.asNumber(((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE)).getLong();
            Value lastOne = Value.NULL;
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            for (long i = 0L; i < limit; ++i) {
                long whyYouAsk = i;
                c.setVariable("_", (cc, tt) -> new NumericValue(whyYouAsk).bindTo("_"));
                try {
                    lastOne = expr.evalValue((Context)c, (Context.Type)((Object)t));
                    continue;
                }
                catch (BreakStatement | ContinueStatement stmt) {
                    if (stmt.retval != null) {
                        lastOne = stmt.retval;
                    }
                    if (stmt instanceof BreakStatement) break;
                }
            }
            c.setVariable("_", _val);
            NullValue trulyLastOne = lastOne;
            return (cc, tt) -> trulyLastOne;
        });
        expression.addLazyFunction("map", 2, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return ListValue.lazyEmpty();
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'map' function should be a list or iterator");
            }
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            LazyValue _iter = c.getVariable("_i");
            ArrayList<Value> result = new ArrayList<Value>();
            int i = 0;
            while (iterator.hasNext()) {
                String var;
                block6: {
                    Value next = iterator.next();
                    var = next.boundVariable;
                    next.bindTo("_");
                    int doYouReally = i;
                    c.setVariable("_", (cc, tt) -> next);
                    c.setVariable("_i", (cc, tt) -> new NumericValue(doYouReally).bindTo("_i"));
                    try {
                        result.add(expr.evalValue((Context)c, (Context.Type)((Object)t)));
                    }
                    catch (BreakStatement | ContinueStatement stmt) {
                        if (stmt.retval != null) {
                            result.add(stmt.retval);
                        }
                        if (!(stmt instanceof BreakStatement)) break block6;
                        next.boundVariable = var;
                        break;
                    }
                }
                next.boundVariable = var;
                ++i;
            }
            ((AbstractListValue)rval).fatality();
            ListValue ret = ListValue.wrap(result);
            c.setVariable("_", _val);
            c.setVariable("_i", _iter);
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("filter", 2, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return ListValue.lazyEmpty();
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'filter' function should be a list or iterator");
            }
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            LazyValue _iter = c.getVariable("_i");
            ArrayList<Value> result = new ArrayList<Value>();
            int i = 0;
            while (iterator.hasNext()) {
                String var;
                block6: {
                    Value next = iterator.next();
                    var = next.boundVariable;
                    next.bindTo("_");
                    int seriously = i;
                    c.setVariable("_", (cc, tt) -> next);
                    c.setVariable("_i", (cc, tt) -> new NumericValue(seriously).bindTo("_i"));
                    try {
                        if (!expr.evalValue((Context)c, Context.BOOLEAN).getBoolean()) break block6;
                        result.add(next);
                    }
                    catch (BreakStatement | ContinueStatement stmt) {
                        if (stmt.retval != null && stmt.retval.getBoolean()) {
                            result.add(next);
                        }
                        if (!(stmt instanceof BreakStatement)) break block6;
                        next.boundVariable = var;
                        break;
                    }
                }
                next.boundVariable = var;
                ++i;
            }
            ((AbstractListValue)rval).fatality();
            ListValue ret = ListValue.wrap(result);
            c.setVariable("_", _val);
            c.setVariable("_i", _iter);
            return (cc, tt) -> ret;
        });
        expression.addLazyFunction("first", 2, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return LazyValue.NULL;
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'first' function should be a list or iterator");
            }
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            LazyValue _iter = c.getVariable("_i");
            Value result = Value.NULL;
            int i = 0;
            while (iterator.hasNext()) {
                Value next = iterator.next();
                String var = next.boundVariable;
                next.bindTo("_");
                int seriously = i++;
                c.setVariable("_", (cc, tt) -> next);
                c.setVariable("_i", (cc, tt) -> new NumericValue(seriously).bindTo("_i"));
                try {
                    if (expr.evalValue((Context)c, Context.BOOLEAN).getBoolean()) {
                        result = next;
                        next.boundVariable = var;
                        break;
                    }
                }
                catch (BreakStatement stmt) {
                    result = stmt.retval == null ? next : stmt.retval;
                    next.boundVariable = var;
                    break;
                }
                catch (ContinueStatement ignored) {
                    throw new InternalExpressionException("'continue' inside 'first' function has no sense");
                }
                next.boundVariable = var;
            }
            ((AbstractListValue)rval).fatality();
            NullValue whyWontYouTrustMeJava = result;
            c.setVariable("_", _val);
            c.setVariable("_i", _iter);
            return (cc, tt) -> whyWontYouTrustMeJava;
        });
        expression.addLazyFunction("all", 2, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return LazyValue.TRUE;
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'all' function should be a list or iterator");
            }
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            LazyValue _iter = c.getVariable("_i");
            LazyValue result = LazyValue.TRUE;
            int i = 0;
            while (iterator.hasNext()) {
                Value next = iterator.next();
                String var = next.boundVariable;
                next.bindTo("_");
                int seriously = i++;
                c.setVariable("_", (cc, tt) -> next);
                c.setVariable("_i", (cc, tt) -> new NumericValue(seriously).bindTo("_i"));
                if (!expr.evalValue((Context)c, Context.BOOLEAN).getBoolean()) {
                    result = LazyValue.FALSE;
                    next.boundVariable = var;
                    break;
                }
                next.boundVariable = var;
            }
            ((AbstractListValue)rval).fatality();
            c.setVariable("_", _val);
            c.setVariable("_i", _iter);
            return result;
        });
        expression.addLazyFunction("c_for", 4, (c, t, lv) -> {
            LazyValue initial = (LazyValue)lv.get(0);
            LazyValue condition = (LazyValue)lv.get(1);
            LazyValue increment = (LazyValue)lv.get(2);
            LazyValue body = (LazyValue)lv.get(3);
            int iterations = 0;
            initial.evalValue((Context)c, Context.VOID);
            while (condition.evalValue((Context)c, Context.BOOLEAN).getBoolean()) {
                try {
                    body.evalValue((Context)c, Context.VOID);
                }
                catch (BreakStatement stmt) {
                    break;
                }
                catch (ContinueStatement stmt) {
                    // empty catch block
                }
                ++iterations;
                increment.evalValue((Context)c, Context.VOID);
            }
            int finalIterations = iterations;
            return (cc, tt) -> new NumericValue(finalIterations);
        });
        expression.addLazyFunction("for", 2, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return LazyValue.ZERO;
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'for' function should be a list or iterator");
            }
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            LazyValue expr = (LazyValue)lv.get(1);
            LazyValue _val = c.getVariable("_");
            LazyValue _ite = c.getVariable("_i");
            int successCount = 0;
            int i = 0;
            while (iterator.hasNext()) {
                Value result;
                String var;
                block7: {
                    Value next = iterator.next();
                    var = next.boundVariable;
                    next.bindTo("_");
                    int seriously = i;
                    c.setVariable("_", (cc, tt) -> next);
                    c.setVariable("_i", (cc, tt) -> new NumericValue(seriously).bindTo("_i"));
                    result = Value.FALSE;
                    try {
                        result = expr.evalValue((Context)c, (Context.Type)((Object)t));
                    }
                    catch (BreakStatement | ContinueStatement stmt) {
                        if (stmt.retval != null) {
                            result = stmt.retval;
                        }
                        if (!(stmt instanceof BreakStatement)) break block7;
                        next.boundVariable = var;
                        break;
                    }
                }
                if (t != Context.VOID && result.getBoolean()) {
                    ++successCount;
                }
                next.boundVariable = var;
                ++i;
            }
            ((AbstractListValue)rval).fatality();
            c.setVariable("_", _val);
            c.setVariable("_i", _ite);
            long promiseWontChange = successCount;
            return (cc, tt) -> new NumericValue(promiseWontChange);
        });
        expression.addLazyFunction("reduce", 3, (c, t, lv) -> {
            Value rval = ((LazyValue)lv.get(0)).evalValue((Context)c, Context.NONE);
            if (rval.isNull()) {
                return ListValue.lazyEmpty();
            }
            if (!(rval instanceof AbstractListValue)) {
                throw new InternalExpressionException("First argument of 'reduce' should be a list or iterator");
            }
            LazyValue expr = (LazyValue)lv.get(1);
            Value acc = ((LazyValue)lv.get(2)).evalValue((Context)c, Context.NONE);
            Iterator<Value> iterator = ((AbstractListValue)rval).iterator();
            if (!iterator.hasNext()) {
                Value seriouslyWontChange = acc;
                return (cc, tt) -> seriouslyWontChange;
            }
            LazyValue _val = c.getVariable("_");
            LazyValue _acc = c.getVariable("_a");
            LazyValue _ite = c.getVariable("_i");
            int i = 0;
            while (iterator.hasNext()) {
                String var;
                block7: {
                    Value next = iterator.next();
                    var = next.boundVariable;
                    next.bindTo("_");
                    Value promiseWontChangeYou = acc;
                    int seriously = i;
                    c.setVariable("_a", (cc, tt) -> promiseWontChangeYou.bindTo("_a"));
                    c.setVariable("_", (cc, tt) -> next);
                    c.setVariable("_i", (cc, tt) -> new NumericValue(seriously).bindTo("_i"));
                    try {
                        acc = expr.evalValue((Context)c, (Context.Type)((Object)t));
                    }
                    catch (BreakStatement | ContinueStatement stmt) {
                        if (stmt.retval != null) {
                            acc = stmt.retval;
                        }
                        if (!(stmt instanceof BreakStatement)) break block7;
                        next.boundVariable = var;
                        break;
                    }
                }
                next.boundVariable = var;
                ++i;
            }
            ((AbstractListValue)rval).fatality();
            c.setVariable("_a", _acc);
            c.setVariable("_", _val);
            c.setVariable("_i", _ite);
            Value hopeItsEnoughPromise = acc;
            return (cc, tt) -> hopeItsEnoughPromise;
        });
    }
}

